/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractDataTree {
    private boolean immutable = false;
    protected static final IPath[] NO_CHILDREN = new IPath[0];

    public AbstractDataTree() {
        this.empty();
    }

    protected AbstractDataTree copy() {
        AbstractDataTree newTree = this.createInstance();
        newTree.setImmutable(this.isImmutable());
        newTree.setRootNode(this.getRootNode());
        return newTree;
    }

    protected abstract AbstractDataTree createInstance();

    public abstract void empty();

    public IPath[] getChildren(IPath parentKey) {
        String[] names = this.getNamesOfChildren(parentKey);
        int len = names.length;
        if (len == 0) {
            return NO_CHILDREN;
        }
        IPath[] answer = new IPath[len];
        int i = 0;
        while (i < len) {
            answer[i] = parentKey.append(names[i]);
            ++i;
        }
        return answer;
    }

    public abstract String[] getNamesOfChildren(IPath var1);

    AbstractDataTreeNode getRootNode() {
        throw new AbstractMethodError(Messages.dtree_subclassImplement);
    }

    static void handleImmutableTree() {
        throw new RuntimeException(Messages.dtree_immutable);
    }

    static void handleNotFound(IPath key) {
        throw new ObjectNotFoundException(NLS.bind(Messages.dtree_notFound, key));
    }

    public void immutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public IPath rootKey() {
        return Path.ROOT;
    }

    void setImmutable(boolean bool) {
        this.immutable = bool;
    }

    void setRootNode(AbstractDataTreeNode node) {
        throw new Error(Messages.dtree_subclassImplement);
    }
}

