/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.range;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraftforge.srg2source.range.IRange;
import net.minecraftforge.srg2source.range.entries.MetaEntry;
import net.minecraftforge.srg2source.range.entries.RangeEntry;
import net.minecraftforge.srg2source.range.entries.StructuralEntry;
import net.minecraftforge.srg2source.util.Util;

public class RangeMap {
    private final int SPEC = 1;
    private final String filename;
    private final String hash;
    private final List<RangeEntry> entries;
    private final List<StructuralEntry> structures;
    private final List<MetaEntry> meta;

    public static Map<String, RangeMap> readAll(InputStream stream) throws IOException {
        HashMap<String, RangeMap> ret = new HashMap<String, RangeMap>();
        List<String> lines = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
        for (int x = 0; x < lines.size(); ++x) {
            String line = RangeMap.stripComment((String)lines.get(x)).trim();
            if (line.isEmpty()) continue;
            if (line.startsWith("start ")) {
                int end;
                List<String> pts = Util.unquote(line, 3);
                if (pts.size() != 4) {
                    throw new IllegalArgumentException("Invalid RangeMap line #" + x + ": " + (String)lines.get(x));
                }
                int spec = -1;
                try {
                    spec = Integer.parseInt(pts.get(1));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid RangeMap line #" + x + ": " + (String)lines.get(x));
                }
                for (end = x + 1; end < lines.size() && !"end".equals(RangeMap.stripComment((String)lines.get(end))); ++end) {
                }
                if (end == lines.size()) {
                    throw new IllegalArgumentException("Invalid RangeMap. Start on line #" + x + " with no end");
                }
                if (spec != 1) {
                    throw new IllegalArgumentException("Invalid RangeMap line #" + x + " Unknown Spec: " + (String)lines.get(x));
                }
                ret.put(pts.get(2), new RangeMap(spec, pts.get(2), pts.get(3), lines, x + 1, end));
                x = end;
                continue;
            }
            if (!"end".equals(RangeMap.stripComment(line))) continue;
            throw new IllegalArgumentException("Invalid RangeMap. End on line #" + x + " with no start");
        }
        return ret;
    }

    private RangeMap(int spec, String filename, String hash, List<String> lines, int start, int end) {
        this.filename = filename;
        this.hash = hash;
        ArrayList<RangeEntry> entries = new ArrayList<RangeEntry>();
        ArrayList<StructuralEntry> structures = new ArrayList<StructuralEntry>();
        ArrayList<MetaEntry> meta = new ArrayList<MetaEntry>();
        this.entries = Collections.unmodifiableList(entries);
        this.structures = Collections.unmodifiableList(structures);
        this.meta = Collections.unmodifiableList(meta);
        for (int x = start; x < end; ++x) {
            String line = RangeMap.stripComment(lines.get(x)).trim();
            if (line.isEmpty()) continue;
            int idx = line.indexOf(32);
            if (idx == -1) {
                throw new IllegalArgumentException("Invalid RangeMap line #" + x + ": " + lines.get(x));
            }
            try {
                String type = line.substring(0, idx);
                if ("meta".equals(type)) {
                    meta.add(MetaEntry.read(spec, line.substring(idx + 1)));
                    continue;
                }
                if (type.endsWith("def")) {
                    structures.add(StructuralEntry.read(spec, type.substring(0, type.length() - 3), line.substring(idx + 1)));
                    continue;
                }
                entries.add(RangeEntry.read(spec, type, line.substring(idx + 1)));
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid RangeMap line #" + x + ": " + lines.get(x), e);
            }
        }
    }

    RangeMap(String filename, String hash, List<RangeEntry> entries, List<StructuralEntry> structures, List<MetaEntry> meta) {
        this.filename = filename;
        this.hash = hash;
        this.entries = Collections.unmodifiableList(entries);
        this.structures = Collections.unmodifiableList(structures);
        this.meta = Collections.unmodifiableList(meta);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getHash() {
        return this.hash;
    }

    public List<RangeEntry> getEntries() {
        return this.entries;
    }

    public List<StructuralEntry> getStructures() {
        return this.structures;
    }

    public List<MetaEntry> getMeta() {
        return this.meta;
    }

    public void write(PrintWriter out, boolean pretty) {
        Writer writer = new Writer(out);
        writer.accept(Util.quote("start", Integer.toString(1), this.filename, this.hash));
        if (!this.meta.isEmpty()) {
            if (pretty) {
                writer.accept("# Start Meta");
                writer.tabs++;
            }
            for (MetaEntry entry : this.meta) {
                entry.write(writer);
            }
            if (pretty) {
                writer.tabs--;
                writer.accept("# End Meta");
            }
        }
        Stack<StructuralEntry> stack = new Stack<StructuralEntry>();
        Iterator<StructuralEntry> segments = this.structures.iterator();
        StructuralEntry last = null;
        StructuralEntry next = segments.hasNext() ? segments.next() : null;
        for (RangeEntry entry : this.entries) {
            if (pretty) {
                while (last != null && entry.getStart() >= this.end(last)) {
                    writer.tabs--;
                    writer.accept("# End " + last.getType().name());
                    last = stack.empty() ? null : (StructuralEntry)stack.pop();
                }
            }
            if (next != null && entry.getStart() > next.getStart()) {
                next.write(writer);
                if (pretty) {
                    writer.accept("# Start " + next.getType().name() + ' ' + next.getName() + (next.getDescriptor() == null ? "" : next.getDescriptor()));
                    writer.tabs++;
                    if (last != null) {
                        stack.push(last);
                    }
                    last = next;
                    next = segments.hasNext() ? segments.next() : null;
                }
            }
            entry.write(writer);
        }
        if (next != null) {
            next.write(writer);
            while (segments.hasNext()) {
                segments.next().write(writer);
            }
        }
        if (pretty) {
            while (last != null) {
                writer.tabs--;
                writer.accept("# End " + last.getType().name());
                last = stack.empty() ? null : (StructuralEntry)stack.pop();
            }
        }
        writer.tabs = 0;
        writer.accept("end");
    }

    private int end(IRange e) {
        return e.getStart() + e.getLength();
    }

    private static String stripComment(String line) {
        int idx = line.indexOf(35);
        return idx == -1 ? line : line.substring(0, idx);
    }

    private static class Writer
    implements Consumer<String> {
        private int tabs = 0;
        private final PrintWriter out;

        private Writer(PrintWriter out) {
            this.out = out;
        }

        @Override
        public void accept(String line) {
            for (int x = 0; x < this.tabs; ++x) {
                this.out.write("  ");
            }
            this.out.print(line + '\n');
        }
    }
}

