/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.mixin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraftforge.srg2source.extract.ExtractUtil;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;

public class MixinInfo {
    private final String owner;
    private final ITypeBinding ownerType;
    private String target;
    private final Set<String> targets = new HashSet<String>();
    private final Map<String, ITypeBinding> targetTypes = new HashMap<String, ITypeBinding>();
    private final Map<String, ShadowInfo> shadows = new HashMap<String, ShadowInfo>();
    private final List<InterfaceInfo> interfaces = new ArrayList<InterfaceInfo>();
    private final Set<String> overwrites = new HashSet<String>();

    public MixinInfo(String owner, ITypeBinding ownerType) {
        this.owner = owner;
        this.ownerType = ownerType;
    }

    public boolean isValid() {
        return !this.targets.isEmpty();
    }

    public String getOwner() {
        return this.owner;
    }

    public ITypeBinding getOwnerType() {
        return this.ownerType;
    }

    public String getTarget() {
        return this.targets.size() == 1 ? this.target : null;
    }

    public ITypeBinding getTargetType() {
        return this.targets.size() == 1 ? this.getTargetType(this.target) : null;
    }

    public ITypeBinding getTargetType(String target) {
        return this.targetTypes.computeIfAbsent(target, t -> null);
    }

    public Set<String> getTargets() {
        return this.targets;
    }

    public void addTarget(String name) {
        this.addTarget(name, null);
    }

    public void addTarget(String name, ITypeBinding bind) {
        this.targets.add(name);
        if (bind != null) {
            this.targetTypes.put(name, bind);
        }
        if (this.target == null) {
            this.target = name;
        }
    }

    public void addShadow(String name, String desc, String prefix) {
        this.shadows.put(name + ' ' + desc, new ShadowInfo(name, desc, prefix));
    }

    public ShadowInfo getShadow(String name, String desc) {
        return this.shadows.get(name + ' ' + desc);
    }

    public void addInterface(String prefix, Type type) {
        this.interfaces.add(new InterfaceInfo(prefix, type));
    }

    public List<InterfaceInfo> getInterfaces() {
        return this.interfaces;
    }

    public String getShadedOwner(String name, String desc) {
        return this.target != null && this.shadows.containsKey(name + ' ' + desc) ? this.target : null;
    }

    public void addOverwrite(String name, String desc) {
        this.overwrites.add(name + desc);
    }

    public boolean isOverwrite(String name, String desc) {
        return this.overwrites.contains(name + desc);
    }

    public String toString() {
        return "Mixin[" + this.targets.stream().collect(Collectors.joining(",")) + ']';
    }

    public class InterfaceInfo {
        private final String target;
        private final ITypeBinding type;
        private final String prefix;
        private final Map<String, String> methods;

        private InterfaceInfo(String prefix, Type type) {
            this.prefix = prefix;
            this.type = type.resolveBinding();
            this.target = ExtractUtil.getInternalName(this.type);
            this.methods = this.buildMethods(this.type, new HashMap<String, String>());
        }

        private Map<String, String> buildMethods(ITypeBinding binding, Map<String, String> ret) {
            for (IMethodBinding iMethodBinding : binding.getDeclaredMethods()) {
                String key = iMethodBinding.getName() + ExtractUtil.getDescriptor(iMethodBinding);
                if (ret.containsKey(key)) continue;
                ret.put(key, ExtractUtil.getInternalName(ExtractUtil.findRoot(iMethodBinding).getDeclaringClass()));
            }
            for (IBinding iBinding : binding.getInterfaces()) {
                this.buildMethods((ITypeBinding)iBinding, ret);
            }
            return ret;
        }

        public String getTarget() {
            return this.target;
        }

        public ITypeBinding getType() {
            return this.type;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String toString() {
            return "Interface[" + this.getTarget() + ", " + this.getPrefix() + ']';
        }

        public String findOwner(String name, String desc) {
            String key = (name.startsWith(this.prefix) ? name.substring(this.prefix.length()) : name) + desc;
            return this.methods.get(key);
        }
    }

    public static class AccessorName {
        private static final Pattern REGEX = Pattern.compile("^(" + Arrays.stream(AccessorType.values()).map(e -> AccessorType.access$300(e)).flatMap(Arrays::stream).collect(Collectors.joining("|")) + ")(([A-Z])(.*?))(_\\$md.*)?$");
        private final AccessorType type;
        private final String methodName;
        private final String target;
        private final String prefix;

        public static AccessorName from(String methodName, String owner, String value) {
            boolean isUpper;
            Matcher matcher = REGEX.matcher(methodName);
            if (!matcher.matches()) {
                return null;
            }
            String prefix = matcher.group(1);
            AccessorType type = AccessorType.getByPrefix(prefix);
            if (type == null) {
                return null;
            }
            boolean bl = isUpper = type != AccessorType.FACTORY && matcher.group(2).toUpperCase(Locale.ROOT).equals(matcher.group(2));
            String target = value != null ? value : (isUpper ? matcher.group(2) : matcher.group(3).toLowerCase(Locale.ROOT) + matcher.group(4));
            return new AccessorName(type, methodName, target, prefix);
        }

        private AccessorName(AccessorType type, String methodName, String target, String prefix) {
            this.type = type;
            this.methodName = methodName;
            this.target = target;
            this.prefix = prefix;
        }

        public AccessorType getType() {
            return this.type;
        }

        public String getMethod() {
            return this.methodName;
        }

        public String getTarget() {
            return this.target;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String toString() {
            return "AccessorName[type=" + this.type.name() + ",method=" + this.methodName + ",target=" + this.target + ",prefix=" + this.prefix + ']';
        }
    }

    public static enum AccessorType {
        GETTER("get", "is"),
        SETTER("set"),
        PROXY("call", "invoke"),
        FACTORY("new", "create");

        private final String[] prefixes;

        private AccessorType(String ... prefixes) {
            this.prefixes = prefixes;
        }

        private String[] getPrefixes() {
            return this.prefixes;
        }

        private static AccessorType getByPrefix(String prefix) {
            for (AccessorType e : AccessorType.values()) {
                for (String v : e.getPrefixes()) {
                    if (!v.equals(prefix)) continue;
                    return e;
                }
            }
            return null;
        }
    }

    public class ShadowInfo {
        private final String name;
        private final String desc;
        private final String prefix;

        private ShadowInfo(String name, String desc, String prefix) {
            this.name = name;
            this.desc = desc;
            this.prefix = prefix;
        }

        public String toString() {
            return "Shadow[" + this.name + ' ' + this.desc + ' ' + this.prefix + ']';
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

