/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.extract;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.srg2source.extract.ExtractUtil;
import net.minecraftforge.srg2source.extract.SymbolReferenceWalker;
import net.minecraftforge.srg2source.mixin.IAnnotationProcessor;
import net.minecraftforge.srg2source.mixin.MixinAnnotation;
import net.minecraftforge.srg2source.mixin.MixinInfo;
import net.minecraftforge.srg2source.range.RangeMapBuilder;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

public class MixinProcessor {
    private final SymbolReferenceWalker walker;
    private final Map<String, MixinInfo> mixins = new HashMap<String, MixinInfo>();
    private final Map<MixinAnnotation, IAnnotationProcessor> annotations = new EnumMap<MixinAnnotation, IAnnotationProcessor>(MixinAnnotation.class);

    MixinProcessor(SymbolReferenceWalker walker) {
        this.walker = walker;
    }

    boolean process(NormalAnnotation node, String name) {
        IAnnotationProcessor proc = this.getProcessor(name);
        return proc == null ? true : proc.process(node);
    }

    boolean process(SingleMemberAnnotation node, String name) {
        IAnnotationProcessor proc = this.getProcessor(name);
        return proc == null ? true : proc.process(node);
    }

    boolean process(MarkerAnnotation node, String name) {
        IAnnotationProcessor proc = this.getProcessor(name);
        return proc == null ? true : proc.process(node);
    }

    public MixinInfo getInfo(String owner) {
        return this.mixins.get(owner);
    }

    public MixinInfo getOrCreateInfo(ITypeBinding owner) {
        String name = ExtractUtil.getInternalName(this.getBuilder().getFilename(), owner, null);
        return this.mixins.computeIfAbsent(name, k -> new MixinInfo(name, owner));
    }

    public SymbolReferenceWalker getWalker() {
        return this.walker;
    }

    public RangeMapBuilder getBuilder() {
        return this.walker.getBuilder();
    }

    private IAnnotationProcessor getProcessor(String type) {
        MixinAnnotation ann = MixinAnnotation.getByType(type);
        if (ann == null) {
            return null;
        }
        return this.annotations.computeIfAbsent(ann, k -> k.newInstance(this));
    }

    String getFieldOwner(String owner, String name, String type) {
        MixinInfo info = this.mixins.get(owner);
        if (info == null) {
            return owner;
        }
        String ret = info.getShadedOwner(name, type);
        return ret == null ? owner : ret;
    }

    boolean processMethodReference(SimpleName node, IMethodBinding root, String owner, String name, String desc) {
        MixinInfo info = this.mixins.get(owner);
        if (info == null || info.getTarget() == null) {
            return false;
        }
        if (info.isOverwrite(name, desc)) {
            IMethodBinding mtd = ExtractUtil.findRoot(info.getTargetType(), name, desc);
            String towner = ExtractUtil.getInternalName("{unknown}", mtd.getDeclaringClass(), node);
            this.getBuilder().addMethodReference(node.getStartPosition(), node.getLength(), node.toString(), towner, name, desc);
            return true;
        }
        MixinInfo.ShadowInfo shadow = info.getShadow(name, desc);
        if (shadow != null) {
            int offset = 0;
            if (shadow.getPrefix() != null && name.startsWith(shadow.getPrefix())) {
                offset = shadow.getPrefix().length();
            }
            this.getBuilder().addMethodReference(node.getStartPosition() + offset, node.getLength() - offset, node.toString().substring(offset), info.getTarget(), name.substring(offset), desc);
            return true;
        }
        for (MixinInfo.InterfaceInfo iinfo : info.getInterfaces()) {
            String iowner = iinfo.findOwner(name, desc);
            if (iowner == null) continue;
            int offset = name.startsWith(iinfo.getPrefix()) ? iinfo.getPrefix().length() : 0;
            this.getBuilder().addMethodReference(node.getStartPosition() + offset, node.getLength() - offset, node.toString().substring(offset), iowner, name.substring(offset), desc);
            return true;
        }
        return false;
    }
}

