/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher.api;

import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.Objects;
import java.util.Set;

public interface ITransformer<T> {
    public T transform(T var1, ITransformerVotingContext var2);

    public TransformerVoteResult castVote(ITransformerVotingContext var1);

    public Set<Target> targets();

    public static final class Target {
        private final String className;
        private final String elementName;
        private final String elementDescriptor;
        private final TargetType targetType;

        Target(String className, String elementName, String elementDescriptor, TargetType targetType) {
            Objects.requireNonNull(className, "Class Name cannot be null");
            Objects.requireNonNull(elementName, "Element Name cannot be null");
            Objects.requireNonNull(elementDescriptor, "Element Descriptor cannot be null");
            Objects.requireNonNull(targetType, "Target Type cannot be null");
            this.className = className;
            this.elementName = elementName;
            this.elementDescriptor = elementDescriptor;
            this.targetType = targetType;
        }

        public static Target targetClass(String className) {
            return new Target(className, "", "", TargetType.CLASS);
        }

        public String getClassName() {
            return this.className;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getElementDescriptor() {
            return this.elementDescriptor;
        }

        public TargetType getTargetType() {
            return this.targetType;
        }
    }

    public static enum TargetType {
        CLASS,
        METHOD,
        FIELD;

    }
}

