/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.application;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.app.AppPersistence;
import org.osgi.service.application.ApplicationAdminPermission;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;

public abstract class ApplicationDescriptor {
    private final String pid;
    private final boolean[] locked = new boolean[1];
    private static final Collection scalars = Arrays.asList(String.class, Integer.class, Long.class, Float.class, Double.class, Byte.class, Short.class, Character.class, Boolean.class);
    private static final Collection scalarsArrays = Arrays.asList(String[].class, Integer[].class, Long[].class, Float[].class, Double[].class, Byte[].class, Short[].class, Character[].class, Boolean[].class);
    private static final Collection primitiveArrays = Arrays.asList(long[].class, int[].class, short[].class, char[].class, byte[].class, double[].class, float[].class, boolean[].class);

    protected ApplicationDescriptor(String applicationId) {
        if (applicationId == null) {
            throw new NullPointerException("Application ID must not be null!");
        }
        this.pid = applicationId;
        this.locked[0] = this.isPersistentlyLocked();
    }

    public final String getApplicationId() {
        return this.pid;
    }

    public abstract boolean matchDNChain(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ApplicationHandle launch(Map arguments) throws ApplicationException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ApplicationAdminPermission(this, "lifecycle"));
        }
        boolean[] blArray = this.locked;
        synchronized (this.locked) {
            if (this.locked[0]) {
                throw new ApplicationException(1, "Application is locked, can't launch!");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!this.isLaunchableSpecific()) {
                throw new ApplicationException(2, "Cannot launch the application!");
            }
            ApplicationDescriptor.checkArgs(arguments, false);
            try {
                return this.launchSpecific(arguments);
            }
            catch (IllegalStateException ise) {
                throw ise;
            }
            catch (SecurityException se) {
                throw se;
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (Exception t) {
                throw new ApplicationException(3, (Throwable)t);
            }
        }
    }

    protected abstract ApplicationHandle launchSpecific(Map var1) throws Exception;

    protected abstract boolean isLaunchableSpecific();

    private boolean isPersistentlyLocked() {
        return AppPersistence.isLocked(this);
    }

    private static Map checkArgs(Map arguments, boolean validateValues) throws ApplicationException {
        if (arguments == null) {
            return arguments;
        }
        HashMap copy = validateValues ? new HashMap() : null;
        for (Map.Entry entry : arguments.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Invalid key type: " + entry.getKey() == null ? "<null>" : entry.getKey().getClass().getName());
            }
            if ("".equals(entry.getKey())) {
                throw new IllegalArgumentException("Empty string is an invalid key");
            }
            if (!validateValues) continue;
            ApplicationDescriptor.validateValue(entry, copy);
        }
        return validateValues ? copy : arguments;
    }

    private static void validateValue(Map.Entry entry, Map copy) throws ApplicationException {
        Class<?> clazz = entry.getValue().getClass();
        if (scalars.contains(clazz)) {
            copy.put(entry.getKey(), entry.getValue());
            return;
        }
        if (scalarsArrays.contains(clazz) || primitiveArrays.contains(clazz)) {
            int arrayLength = Array.getLength(entry.getValue());
            Object copyOfArray = Array.newInstance(entry.getValue().getClass().getComponentType(), arrayLength);
            System.arraycopy(entry.getValue(), 0, copyOfArray, 0, arrayLength);
            copy.put(entry.getKey(), copyOfArray);
            return;
        }
        if (entry.getValue() instanceof Collection) {
            Collection valueCollection = (Collection)entry.getValue();
            Iterator it = valueCollection.iterator();
            while (it.hasNext()) {
                Class<?> containedClazz = it.next().getClass();
                if (scalars.contains(containedClazz)) continue;
                throw new ApplicationException(7, "The value for key \"" + entry.getKey() + "\" is a collection that contains an invalid value of type \"" + containedClazz.getName() + "\"");
            }
            copy.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
            return;
        }
        throw new ApplicationException(7, "The value for key \"" + entry.getKey() + "\" is an invalid type \"" + clazz.getName() + "\"");
    }
}

