/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.internal.signedcontent.DigestedInputStream;
import org.eclipse.osgi.internal.signedcontent.SignedBundleFile;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;

public class SignedContentImpl
implements SignedContent {
    static final SignerInfo[] EMPTY_SIGNERINFO = new SignerInfo[0];
    volatile SignedBundleFile content;
    private final Map<String, Object> contentMDResults;
    private final SignerInfo[] signerInfos;
    private Map<SignerInfo, Object[]> tsaSignerInfos;
    private volatile boolean checkedValid = false;

    public SignedContentImpl(SignerInfo[] signerInfos, Map<String, Object> contentMDResults) {
        this.signerInfos = signerInfos == null ? EMPTY_SIGNERINFO : signerInfos;
        this.contentMDResults = contentMDResults;
    }

    public SignedContentEntry getSignedEntry(String name) {
        if (this.contentMDResults == null) {
            return null;
        }
        Object[] mdResult = (Object[])this.contentMDResults.get(name);
        return mdResult == null ? null : new SignedContentEntryImpl(name, (SignerInfo[])mdResult[0]);
    }

    @Override
    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public Date getSigningTime(SignerInfo signerInfo) {
        if (this.tsaSignerInfos == null) {
            return null;
        }
        Object[] tsaInfo = this.tsaSignerInfos.get(signerInfo);
        return tsaInfo == null ? null : (Date)tsaInfo[1];
    }

    public SignerInfo getTSASignerInfo(SignerInfo signerInfo) {
        if (this.tsaSignerInfos == null) {
            return null;
        }
        Object[] tsaInfo = this.tsaSignerInfos.get(signerInfo);
        return tsaInfo == null ? null : (SignerInfo)tsaInfo[0];
    }

    @Override
    public boolean isSigned() {
        return this.signerInfos.length > 0;
    }

    void setContent(SignedBundleFile content) {
        this.content = content;
    }

    void setTSASignerInfos(Map<SignerInfo, Object[]> tsaSignerInfos) {
        this.tsaSignerInfos = tsaSignerInfos;
    }

    void addTSASignerInfo(SignerInfo baseInfo, SignerInfo tsaSignerInfo, Date signingTime) {
        if (!this.containsInfo(baseInfo)) {
            throw new IllegalArgumentException("The baseInfo is not found");
        }
        if (this.tsaSignerInfos == null) {
            this.tsaSignerInfos = new HashMap<SignerInfo, Object[]>(this.signerInfos.length);
        }
        this.tsaSignerInfos.put(baseInfo, new Object[]{tsaSignerInfo, signingTime});
    }

    Map<String, Object> getContentMDResults() {
        return this.contentMDResults;
    }

    private boolean containsInfo(SignerInfo signerInfo) {
        int i = 0;
        while (i < this.signerInfos.length) {
            if (signerInfo == this.signerInfos[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    InputStream getDigestInputStream(BundleEntry nestedEntry) throws IOException {
        if (this.contentMDResults == null) {
            return nestedEntry.getInputStream();
        }
        Object[] mdResult = (Object[])this.contentMDResults.get(nestedEntry.getName());
        if (mdResult == null) {
            return null;
        }
        try {
            return new DigestedInputStream(nestedEntry, this.content, (SignerInfo[])mdResult[0], (byte[][])mdResult[1], nestedEntry.getSize());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public class SignedContentEntryImpl
    implements SignedContentEntry {
        private final String entryName;
        private final SignerInfo[] entrySigners;

        public SignedContentEntryImpl(String entryName, SignerInfo[] entrySigners) {
            this.entryName = entryName;
            this.entrySigners = entrySigners == null ? EMPTY_SIGNERINFO : entrySigners;
        }
    }
}

