/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import org.eclipse.osgi.internal.permadmin.PermissionAdminTable;
import org.eclipse.osgi.internal.permadmin.PermissionInfoCollection;
import org.eclipse.osgi.internal.permadmin.SecurityRow;
import org.eclipse.osgi.internal.permadmin.SecurityTable;
import org.eclipse.osgi.storage.PermissionData;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class SecurityAdmin {
    private static final PermissionCollection DEFAULT_DEFAULT;
    private static final PermissionInfo[] EMPTY_PERM_INFO;
    private final PermissionAdminTable permAdminTable = new PermissionAdminTable();
    private SecurityTable condAdminTable;
    private PermissionInfoCollection permAdminDefaults;
    private long timeStamp = 0L;
    private long nextID = System.currentTimeMillis();
    private final PermissionData permissionStorage;
    private final Object lock = new Object();
    private final PermissionInfo[] impliedPermissionInfos;
    private final EquinoxSecurityManager supportedSecurityManager;

    static {
        AllPermission allPerm = new AllPermission();
        DEFAULT_DEFAULT = allPerm.newPermissionCollection();
        if (DEFAULT_DEFAULT != null) {
            DEFAULT_DEFAULT.add(allPerm);
        }
        EMPTY_PERM_INFO = new PermissionInfo[0];
    }

    public SecurityAdmin(EquinoxSecurityManager supportedSecurityManager, PermissionData permissionStorage) {
        String[] encodedCondPermInfos;
        String[] locations;
        this.supportedSecurityManager = supportedSecurityManager;
        this.permissionStorage = permissionStorage;
        this.impliedPermissionInfos = SecurityAdmin.getPermissionInfos(this.getClass().getResource("implied.permissions"));
        String[] encodedDefaultInfos = permissionStorage.getPermissionData(null);
        PermissionInfo[] defaultInfos = SecurityAdmin.getPermissionInfos(encodedDefaultInfos);
        if (defaultInfos != null) {
            this.permAdminDefaults = new PermissionInfoCollection(defaultInfos);
        }
        if ((locations = permissionStorage.getLocations()) != null) {
            int i = 0;
            while (i < locations.length) {
                String[] encodedLocationInfos = permissionStorage.getPermissionData(locations[i]);
                if (encodedLocationInfos != null) {
                    PermissionInfo[] locationInfos = SecurityAdmin.getPermissionInfos(encodedLocationInfos);
                    this.permAdminTable.setPermissions(locations[i], locationInfos);
                }
                ++i;
            }
        }
        if ((encodedCondPermInfos = permissionStorage.getConditionalPermissionInfos()) == null) {
            this.condAdminTable = new SecurityTable(this, new SecurityRow[0]);
        } else {
            SecurityRow[] rows = new SecurityRow[encodedCondPermInfos.length];
            try {
                int i = 0;
                while (i < rows.length) {
                    rows[i] = SecurityRow.createSecurityRow(this, encodedCondPermInfos[i]);
                    ++i;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                rows = new SecurityRow[]{};
            }
            this.condAdminTable = new SecurityTable(this, rows);
        }
    }

    private static PermissionInfo[] getPermissionInfos(String[] encodedInfos) {
        if (encodedInfos == null) {
            return null;
        }
        PermissionInfo[] results = new PermissionInfo[encodedInfos.length];
        int i = 0;
        while (i < results.length) {
            results[i] = new PermissionInfo(encodedInfos[i]);
            ++i;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkPermission(Permission permission, BundlePermissions bundlePermissions) {
        PermissionInfoCollection curPermAdminDefaults;
        SecurityTable curCondAdminTable;
        PermissionInfoCollection locationCollection;
        Object object = this.lock;
        synchronized (object) {
            Bundle bundle = bundlePermissions.getBundle();
            locationCollection = bundle instanceof EquinoxBundle ? this.permAdminTable.getCollection(((EquinoxBundle)bundle).getModule().getLocation()) : null;
            curCondAdminTable = this.condAdminTable;
            curPermAdminDefaults = this.permAdminDefaults;
        }
        if (locationCollection != null) {
            return locationCollection.implies(permission);
        }
        if (curCondAdminTable.isEmpty()) {
            return curPermAdminDefaults != null ? curPermAdminDefaults.implies(permission) : DEFAULT_DEFAULT.implies(permission);
        }
        int result = curCondAdminTable.evaluate(bundlePermissions, permission);
        if ((result & 1) != 0) {
            return true;
        }
        if ((result & 2) != 0) {
            return false;
        }
        return (result & 8) != 0;
    }

    public ProtectionDomain createProtectionDomain(Bundle bundle) {
        return this.createProtectionDomain(bundle, this);
    }

    private ProtectionDomain createProtectionDomain(Bundle bundle, SecurityAdmin sa) {
        PermissionInfoCollection impliedPermissions = this.getImpliedPermission(bundle);
        URL permEntry = null;
        try {
            permEntry = bundle.getEntry("OSGI-INF/permissions.perm");
        }
        catch (IllegalStateException illegalStateException) {}
        PermissionInfo[] restrictedInfos = this.getFileRelativeInfos(SecurityAdmin.getPermissionInfos(permEntry), bundle);
        PermissionInfoCollection restrictedPermissions = restrictedInfos == null ? null : new PermissionInfoCollection(restrictedInfos);
        BundlePermissions bundlePermissions = new BundlePermissions(bundle, sa, impliedPermissions, restrictedPermissions);
        return new ProtectionDomain(null, bundlePermissions);
    }

    private PermissionInfoCollection getImpliedPermission(Bundle bundle) {
        if (this.impliedPermissionInfos == null) {
            return null;
        }
        PermissionInfo impliedAdminPermission = new PermissionInfo(AdminPermission.class.getName(), "(id=" + bundle.getBundleId() + ")", "resource,metadata,class,context");
        PermissionInfo[] bundleImpliedInfos = new PermissionInfo[this.impliedPermissionInfos.length + 1];
        System.arraycopy(this.impliedPermissionInfos, 0, bundleImpliedInfos, 0, this.impliedPermissionInfos.length);
        bundleImpliedInfos[this.impliedPermissionInfos.length] = impliedAdminPermission;
        return new PermissionInfoCollection(this.getFileRelativeInfos(bundleImpliedInfos, bundle));
    }

    private PermissionInfo[] getFileRelativeInfos(PermissionInfo[] permissionInfos, Bundle bundle) {
        if (permissionInfos == null) {
            return permissionInfos;
        }
        PermissionInfo[] results = new PermissionInfo[permissionInfos.length];
        int i = 0;
        while (i < permissionInfos.length) {
            File file;
            results[i] = permissionInfos[i];
            if ("java.io.FilePermission".equals(permissionInfos[i].getType()) && !"<<ALL FILES>>".equals(permissionInfos[i].getName()) && !(file = new File(permissionInfos[i].getName())).isAbsolute()) {
                try {
                    File target = bundle.getDataFile(permissionInfos[i].getName());
                    if (target != null) {
                        results[i] = new PermissionInfo(permissionInfos[i].getType(), target.getPath(), permissionInfos[i].getActions());
                    }
                }
                catch (IllegalStateException illegalStateException) {}
            }
            ++i;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        SecurityRow[] condAdminRows;
        PermissionInfoCollection[] permAdminCollections;
        Object object = this.lock;
        synchronized (object) {
            permAdminCollections = this.permAdminTable.getCollections();
            condAdminRows = this.condAdminTable.getRows();
        }
        int i = 0;
        while (i < permAdminCollections.length) {
            permAdminCollections[i].clearPermissionCache();
            ++i;
        }
        i = 0;
        while (i < condAdminRows.length) {
            condAdminRows[i].clearCaches();
            ++i;
        }
        this.condAdminTable.clearEvaluationCache();
    }

    EquinoxSecurityManager getSupportedSecurityManager() {
        return this.supportedSecurityManager != null ? this.supportedSecurityManager : SecurityAdmin.getSupportedSystemSecurityManager();
    }

    private static EquinoxSecurityManager getSupportedSystemSecurityManager() {
        try {
            EquinoxSecurityManager equinoxManager = (EquinoxSecurityManager)System.getSecurityManager();
            return equinoxManager != null && equinoxManager.inCheckPermission() ? equinoxManager : null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private static PermissionInfo[] getPermissionInfos(URL resource) {
        PermissionInfo[] info;
        block19: {
            if (resource == null) {
                return null;
            }
            info = EMPTY_PERM_INFO;
            DataInputStream in = null;
            try {
                try {
                    String line;
                    in = new DataInputStream(resource.openStream());
                    ArrayList<PermissionInfo> permissions = new ArrayList<PermissionInfo>();
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//")) continue;
                        try {
                            permissions.add(new PermissionInfo(line));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                    int size = permissions.size();
                    if (size > 0) {
                        info = permissions.toArray(new PermissionInfo[size]);
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException2) {}
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return info;
    }
}

