/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.log;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.internal.log.ExtendedLogServiceFactory;
import org.eclipse.osgi.internal.log.FormatterLoggerImpl;
import org.eclipse.osgi.internal.log.LoggerImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.log.FormatterLogger;

public class ExtendedLogServiceImpl
implements ExtendedLogService {
    private final ExtendedLogServiceFactory factory;
    private volatile Bundle bundle;
    private final Map<Class<? extends org.osgi.service.log.Logger>, Map<String, LoggerImpl>> loggerCache = new HashMap<Class<? extends org.osgi.service.log.Logger>, Map<String, LoggerImpl>>();
    private final String LOG_SERVICE = "LogService";

    public ExtendedLogServiceImpl(ExtendedLogServiceFactory factory, Bundle bundle) {
        this.factory = factory;
        this.bundle = bundle;
        this.loggerCache.put(org.osgi.service.log.Logger.class, new HashMap());
        this.loggerCache.put(FormatterLogger.class, new HashMap());
    }

    @Override
    public void log(Object context, int level, String message, Throwable exception) {
        this.getLogger(null).log(context, level, message, exception);
    }

    @Override
    public Logger getLogger(String name) {
        return (Logger)this.getLogger(name, org.osgi.service.log.Logger.class);
    }

    @Override
    public Logger getLogger(Bundle logBundle, String name) {
        if (logBundle == null || logBundle == this.bundle) {
            return this.getLogger(name);
        }
        this.factory.checkLogPermission();
        ExtendedLogServiceImpl bundleLogService = this.factory.getLogService(logBundle);
        return bundleLogService.getLogger(name);
    }

    Bundle getBundle() {
        return this.bundle;
    }

    ExtendedLogServiceFactory getFactory() {
        return this.factory;
    }

    public <L extends org.osgi.service.log.Logger> L getLogger(String name, Class<L> loggerType) {
        if (name == null) {
            Bundle current = this.bundle;
            String bsn = current == null ? null : current.getSymbolicName();
            name = bsn == null ? "LogService" : "LogService." + bsn;
        }
        LoggerImpl logger = null;
        Map<String, LoggerImpl> loggers = null;
        this.factory.contextsLock.readLock().lock();
        try {
            loggers = this.loggerCache.get(loggerType);
            if (loggers == null) {
                throw new IllegalArgumentException(loggerType.getName());
            }
            logger = loggers.get(name);
        }
        finally {
            this.factory.contextsLock.readLock().unlock();
        }
        if (logger == null) {
            ExtendedLogServiceFactory.EquinoxLoggerContext loggerContext = this.factory.loggerContextTargetMap.getEffectiveLoggerContext(this.bundle);
            if (loggerType == FormatterLogger.class) {
                logger = new FormatterLoggerImpl(this, name, loggerContext);
            } else if (loggerType == org.osgi.service.log.Logger.class) {
                logger = new LoggerImpl(this, name, loggerContext);
            } else {
                throw new IllegalArgumentException(loggerType.getName());
            }
            this.factory.contextsLock.writeLock().lock();
            try {
                LoggerImpl existing = loggers.get(name);
                if (existing == null) {
                    loggers.put(name, logger);
                } else {
                    logger = existing;
                }
            }
            finally {
                this.factory.contextsLock.writeLock().unlock();
            }
        }
        return (L)((org.osgi.service.log.Logger)loggerType.cast(logger));
    }

    void applyLogLevels(ExtendedLogServiceFactory.EquinoxLoggerContext effectiveLoggerContext) {
        for (Map<String, LoggerImpl> loggers : this.loggerCache.values()) {
            for (LoggerImpl logger : loggers.values()) {
                logger.applyLoggerContext(effectiveLoggerContext);
            }
        }
    }
}

