/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.log;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;

public class ExtendedLogEntryImpl
implements ExtendedLogEntry,
LogEntry {
    private static long nextSequenceNumber = 1L;
    private static long nextThreadId = 1L;
    private static final Map<Thread, Long> threadIds = ExtendedLogEntryImpl.createThreadIdMap();
    private final String loggerName;
    private final Bundle bundle;
    private final int level;
    private final LogLevel logLevelEnum;
    private final String message;
    private final ServiceReference<?> ref;
    private final Throwable throwable;
    private final Object contextObject;
    private final long time = System.currentTimeMillis();
    private final long threadId;
    private final String threadName;
    private final long sequenceNumber;
    private final StackTraceElement stackTraceElement;

    private static Map<Thread, Long> createThreadIdMap() {
        try {
            Thread.class.getMethod("getId", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return new WeakHashMap<Thread, Long>();
        }
        return null;
    }

    private static long getId(Thread thread) {
        if (threadIds == null) {
            return thread.getId();
        }
        Long threadId = threadIds.get(thread);
        if (threadId == null) {
            threadId = new Long(nextThreadId++);
            threadIds.put(thread, threadId);
        }
        return threadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedLogEntryImpl(Bundle bundle, String loggerName, StackTraceElement stackTraceElement, Object contextObject, LogLevel logLevelEnum, int level, String message, ServiceReference<?> ref, Throwable throwable) {
        this.loggerName = loggerName;
        this.bundle = bundle;
        this.level = level;
        this.logLevelEnum = logLevelEnum;
        this.message = message;
        this.throwable = throwable;
        this.ref = ref;
        this.contextObject = contextObject;
        Thread currentThread = Thread.currentThread();
        this.threadName = currentThread.getName();
        Class<ExtendedLogEntryImpl> clazz = ExtendedLogEntryImpl.class;
        synchronized (ExtendedLogEntryImpl.class) {
            this.threadId = ExtendedLogEntryImpl.getId(currentThread);
            this.sequenceNumber = nextSequenceNumber++;
            // ** MonitorExit[var11_11] (shouldn't be in output)
            this.stackTraceElement = stackTraceElement;
            return;
        }
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public Throwable getException() {
        return this.throwable;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Object getContext() {
        return this.contextObject;
    }
}

