/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.log;

import java.io.File;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.log.EquinoxLogFactory;
import org.eclipse.osgi.internal.log.EquinoxLogWriter;
import org.eclipse.osgi.internal.log.LogServiceManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.service.log.LogLevel;

public class EquinoxLogServices {
    private final LogServiceManager logServiceManager;
    private final EquinoxLogFactory eclipseLogFactory;
    private final EquinoxLogWriter logWriter;
    private final EquinoxLogWriter perfWriter;
    private final FrameworkLog rootFrameworkLog;

    public EquinoxLogServices(EquinoxConfiguration environmentInfo) {
        File logFile;
        Location configuration = environmentInfo.getEquinoxLocations().getConfigurationLocation();
        String logFilePath = environmentInfo.getConfiguration("osgi.logfile");
        if (logFilePath == null) {
            logFilePath = String.valueOf(Long.toString(System.currentTimeMillis())) + ".log";
        }
        if (!(logFile = new File(logFilePath)).isAbsolute()) {
            File configAreaDirectory = null;
            if (configuration != null) {
                configAreaDirectory = new File(configuration.getURL().getPath());
            }
            logFile = configAreaDirectory != null ? new File(configAreaDirectory, logFilePath) : null;
        }
        boolean enabled = "true".equals(environmentInfo.getConfiguration("eclipse.log.enabled", "true"));
        if (logFile != null) {
            environmentInfo.setConfiguration("osgi.logfile", logFile.getAbsolutePath());
            this.logWriter = new EquinoxLogWriter(logFile, "org.eclipse.equinox.logger", enabled, environmentInfo);
            File perfLogFile = new File(logFile.getParentFile(), "performance.log");
            this.perfWriter = new EquinoxLogWriter(perfLogFile, "org.eclipse.performance.logger", true, environmentInfo);
        } else {
            this.logWriter = new EquinoxLogWriter(null, "org.eclipse.equinox.logger", enabled, environmentInfo);
            this.perfWriter = new EquinoxLogWriter(null, "org.eclipse.performance.logger", true, environmentInfo);
        }
        if ("true".equals(environmentInfo.getConfiguration("eclipse.consoleLog"))) {
            this.logWriter.setConsoleLog(true);
        }
        String logHistoryMaxProp = environmentInfo.getConfiguration("equinox.log.history.max");
        int logHistoryMax = 0;
        if (logHistoryMaxProp != null) {
            try {
                logHistoryMax = Integer.parseInt(logHistoryMaxProp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        LogLevel defaultLevel = LogLevel.WARN;
        try {
            String defaultLevelConfig = environmentInfo.getConfiguration("org.osgi.service.log.admin.loglevel");
            if (defaultLevelConfig != null) {
                defaultLevel = LogLevel.valueOf(defaultLevelConfig);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.logServiceManager = new LogServiceManager(logHistoryMax, defaultLevel, this.logWriter, this.perfWriter);
        this.eclipseLogFactory = new EquinoxLogFactory(this.logWriter, this.logServiceManager);
        this.rootFrameworkLog = this.eclipseLogFactory.createFrameworkLog(null, this.logWriter);
        this.logWriter.setLoggerAdmin(this.logServiceManager.getLoggerAdmin());
        this.perfWriter.setLoggerAdmin(this.logServiceManager.getLoggerAdmin());
    }

    public FrameworkLog getFrameworkLog() {
        return this.rootFrameworkLog;
    }

    public void log(String entry, int severity, String message, Throwable throwable) {
        this.log(entry, severity, message, throwable, null);
    }

    public void log(String entry, int severity, String message, Throwable throwable, FrameworkLogEntry[] children) {
        this.getFrameworkLog().log(new FrameworkLogEntry(entry, severity, 0, message, 0, throwable, children));
    }
}

