/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.hooks;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.internal.loader.classpath.FragmentClasspath;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleFile;

public class DevClassLoadingHook
extends ClassLoaderHook
implements KeyedElement {
    public static final String KEY = DevClassLoadingHook.class.getName();
    public static final int HASHCODE = KEY.hashCode();
    private final EquinoxConfiguration configuration;

    public DevClassLoadingHook(EquinoxConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean addClassPathEntry(ArrayList<ClasspathEntry> cpEntries, String cp, ClasspathManager hostmanager, BundleInfo.Generation sourceGeneration) {
        String[] devClassPath;
        String[] stringArray = devClassPath = !this.configuration.inDevelopmentMode() ? null : this.configuration.getDevClassPath(sourceGeneration.getRevision().getSymbolicName());
        if (devClassPath == null || devClassPath.length == 0) {
            return false;
        }
        if (cpEntries.size() > 0 && cpEntries.get(0).getUserObject(KEY) != null) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < devClassPath.length) {
            if (hostmanager.addClassPathEntry(cpEntries, devClassPath[i], hostmanager, sourceGeneration)) {
                result = true;
            } else {
                ClasspathEntry entry;
                String devCP = devClassPath[i];
                boolean fromFragment = devCP.endsWith("@fragment@");
                if (!fromFragment && devCP.indexOf("..") >= 0) {
                    File base = sourceGeneration.getBundleFile().getBaseFile();
                    if (base.isDirectory() && (entry = hostmanager.getExternalClassPath(new File(base, devCP).getAbsolutePath(), sourceGeneration)) != null) {
                        cpEntries.add(entry);
                        result = true;
                    }
                } else {
                    BundleInfo.Generation fragSource;
                    if (fromFragment) {
                        devCP = devCP.substring(0, devCP.length() - "@fragment@".length());
                    }
                    if ((fragSource = this.findFragmentSource(sourceGeneration, devCP, hostmanager, fromFragment)) != null && (entry = hostmanager.getExternalClassPath(devCP, fragSource)) != null) {
                        cpEntries.add(entry);
                        result = true;
                    }
                }
            }
            ++i;
        }
        if (result && cpEntries.size() > 0) {
            cpEntries.get(0).addUserObject(this);
        }
        return result;
    }

    private BundleInfo.Generation findFragmentSource(BundleInfo.Generation hostGeneration, String cp, ClasspathManager manager, boolean fromFragment) {
        if (hostGeneration != manager.getGeneration()) {
            return hostGeneration;
        }
        File file = new File(cp);
        if (!file.isAbsolute()) {
            return hostGeneration;
        }
        FragmentClasspath[] fragCP = manager.getFragmentClasspaths();
        int i = 0;
        while (i < fragCP.length) {
            BundleFile fragBase = fragCP[i].getGeneration().getBundleFile();
            File fragFile = fragBase.getBaseFile();
            if (fragFile != null && file.getPath().startsWith(fragFile.getPath())) {
                return fragCP[i].getGeneration();
            }
            ++i;
        }
        return fromFragment ? null : hostGeneration;
    }

    @Override
    public Object getKey() {
        return KEY;
    }

    @Override
    public boolean isProcessClassRecursionSupported() {
        return true;
    }
}

