/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.hookregistry;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Dictionary;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.BundleException;

public abstract class StorageHookFactory<S, L, H extends StorageHook<S, L>> {
    protected final String KEY = this.getClass().getName().intern();

    public abstract int getStorageVersion();

    public final String getKey() {
        return this.KEY;
    }

    public boolean isCompatibleWith(int version) {
        return this.getStorageVersion() == version;
    }

    public S createSaveContext() {
        return null;
    }

    public L createLoadContext(int version) {
        return null;
    }

    protected abstract H createStorageHook(BundleInfo.Generation var1);

    public final H createStorageHookAndValidateFactoryClass(BundleInfo.Generation generation) {
        Class factoryClassOfStorageHook;
        H result = this.createStorageHook(generation);
        Class<?> factoryClass = this.getClass();
        if (!factoryClass.equals(factoryClassOfStorageHook = ((StorageHook)result).getFactoryClass())) {
            throw new IllegalStateException(String.format("The factory class '%s' of storage hook '%s' does not match the creating factory class of '%s'", factoryClassOfStorageHook.getName(), result, factoryClass.getName()));
        }
        return result;
    }

    public static abstract class StorageHook<S, L> {
        private final Class<? extends StorageHookFactory<S, L, ? extends StorageHook<S, L>>> factoryClass;
        private final BundleInfo.Generation generation;

        public StorageHook(BundleInfo.Generation generation, Class<? extends StorageHookFactory<S, L, ? extends StorageHook<S, L>>> factoryClass) {
            this.generation = generation;
            this.factoryClass = factoryClass;
        }

        public abstract void initialize(Dictionary<String, String> var1) throws BundleException;

        public ModuleRevisionBuilder adaptModuleRevisionBuilder(ModuleContainerAdaptor.ModuleEvent operation, Module origin, ModuleRevisionBuilder builder) {
            return null;
        }

        public abstract void load(L var1, DataInputStream var2) throws IOException;

        public abstract void save(S var1, DataOutputStream var2) throws IOException;

        public void deletingGeneration() {
        }

        public void validate() throws IllegalStateException {
        }

        public Class<? extends StorageHookFactory<S, L, ? extends StorageHook<S, L>>> getFactoryClass() {
            return this.factoryClass;
        }
    }
}

