/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.hookregistry;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.cds.CDSHookConfigurator;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.hookregistry.ActivatorHookFactory;
import org.eclipse.osgi.internal.hookregistry.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.hookregistry.HookConfigurator;
import org.eclipse.osgi.internal.hookregistry.StorageHookFactory;
import org.eclipse.osgi.internal.hooks.DevClassLoadingHook;
import org.eclipse.osgi.internal.hooks.EclipseLazyStarter;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.internal.weaving.WeavingHookConfigurator;
import org.eclipse.osgi.util.ManifestElement;

public final class HookRegistry {
    private final EquinoxContainer container;
    private volatile boolean initialized = false;
    private final List<ClassLoaderHook> classLoaderHooks = new ArrayList<ClassLoaderHook>();
    private final List<ClassLoaderHook> classLoaderHooksRO = Collections.unmodifiableList(this.classLoaderHooks);
    private final List<StorageHookFactory<?, ?, ?>> storageHookFactories = new ArrayList();
    private final List<StorageHookFactory<?, ?, ?>> storageHookFactoriesRO = Collections.unmodifiableList(this.storageHookFactories);
    private final List<BundleFileWrapperFactoryHook> bundleFileWrapperFactoryHooks = new ArrayList<BundleFileWrapperFactoryHook>();
    private final List<BundleFileWrapperFactoryHook> bundleFileWrapperFactoryHooksRO = Collections.unmodifiableList(this.bundleFileWrapperFactoryHooks);
    private final List<ActivatorHookFactory> activatorHookFactories = new ArrayList<ActivatorHookFactory>();
    private final List<ActivatorHookFactory> activatorHookFactoriesRO = Collections.unmodifiableList(this.activatorHookFactories);

    public HookRegistry(EquinoxContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        ArrayList<String> configurators = new ArrayList<String>(5);
        ArrayList<FrameworkLogEntry> errors = new ArrayList<FrameworkLogEntry>(0);
        this.mergeFileHookConfigurators(configurators, errors);
        this.mergePropertyHookConfigurators(configurators);
        HookRegistry hookRegistry = this;
        synchronized (hookRegistry) {
            this.addClassLoaderHook(new DevClassLoadingHook(this.container.getConfiguration()));
            this.addClassLoaderHook(new EclipseLazyStarter(this.container));
            this.addClassLoaderHook(new WeavingHookConfigurator(this.container));
            configurators.add(SignedBundleHook.class.getName());
            configurators.add(CDSHookConfigurator.class.getName());
            this.loadConfigurators(configurators, errors);
            this.initialized = true;
        }
        for (FrameworkLogEntry error : errors) {
            this.container.getLogServices().getFrameworkLog().log(error);
        }
    }

    private void mergeFileHookConfigurators(List<String> configuratorList, List<FrameworkLogEntry> errors) {
        Enumeration<URL> hookConfigurators;
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            hookConfigurators = cl != null ? cl.getResources("hookconfigurators.properties") : ClassLoader.getSystemResources("hookconfigurators.properties");
        }
        catch (IOException e) {
            errors.add(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "getResources error on hookconfigurators.properties", 0, e, null));
            return;
        }
        int curBuiltin = 0;
        while (hookConfigurators.hasMoreElements()) {
            String hooksValue;
            Properties configuratorProps;
            InputStream input;
            URL url;
            block21: {
                url = hookConfigurators.nextElement();
                input = null;
                configuratorProps = new Properties();
                input = url.openStream();
                configuratorProps.load(input);
                hooksValue = configuratorProps.getProperty("hook.configurators");
                if (hooksValue != null) break block21;
                if (input == null) continue;
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            try {
                try {
                    boolean builtin = Boolean.valueOf(configuratorProps.getProperty("builtin.hooks"));
                    String[] configurators = ManifestElement.getArrayFromList(hooksValue, ",");
                    int i = 0;
                    while (i < configurators.length) {
                        if (!configuratorList.contains(configurators[i])) {
                            if (builtin) {
                                configuratorList.add(curBuiltin++, configurators[i]);
                            } else {
                                configuratorList.add(configurators[i]);
                            }
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    errors.add(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "error loading: " + url.toExternalForm(), 0, e, null));
                    if (input == null) continue;
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input == null) continue;
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void mergePropertyHookConfigurators(List<String> configuratorList) {
        String[] configurators = ManifestElement.getArrayFromList(this.container.getConfiguration().getConfiguration("osgi.hook.configurators"), ",");
        if (configurators.length > 0) {
            configuratorList.clear();
            int i = 0;
            while (i < configurators.length) {
                if (!configuratorList.contains(configurators[i])) {
                    configuratorList.add(configurators[i]);
                }
                ++i;
            }
            return;
        }
        String[] includeConfigurators = ManifestElement.getArrayFromList(this.container.getConfiguration().getConfiguration("osgi.hook.configurators.include"), ",");
        int i = 0;
        while (i < includeConfigurators.length) {
            if (!configuratorList.contains(includeConfigurators[i])) {
                configuratorList.add(includeConfigurators[i]);
            }
            ++i;
        }
        String[] excludeHooks = ManifestElement.getArrayFromList(this.container.getConfiguration().getConfiguration("osgi.hook.configurators.exclude"), ",");
        int i2 = 0;
        while (i2 < excludeHooks.length) {
            configuratorList.remove(excludeHooks[i2]);
            ++i2;
        }
    }

    private void loadConfigurators(List<String> configurators, List<FrameworkLogEntry> errors) {
        for (String hookName : configurators) {
            try {
                Class<?> clazz = Class.forName(hookName);
                HookConfigurator configurator = (HookConfigurator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                configurator.addHooks(this);
            }
            catch (Throwable t) {
                errors.add(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "error loading hook: " + hookName, 0, t, null));
            }
        }
    }

    public List<ClassLoaderHook> getClassLoaderHooks() {
        return this.classLoaderHooksRO;
    }

    public List<StorageHookFactory<?, ?, ?>> getStorageHookFactories() {
        return this.storageHookFactoriesRO;
    }

    public List<BundleFileWrapperFactoryHook> getBundleFileWrapperFactoryHooks() {
        return this.bundleFileWrapperFactoryHooksRO;
    }

    private <H> void add(H hook, List<H> hooks) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot add hooks dynamically.");
        }
        hooks.add(hook);
    }

    public void addClassLoaderHook(ClassLoaderHook classLoaderHook) {
        this.add(classLoaderHook, this.classLoaderHooks);
    }

    public void addStorageHookFactory(StorageHookFactory<?, ?, ?> storageHookFactory) {
        this.add(storageHookFactory, this.storageHookFactories);
    }

    public void addBundleFileWrapperFactoryHook(BundleFileWrapperFactoryHook factory) {
        this.add(factory, this.bundleFileWrapperFactoryHooks);
    }

    public void addActivatorHookFactory(ActivatorHookFactory activatorHookFactory) {
        this.add(activatorHookFactory, this.activatorHookFactories);
    }

    public EquinoxConfiguration getConfiguration() {
        return this.container.getConfiguration();
    }

    public EquinoxContainer getContainer() {
        return this.container;
    }
}

