/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework.legacy;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.container.InternalUtils;
import org.eclipse.osgi.internal.framework.legacy.StartLevelImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.resource.Requirement;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

@Deprecated
public class PackageAdminImpl
implements PackageAdmin {
    private final ModuleContainer container;

    static {
        Class<GetBundleAction> c = GetBundleAction.class;
        c.getName();
    }

    public PackageAdminImpl(ModuleContainer container) {
        this.container = container;
    }

    @Override
    public ExportedPackage getExportedPackage(String name) {
        ExportedPackage[] allExports = this.getExportedPackages(name);
        if (allExports == null) {
            return null;
        }
        ExportedPackage result = null;
        int i = 0;
        while (i < allExports.length) {
            if (name.equals(allExports[i].getName())) {
                if (result == null) {
                    result = allExports[i];
                } else {
                    Version curVersion = result.getVersion();
                    Version newVersion = allExports[i].getVersion();
                    if (newVersion.compareTo(curVersion) >= 0) {
                        result = allExports[i];
                    }
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public ExportedPackage[] getExportedPackages(String name) {
        String filter = "(osgi.wiring.package=" + (name == null ? "*" : name) + ")";
        Map<String, String> directives = Collections.singletonMap("filter", filter);
        Map<String, Boolean> attributes = Collections.singletonMap("org.eclipse.osgi.container.synthetic", Boolean.TRUE);
        Requirement packageReq = ModuleContainer.createRequirement("osgi.wiring.package", directives, attributes);
        Collection<BundleCapability> packageCaps = this.container.getFrameworkWiring().findProviders(packageReq);
        InternalUtils.filterCapabilityPermissions(packageCaps);
        ArrayList<ExportedPackageImpl> result = new ArrayList<ExportedPackageImpl>();
        for (BundleCapability capability : packageCaps) {
            ModuleWiring wiring = (ModuleWiring)capability.getRevision().getWiring();
            if (wiring == null) continue;
            List<Object> wirings = Collections.emptyList();
            if ((capability.getRevision().getTypes() & 1) != 0) {
                List<ModuleWire> list = wiring.getRequiredModuleWires("osgi.wiring.host");
                if (list != null && !list.isEmpty()) {
                    wirings = new ArrayList(list.size());
                    for (ModuleWire hostWire : list) {
                        ModuleWiring hostWiring = hostWire.getProviderWiring();
                        if (hostWiring == null) continue;
                        wirings.add(hostWiring);
                    }
                }
            } else {
                wirings = Collections.singletonList(wiring);
            }
            for (ModuleWiring moduleWiring : wirings) {
                if (moduleWiring.getSubstitutedNames().contains(capability.getAttributes().get("osgi.wiring.package"))) continue;
                result.add(new ExportedPackageImpl((ModuleCapability)capability, moduleWiring));
            }
        }
        return result.size() == 0 ? null : result.toArray(new ExportedPackage[result.size()]);
    }

    @Override
    public Bundle[] getBundles(String symbolicName, String versionRange) {
        if (symbolicName == null) {
            throw new IllegalArgumentException();
        }
        if ("system.bundle".equals(symbolicName)) {
            symbolicName = "org.eclipse.osgi";
        }
        VersionRange range = versionRange == null ? null : new VersionRange(versionRange);
        String filter = String.valueOf(range != null ? "(&" : "") + "(" + "osgi.identity" + "=" + symbolicName + ")" + (range != null ? String.valueOf(range.toFilterString("version")) + ")" : "");
        Requirement identityReq = ModuleContainer.createRequirement("osgi.identity", Collections.singletonMap("filter", filter), Collections.emptyMap());
        Collection<BundleCapability> identityCaps = this.container.getFrameworkWiring().findProviders(identityReq);
        if (identityCaps.isEmpty()) {
            return null;
        }
        ArrayList<Bundle> sorted = new ArrayList<Bundle>(identityCaps.size());
        for (BundleCapability capability : identityCaps) {
            Bundle b = capability.getRevision().getBundle();
            if (!symbolicName.equals(b.getSymbolicName()) || sorted.contains(b)) continue;
            sorted.add(b);
        }
        Collections.sort(sorted, new Comparator<Bundle>(){

            @Override
            public int compare(Bundle b1, Bundle b2) {
                return b2.getVersion().compareTo(b1.getVersion());
            }
        });
        if (sorted.isEmpty()) {
            return null;
        }
        return sorted.toArray(new Bundle[sorted.size()]);
    }

    @Override
    public Bundle[] getFragments(Bundle bundle) {
        ModuleWiring wiring = this.getWiring(bundle);
        if (wiring == null) {
            return null;
        }
        List<ModuleWire> hostWires = wiring.getProvidedModuleWires("osgi.wiring.host");
        if (hostWires == null) {
            return null;
        }
        ArrayList<Bundle> fragments = new ArrayList<Bundle>(hostWires.size());
        for (ModuleWire wire : hostWires) {
            Bundle fragment = wire.getRequirer().getBundle();
            if (fragment == null) continue;
            fragments.add(fragment);
        }
        return fragments.isEmpty() ? null : fragments.toArray(new Bundle[fragments.size()]);
    }

    private ModuleWiring getWiring(Bundle bundle) {
        Module module = StartLevelImpl.getModule(bundle);
        if (module == null) {
            return null;
        }
        List<ModuleRevision> revisions = module.getRevisions().getModuleRevisions();
        if (revisions.isEmpty()) {
            return null;
        }
        return revisions.get(0).getWiring();
    }

    Bundle getBundlePriv(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof BundleReference) {
            return ((BundleReference)((Object)cl)).getBundle();
        }
        if (cl == this.getClass().getClassLoader()) {
            return this.container.getModule(0L).getBundle();
        }
        return null;
    }

    @Override
    public Bundle getBundle(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return this.getBundlePriv(clazz);
        }
        return AccessController.doPrivileged(new GetBundleAction(this, clazz));
    }

    static class ExportedPackageImpl
    implements ExportedPackage {
        private final ModuleCapability packageCapability;
        private final ModuleWiring providerWiring;

        public ExportedPackageImpl(ModuleCapability packageCapability, ModuleWiring providerWiring) {
            this.packageCapability = packageCapability;
            this.providerWiring = providerWiring;
        }

        @Override
        public String getName() {
            return (String)this.packageCapability.getAttributes().get("osgi.wiring.package");
        }

        @Override
        public Bundle getExportingBundle() {
            if (!this.providerWiring.isInUse()) {
                return null;
            }
            return this.providerWiring.getBundle();
        }

        @Override
        public Version getVersion() {
            Version version = (Version)this.packageCapability.getAttributes().get("version");
            return version == null ? Version.emptyVersion : version;
        }

        public String toString() {
            return this.packageCapability.toString();
        }
    }

    static class GetBundleAction
    implements PrivilegedAction<Bundle> {
        private Class<?> clazz;
        private PackageAdminImpl impl;

        public GetBundleAction(PackageAdminImpl impl, Class<?> clazz) {
            this.impl = impl;
            this.clazz = clazz;
        }

        @Override
        public Bundle run() {
            return this.impl.getBundlePriv(this.clazz);
        }
    }
}

