/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.serviceregistry.HookContext;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.bundle.EventHook;

public class EquinoxEventPublisher {
    static final String eventHookName = EventHook.class.getName();
    static final String collisionHookName = CollisionHook.class.getName();
    private final EquinoxContainer container;
    private Object monitor = new Object();
    private EventManager eventManager;
    private final Map<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> allBundleListeners = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>>();
    private final Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> allSyncBundleListeners = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>>();
    private final Map<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> allFrameworkListeners = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>>();

    public EquinoxEventPublisher(EquinoxContainer container) {
        this.container = container;
    }

    void init() {
        this.resetEventManager(new EventManager("Framework Event Dispatcher: " + this.container.toString()));
    }

    void close() {
        this.flushFrameworkEvents();
        this.resetEventManager(null);
        this.allBundleListeners.clear();
        this.allSyncBundleListeners.clear();
        this.allFrameworkListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetEventManager(EventManager newEventManager) {
        EventManager currentEventManager;
        Object object = this.monitor;
        synchronized (object) {
            currentEventManager = this.eventManager;
            this.eventManager = newEventManager;
        }
        if (currentEventManager != null) {
            currentEventManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, E> ListenerQueue<K, V, E> newListenerQueue() {
        Object object = this.monitor;
        synchronized (object) {
            return new ListenerQueue(this.eventManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEventManagerSet() {
        Object object = this.monitor;
        synchronized (object) {
            return this.eventManager != null;
        }
    }

    public void publishBundleEvent(int type, Bundle bundle, Bundle origin) {
        if (origin != null) {
            this.publishBundleEvent(new BundleEvent(type, bundle, origin));
        } else {
            this.publishBundleEvent(new BundleEvent(type, bundle));
        }
    }

    private void publishBundleEvent(final BundleEvent event) {
        if (System.getSecurityManager() == null) {
            this.publishBundleEventPrivileged(event);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    EquinoxEventPublisher.this.publishBundleEventPrivileged(event);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishBundleEventPrivileged(BundleEvent event) {
        Set listeners;
        EventDispatcher dispatcher;
        HashMap<BundleContextImpl, Set<Map.Entry<SynchronousBundleListener, SynchronousBundleListener>>> listenersSync;
        if (!this.isEventManagerSet()) {
            return;
        }
        BundleContextImpl systemContext = null;
        Set<Map.Entry<SynchronousBundleListener, SynchronousBundleListener>> systemBundleListenersSync = null;
        Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> map = this.allSyncBundleListeners;
        synchronized (map) {
            listenersSync = new HashMap<BundleContextImpl, Set<Map.Entry<SynchronousBundleListener, SynchronousBundleListener>>>(this.allSyncBundleListeners.size());
            for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> entry : this.allSyncBundleListeners.entrySet()) {
                CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener> copyOnWriteIdentityMap = entry.getValue();
                if (copyOnWriteIdentityMap.isEmpty()) continue;
                Set<Map.Entry<SynchronousBundleListener, SynchronousBundleListener>> listenerEntries = copyOnWriteIdentityMap.entrySet();
                if (entry.getKey().getBundleImpl().getBundleId() == 0L) {
                    systemContext = entry.getKey();
                    systemBundleListenersSync = listenerEntries;
                }
                listenersSync.put(entry.getKey(), copyOnWriteIdentityMap.entrySet());
            }
        }
        HashMap listenersAsync = null;
        Set systemBundleListenersAsync = null;
        if ((event.getType() & 0x380) == 0) {
            Map<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> map2 = this.allBundleListeners;
            synchronized (map2) {
                listenersAsync = new HashMap(this.allBundleListeners.size());
                for (Map.Entry entry : this.allBundleListeners.entrySet()) {
                    CopyOnWriteIdentityMap listeners3 = (CopyOnWriteIdentityMap)entry.getValue();
                    if (listeners3.isEmpty()) continue;
                    Set listenerEntries = listeners3.entrySet();
                    if (((BundleContextImpl)entry.getKey()).getBundleImpl().getBundleId() == 0L) {
                        systemContext = (BundleContextImpl)entry.getKey();
                        systemBundleListenersAsync = listenerEntries;
                    }
                    listenersAsync.put((BundleContextImpl)entry.getKey(), listenerEntries);
                }
            }
        }
        Collection<BundleContext> shrinkable = listenersAsync == null ? EquinoxEventPublisher.asBundleContexts(listenersSync.keySet()) : new ShrinkableCollection<BundleContext>(EquinoxEventPublisher.asBundleContexts(listenersSync.keySet()), EquinoxEventPublisher.asBundleContexts(listenersAsync.keySet()));
        this.notifyEventHooksPrivileged(event, shrinkable);
        if (systemBundleListenersSync != null && !listenersSync.containsKey(systemContext)) {
            listenersSync.put(systemContext, systemBundleListenersSync);
        }
        if (systemBundleListenersAsync != null && !listenersAsync.containsKey(systemContext)) {
            listenersAsync.put(systemContext, systemBundleListenersAsync);
        }
        if (!listenersSync.isEmpty()) {
            ListenerQueue listenerQueue = this.newListenerQueue();
            for (Map.Entry entry : listenersSync.entrySet()) {
                dispatcher = (EventDispatcher)entry.getKey();
                listeners = (Set)entry.getValue();
                listenerQueue.queueListeners(listeners, dispatcher);
            }
            listenerQueue.dispatchEventSynchronous(2, event);
        }
        if (listenersAsync != null && !listenersAsync.isEmpty()) {
            ListenerQueue listenerQueue = this.newListenerQueue();
            for (Map.Entry entry : listenersAsync.entrySet()) {
                dispatcher = (EventDispatcher)entry.getKey();
                listeners = (Set)entry.getValue();
                listenerQueue.queueListeners(listeners, dispatcher);
            }
            listenerQueue.dispatchEventAsynchronous(1, event);
        }
    }

    private void notifyEventHooksPrivileged(final BundleEvent event, final Collection<BundleContext> result) {
        ServiceRegistry serviceRegistry;
        if (this.container.getConfiguration().getDebug().DEBUG_HOOKS) {
            Debug.println("notifyBundleEventHooks(" + event.getType() + ":" + event.getBundle() + ", " + result + " )");
        }
        if ((serviceRegistry = this.container.getServiceRegistry()) != null) {
            serviceRegistry.notifyHooksPrivileged(new HookContext(){

                @Override
                public void call(Object hook, ServiceRegistration<?> hookRegistration) throws Exception {
                    if (hook instanceof EventHook) {
                        ((EventHook)hook).event(event, result);
                    }
                }

                @Override
                public String getHookClassName() {
                    return eventHookName;
                }

                @Override
                public String getHookMethodName() {
                    return "event";
                }

                @Override
                public boolean skipRegistration(ServiceRegistration<?> hookRegistration) {
                    return false;
                }
            });
        }
    }

    public void publishFrameworkEvent(int type, Bundle bundle, Throwable throwable) {
        this.publishFrameworkEvent(type, bundle, throwable, null);
    }

    public void publishFrameworkEvent(int type, Bundle bundle, Throwable throwable, final FrameworkListener ... listeners) {
        if (bundle == null) {
            bundle = this.container.getStorage().getModuleContainer().getModule(0L).getBundle();
        }
        final FrameworkEvent event = new FrameworkEvent(type, bundle, throwable);
        if (System.getSecurityManager() == null) {
            this.publishFrameworkEventPrivileged(event, listeners);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    EquinoxEventPublisher.this.publishFrameworkEventPrivileged(event, listeners);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFrameworkEventPrivileged(FrameworkEvent event, FrameworkListener ... callerListeners) {
        HashMap<BundleContextImpl, Set<Map.Entry<FrameworkListener, FrameworkListener>>> listenerSnapshot;
        if (!this.isEventManagerSet()) {
            return;
        }
        Map<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> map = this.allFrameworkListeners;
        synchronized (map) {
            listenerSnapshot = new HashMap<BundleContextImpl, Set<Map.Entry<FrameworkListener, FrameworkListener>>>(this.allFrameworkListeners.size());
            for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> entry : this.allFrameworkListeners.entrySet()) {
                CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener> listeners2 = entry.getValue();
                if (listeners2.isEmpty()) continue;
                listenerSnapshot.put(entry.getKey(), listeners2.entrySet());
            }
        }
        ListenerQueue<Object, Object, Object> queue = this.newListenerQueue();
        if (callerListeners != null && callerListeners.length > 0) {
            HashMap<FrameworkListener, FrameworkListener> hashMap = new HashMap<FrameworkListener, FrameworkListener>();
            FrameworkListener[] frameworkListenerArray = callerListeners;
            int n = callerListeners.length;
            int listeners2 = 0;
            while (listeners2 < n) {
                FrameworkListener listener = frameworkListenerArray[listeners2];
                if (listener != null) {
                    hashMap.put(listener, listener);
                }
                ++listeners2;
            }
            if (hashMap.size() > 0) {
                BundleContextImpl systemContext;
                BundleContextImpl dispatcher = systemContext = (BundleContextImpl)this.container.getStorage().getModuleContainer().getModule(0L).getBundle().getBundleContext();
                queue.queueListeners(hashMap.entrySet(), dispatcher);
            }
        }
        for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> entry : listenerSnapshot.entrySet()) {
            EventDispatcher dispatcher = entry.getKey();
            Set listeners = (Set)((Object)entry.getValue());
            queue.queueListeners(listeners, dispatcher);
        }
        queue.dispatchEventAsynchronous(4, event);
        if ((event.getType() & 0x1C0) != 0) {
            this.close();
        }
    }

    public static Collection<BundleContext> asBundleContexts(Collection<? extends BundleContext> c) {
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBundleListener(BundleListener listener, BundleContextImpl context) {
        if (listener instanceof SynchronousBundleListener) {
            this.container.checkAdminPermission(context.getBundle(), "listener");
            Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> map = this.allSyncBundleListeners;
            synchronized (map) {
                CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener> listeners = this.allSyncBundleListeners.get(context);
                if (listeners == null) {
                    listeners = new CopyOnWriteIdentityMap();
                    this.allSyncBundleListeners.put(context, listeners);
                }
                listeners.put((SynchronousBundleListener)listener, (SynchronousBundleListener)listener);
            }
        }
        Map<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> map = this.allBundleListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<BundleListener, BundleListener> listeners = this.allBundleListeners.get(context);
            if (listeners == null) {
                listeners = new CopyOnWriteIdentityMap();
                this.allBundleListeners.put(context, listeners);
            }
            listeners.put(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBundleListener(BundleListener listener, BundleContextImpl context) {
        if (listener instanceof SynchronousBundleListener) {
            this.container.checkAdminPermission(context.getBundle(), "listener");
            Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> map = this.allSyncBundleListeners;
            synchronized (map) {
                CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener> listeners = this.allSyncBundleListeners.get(context);
                if (listeners != null) {
                    listeners.remove(listener);
                }
            }
        }
        Map<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> map = this.allBundleListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<BundleListener, BundleListener> listeners = this.allBundleListeners.get(context);
            if (listeners != null) {
                listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFrameworkListener(FrameworkListener listener, BundleContextImpl context) {
        Map<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> map = this.allFrameworkListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener> listeners = this.allFrameworkListeners.get(context);
            if (listeners == null) {
                listeners = new CopyOnWriteIdentityMap();
                this.allFrameworkListeners.put(context, listeners);
            }
            listeners.put(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFrameworkListener(FrameworkListener listener, BundleContextImpl context) {
        Map<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> map = this.allFrameworkListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener> listeners = this.allFrameworkListeners.get(context);
            if (listeners != null) {
                listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllListeners(BundleContextImpl context) {
        Map<BundleContextImpl, CopyOnWriteIdentityMap<EventListener, EventListener>> map;
        if (context.getBundleImpl().getBundleId() != 0L) {
            map = this.allBundleListeners;
            synchronized (map) {
                this.allBundleListeners.remove(context);
            }
            map = this.allSyncBundleListeners;
            synchronized (map) {
                this.allSyncBundleListeners.remove(context);
            }
        }
        map = this.allFrameworkListeners;
        synchronized (map) {
            this.allFrameworkListeners.remove(context);
        }
    }

    void flushFrameworkEvents() {
        EventDispatcher<Object, Object, CountDownLatch> dispatcher = new EventDispatcher<Object, Object, CountDownLatch>(){

            @Override
            public void dispatchEvent(Object eventListener, Object listenerObject, int eventAction, CountDownLatch flushedSignal) {
                flushedSignal.countDown();
            }
        };
        ListenerQueue<Object, Object, CountDownLatch> queue = this.newListenerQueue();
        queue.queueListeners(Collections.singletonMap(dispatcher, dispatcher).entrySet(), dispatcher);
        CountDownLatch flushedSignal = new CountDownLatch(1);
        queue.dispatchEventAsynchronous(0, flushedSignal);
        try {
            flushedSignal.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }
}

