/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.cds;

import com.ibm.oti.shared.SharedClassURLHelper;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.osgi.internal.cds.CDSBundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;

public class CDSBundleFile
extends BundleFileWrapper {
    private URL url;
    private SharedClassURLHelper urlHelper;
    private boolean primed = false;

    public CDSBundleFile(BundleFile wrapped) {
        super(wrapped);
        try {
            this.url = new URL("file", "", wrapped.getBaseFile().getAbsolutePath());
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public CDSBundleFile(BundleFile bundleFile, SharedClassURLHelper urlHelper) {
        this(bundleFile);
        this.urlHelper = urlHelper;
    }

    @Override
    public BundleEntry getEntry(String path) {
        BundleEntry wrappedEntry = super.getEntry(path);
        if (wrappedEntry == null) {
            return null;
        }
        if (!this.primed || !path.endsWith(".class")) {
            return wrappedEntry;
        }
        byte[] classbytes = this.getClassBytes(path.substring(0, path.length() - ".class".length()));
        CDSBundleEntry be = new CDSBundleEntry(path, classbytes, wrappedEntry);
        return be;
    }

    URL getURL() {
        return this.url;
    }

    SharedClassURLHelper getURLHelper() {
        return this.urlHelper;
    }

    void setURLHelper(SharedClassURLHelper urlHelper) {
        this.urlHelper = urlHelper;
        this.primed = false;
    }

    void setPrimed(boolean primed) {
        this.primed = primed;
    }

    private byte[] getClassBytes(String name) {
        if (this.urlHelper == null || this.url == null) {
            return null;
        }
        return this.urlHelper.findSharedClass(null, this.url, name);
    }

    public boolean getPrimed() {
        return this.primed;
    }
}

