/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathMap<T> {
    private Node<T> root = new DeviceNode();

    public T put(IPath key, T value) {
        Node<T> node = this.root.createNode(key);
        Object result = node.value;
        node.value = value;
        return result;
    }

    public T getMostSpecific(IPath key) {
        Node<T> node = this.root.getMostSpecificNode(key);
        if (!node.exists) {
            return null;
        }
        return node.value;
    }

    public boolean containsPrefixOf(IPath path) {
        Node<T> node = this.root.getMostSpecificNode(path);
        return node.exists;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.root.toString(builder, Path.EMPTY);
        return builder.toString();
    }

    private static class DeviceNode<T>
    extends Node<T> {
        Node<T> noDevice = new Node(0);

        DeviceNode() {
            super(-1);
        }

        @Override
        String getSegment(IPath key) {
            return key.getDevice();
        }

        @Override
        public Node<T> createChild(String nextSegment) {
            if (nextSegment == null) {
                return this.noDevice;
            }
            return super.createChild(nextSegment);
        }

        @Override
        Node<T> getChild(String nextSegment) {
            if (nextSegment == null) {
                return this.noDevice;
            }
            return super.getChild(nextSegment);
        }

        @Override
        IPath buildChildPath(IPath parent, String key) {
            IPath nextPath = Path.EMPTY.append(parent);
            nextPath.setDevice(key);
            return nextPath;
        }

        @Override
        public void toString(StringBuilder builder, IPath parentPath) {
            this.noDevice.toString(builder, parentPath);
            super.toString(builder, parentPath);
        }
    }

    private static class Node<T> {
        int depth;
        boolean exists;
        T value;
        Map<String, Node<T>> children;

        Node(int depth) {
            this.depth = depth;
        }

        String getSegment(IPath key) {
            return key.segment(this.depth);
        }

        Node<T> createNode(IPath key) {
            if (this.depth == key.segmentCount()) {
                this.exists = true;
                return this;
            }
            String nextSegment = this.getSegment(key);
            Node<T> next = this.createChild(nextSegment);
            return next.createNode(key);
        }

        public Node<T> createChild(String nextSegment) {
            Node<T> next;
            if (this.children == null) {
                this.children = new HashMap<String, Node<T>>();
            }
            if ((next = this.children.get(nextSegment)) == null) {
                next = new Node<T>(this.depth + 1);
                this.children.put(nextSegment, next);
            }
            return next;
        }

        public Node<T> getMostSpecificNode(IPath key) {
            if (this.depth == key.segmentCount()) {
                return this;
            }
            String nextSegment = this.getSegment(key);
            Node<T> child = this.getChild(nextSegment);
            if (child == null) {
                return this;
            }
            Node<T> result = child.getMostSpecificNode(key);
            if (result.exists) {
                return result;
            }
            return this;
        }

        Node<T> getChild(String nextSegment) {
            if (this.children == null) {
                return null;
            }
            return this.children.get(nextSegment);
        }

        IPath buildChildPath(IPath parent, String key) {
            IPath nextPath = parent.append(key);
            return nextPath;
        }

        public void toString(StringBuilder builder, IPath parentPath) {
            if (this.exists) {
                builder.append("[");
                builder.append(parentPath);
                builder.append("] = ");
                builder.append(this.value);
                builder.append("\n");
            }
            if (this.children != null) {
                for (Map.Entry<String, Node<T>> next : this.children.entrySet()) {
                    String key = next.getKey();
                    IPath nextPath = this.buildChildPath(parentPath, key);
                    next.getValue().toString(builder, nextPath);
                }
            }
        }
    }
}

