/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.java;

import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToOne;
import org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.eclipse.jdt.internal.core.nd.java.NdAnnotationValuePair;
import org.eclipse.jdt.internal.core.nd.java.NdConstantArray;
import org.eclipse.jdt.internal.core.nd.java.NdConstantBoolean;
import org.eclipse.jdt.internal.core.nd.java.NdConstantByte;
import org.eclipse.jdt.internal.core.nd.java.NdConstantChar;
import org.eclipse.jdt.internal.core.nd.java.NdConstantDouble;
import org.eclipse.jdt.internal.core.nd.java.NdConstantFloat;
import org.eclipse.jdt.internal.core.nd.java.NdConstantInt;
import org.eclipse.jdt.internal.core.nd.java.NdConstantLong;
import org.eclipse.jdt.internal.core.nd.java.NdConstantShort;
import org.eclipse.jdt.internal.core.nd.java.NdConstantString;
import org.eclipse.jdt.internal.core.nd.java.NdMethod;
import org.eclipse.jdt.internal.core.nd.java.NdVariable;

public abstract class NdConstant
extends NdNode {
    public static final FieldManyToOne<NdConstantArray> PARENT_ARRAY;
    public static final FieldOneToOne<NdAnnotationValuePair> PARENT_ANNOTATION_VALUE;
    public static final FieldOneToOne<NdVariable> PARENT_VARIABLE;
    public static final FieldOneToOne<NdMethod> PARENT_METHOD;
    public static StructDef<NdConstant> type;

    static {
        type = StructDef.createAbstract(NdConstant.class, NdNode.type);
        PARENT_ARRAY = FieldManyToOne.createOwner(type, NdConstantArray.ELEMENTS);
        PARENT_ANNOTATION_VALUE = FieldOneToOne.createOwner(type, NdAnnotationValuePair.type, NdAnnotationValuePair.VALUE);
        PARENT_VARIABLE = FieldOneToOne.createOwner(type, NdVariable.type, NdVariable.CONSTANT);
        PARENT_METHOD = FieldOneToOne.createOwner(type, NdMethod.type, NdMethod.DEFAULT_VALUE);
        type.done();
    }

    protected NdConstant(Nd nd) {
        super(nd);
    }

    public static NdConstant create(Nd nd, Constant constant) {
        if (constant == Constant.NotAConstant) {
            return null;
        }
        switch (constant.typeID()) {
            case 5: {
                return NdConstantBoolean.create(nd, constant.booleanValue());
            }
            case 3: {
                return NdConstantByte.create(nd, constant.byteValue());
            }
            case 2: {
                return NdConstantChar.create(nd, constant.charValue());
            }
            case 8: {
                return NdConstantDouble.create(nd, constant.doubleValue());
            }
            case 9: {
                return NdConstantFloat.create(nd, constant.floatValue());
            }
            case 10: {
                return NdConstantInt.create(nd, constant.intValue());
            }
            case 7: {
                return NdConstantLong.create(nd, constant.longValue());
            }
            case 4: {
                return NdConstantShort.create(nd, constant.shortValue());
            }
            case 11: {
                return NdConstantString.create(nd, constant.stringValue());
            }
        }
        throw new IllegalArgumentException("Unknown typeID() " + constant.typeID());
    }

    public void setParent(NdConstantArray result) {
        PARENT_ARRAY.put(this.getNd(), this.address, result);
    }

    public abstract Constant getConstant();

    public String toString() {
        try {
            return this.getConstant().toString();
        }
        catch (RuntimeException runtimeException) {
            return super.toString();
        }
    }
}

