/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserLibrary {
    private boolean isSystemLibrary;
    private IClasspathEntry[] entries;

    public UserLibrary(IClasspathEntry[] entries, boolean isSystemLibrary) {
        Assert.isNotNull(entries);
        this.entries = entries;
        this.isSystemLibrary = isSystemLibrary;
    }

    public IClasspathEntry[] getEntries() {
        return this.entries;
    }

    public boolean isSystemLibrary() {
        return this.isSystemLibrary;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            UserLibrary other = (UserLibrary)obj;
            if (this.entries.length == other.entries.length && this.isSystemLibrary == other.isSystemLibrary) {
                int i = 0;
                while (i < this.entries.length) {
                    if (!this.entries[i].equals(other.entries[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.isSystemLibrary) {
            ++hashCode;
        }
        int i = 0;
        while (i < this.entries.length) {
            hashCode = hashCode * 17 + this.entries[i].hashCode();
            ++i;
        }
        return hashCode;
    }

    public static UserLibrary createFromString(Reader reader) throws IOException {
        Element cpElement;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
            }
            catch (SAXException e) {
                throw new IOException(Messages.file_badFormat, e);
            }
            catch (ParserConfigurationException e) {
                throw new IOException(Messages.file_badFormat, e);
            }
        }
        finally {
            reader.close();
        }
        if (!cpElement.getNodeName().equalsIgnoreCase("userlibrary")) {
            throw new IOException(Messages.file_badFormat);
        }
        String version = cpElement.getAttribute("version");
        boolean isSystem = Boolean.valueOf(cpElement.getAttribute("systemlibrary"));
        NodeList list = cpElement.getChildNodes();
        int length = list.getLength();
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>(length);
        int i = 0;
        while (i < length) {
            Element element;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (element = (Element)node).getNodeName().equals("archive")) {
                String pathString = element.getAttribute("path");
                String sourceAttachString = element.hasAttribute("sourceattachment") ? element.getAttribute("sourceattachment") : null;
                String sourceAttachRootString = element.hasAttribute("sourceattachmentroot") ? element.getAttribute("sourceattachmentroot") : null;
                IPath entryPath = null;
                IPath sourceAttachPath = null;
                IPath sourceAttachRootPath = null;
                if (version.equals("1")) {
                    entryPath = Path.fromOSString(pathString);
                    if (sourceAttachString != null) {
                        sourceAttachPath = Path.fromOSString(sourceAttachString);
                    }
                    if (sourceAttachRootString != null) {
                        sourceAttachRootPath = Path.fromOSString(sourceAttachRootString);
                    }
                } else {
                    entryPath = Path.fromPortableString(pathString);
                    if (sourceAttachString != null) {
                        sourceAttachPath = Path.fromPortableString(sourceAttachString);
                    }
                    if (sourceAttachRootString != null) {
                        sourceAttachRootPath = Path.fromPortableString(sourceAttachRootString);
                    }
                }
                NodeList children = element.getElementsByTagName("*");
                boolean[] foundChildren = new boolean[children.getLength()];
                NodeList attributeList = ClasspathEntry.getChildAttributes("attributes", children, foundChildren);
                IClasspathAttribute[] extraAttributes = ClasspathEntry.decodeExtraAttributes(attributeList);
                attributeList = ClasspathEntry.getChildAttributes("accessrules", children, foundChildren);
                IAccessRule[] accessRules = ClasspathEntry.decodeAccessRules(attributeList);
                IClasspathEntry entry = JavaCore.newLibraryEntry(entryPath, sourceAttachPath, sourceAttachRootPath, accessRules, extraAttributes, false);
                res.add(entry);
            }
            ++i;
        }
        IClasspathEntry[] entries = res.toArray(new IClasspathEntry[res.size()]);
        return new UserLibrary(entries, isSystem);
    }

    public String toString() {
        if (this.entries == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        int length = this.entries.length;
        int i = 0;
        while (i < length) {
            buffer.append(String.valueOf(this.entries[i].toString()) + '\n');
            ++i;
        }
        return buffer.toString();
    }
}

