/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.impl;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.codeassist.impl.AssistParser;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;

public abstract class Engine
implements ITypeRequestor {
    public LookupEnvironment lookupEnvironment;
    public CompilerOptions compilerOptions;

    @Override
    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding, accessRestriction);
    }

    @Override
    public void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        CompilationResult result = new CompilationResult(sourceUnit, 1, 1, this.compilerOptions.maxProblemsPerUnit);
        AssistParser assistParser = this.getParser();
        Object parserState = assistParser.becomeSimpleParser();
        CompilationUnitDeclaration parsedUnit = assistParser.dietParse(sourceUnit, result);
        assistParser.restoreAssistParser(parserState);
        this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
        this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
    }

    @Override
    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        CompilationUnitDeclaration unit;
        LookupEnvironment environment;
        CompilationResult result = null;
        if (sourceTypes[0].getEnclosingType() != null) {
            try {
                SourceTypeElementInfo sourceType = sourceTypes[0] instanceof SourceType ? (SourceTypeElementInfo)((SourceType)((Object)sourceTypes[0])).getElementInfo() : (SourceTypeElementInfo)sourceTypes[0];
                IType[] types = sourceType.getHandle().getCompilationUnit().getTypes();
                sourceTypes = new ISourceType[types.length];
                sourceTypes[0] = sourceType;
                int length = types.length;
                int i = 0;
                while (i < length) {
                    ISourceType otherType;
                    sourceTypes[i] = otherType = (ISourceType)((JavaElement)((Object)types[i])).getElementInfo();
                    ++i;
                }
                ISourceType otherType = (ISourceType)((JavaElement)((Object)types[0])).getElementInfo();
                result = new CompilationResult(otherType.getFileName(), 1, 1, this.compilerOptions.maxProblemsPerUnit);
            }
            catch (JavaModelException javaModelException) {}
        } else {
            result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.compilerOptions.maxProblemsPerUnit);
        }
        if ((environment = packageBinding.environment) == null) {
            environment = this.lookupEnvironment;
        }
        if ((unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 15, environment.problemReporter, result)) != null) {
            environment.buildTypeBindings(unit, accessRestriction);
            environment.completeTypeBindings(unit, true);
        }
    }

    public abstract AssistParser getParser();
}

