/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;

class VariableBinding
implements IVariableBinding {
    private org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding;
    private ITypeBinding declaringClass;
    private String key;
    private String name;
    private BindingResolver resolver;
    private ITypeBinding type;

    VariableBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    @Override
    public ITypeBinding getDeclaringClass() {
        if (this.isField()) {
            if (this.declaringClass == null) {
                FieldBinding fieldBinding = (FieldBinding)this.binding;
                this.declaringClass = this.resolver.getTypeBinding(fieldBinding.declaringClass);
            }
            return this.declaringClass;
        }
        return null;
    }

    @Override
    public IMethodBinding getDeclaringMethod() {
        if (!this.isField()) {
            ASTNode node = this.resolver.findDeclaringNode(this);
            while (true) {
                if (node == null) {
                    LocalVariableBinding localVariableBinding;
                    MethodBinding enclosingMethod;
                    if (this.binding instanceof LocalVariableBinding && (enclosingMethod = (localVariableBinding = (LocalVariableBinding)this.binding).getEnclosingMethod()) != null) {
                        return this.resolver.getMethodBinding(enclosingMethod);
                    }
                    return null;
                }
                switch (node.getNodeType()) {
                    case 28: {
                        return null;
                    }
                    case 31: {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)node;
                        return methodDeclaration.resolveBinding();
                    }
                    case 86: {
                        LambdaExpression lambdaExpression = (LambdaExpression)node;
                        return lambdaExpression.resolveMethodBinding();
                    }
                }
                node = node.getParent();
            }
        }
        return null;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = new String(this.binding.name);
        }
        return this.name;
    }

    @Override
    public ITypeBinding getType() {
        if (this.type == null) {
            this.type = this.resolver.getTypeBinding(this.binding.type);
        }
        return this.type;
    }

    @Override
    public IVariableBinding getVariableDeclaration() {
        if (this.isField()) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            return this.resolver.getVariableBinding(fieldBinding.original());
        }
        return this;
    }

    @Override
    public boolean isParameter() {
        return (this.binding.tagBits & 0x400L) != 0L;
    }

    @Override
    public boolean isField() {
        return this.binding instanceof FieldBinding;
    }

    @Override
    public boolean isRecovered() {
        return false;
    }

    public String toString() {
        return this.binding.toString();
    }
}

