/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.core.util.Util;

class TypeBinding
implements ITypeBinding {
    private static final StringLiteral EXPRESSION = new StringLiteral(0, 0);
    protected static final IMethodBinding[] NO_METHOD_BINDINGS = new IMethodBinding[0];
    protected static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    protected static final IVariableBinding[] NO_VARIABLE_BINDINGS = new IVariableBinding[0];
    org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding;
    private TypeBinding prototype = null;
    private String key;
    protected BindingResolver resolver;
    private IMethodBinding[] methods;
    private ITypeBinding[] interfaces;
    private ITypeBinding[] typeArguments;

    public static TypeBinding createTypeBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.TypeBinding referenceBinding, IBinding declaringMember) {
        return declaringMember != null ? new LocalTypeBinding(resolver, referenceBinding, declaringMember) : new TypeBinding(resolver, referenceBinding);
    }

    public TypeBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding) {
        this.binding = binding;
        this.resolver = resolver;
        org.eclipse.jdt.internal.compiler.lookup.TypeBinding compilerPrototype = binding.prototype();
        this.prototype = (TypeBinding)(compilerPrototype == null || compilerPrototype == binding ? null : resolver.getTypeBinding(compilerPrototype));
    }

    @Override
    public String getBinaryName() {
        if (this.binding.isCapture()) {
            return null;
        }
        if (this.binding.isTypeVariable()) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
            Binding declaring = typeVariableBinding.declaringElement;
            StringBuffer binaryName = new StringBuffer();
            switch (declaring.kind()) {
                case 8: {
                    MethodBinding methodBinding = (MethodBinding)declaring;
                    char[] constantPoolName = methodBinding.declaringClass.constantPoolName();
                    if (constantPoolName == null) {
                        return null;
                    }
                    binaryName.append(CharOperation.replaceOnCopy(constantPoolName, '/', '.')).append('$').append(methodBinding.signature()).append('$').append(typeVariableBinding.sourceName);
                    break;
                }
                default: {
                    org.eclipse.jdt.internal.compiler.lookup.TypeBinding typeBinding = (org.eclipse.jdt.internal.compiler.lookup.TypeBinding)declaring;
                    char[] constantPoolName = typeBinding.constantPoolName();
                    if (constantPoolName == null) {
                        return null;
                    }
                    binaryName.append(CharOperation.replaceOnCopy(constantPoolName, '/', '.')).append('$').append(typeVariableBinding.sourceName);
                }
            }
            return String.valueOf(binaryName);
        }
        char[] constantPoolName = this.binding.constantPoolName();
        if (constantPoolName == null) {
            return null;
        }
        char[] dotSeparated = CharOperation.replaceOnCopy(constantPoolName, '/', '.');
        return new String(dotSeparated);
    }

    public ITypeBinding getBound() {
        switch (this.binding.kind()) {
            case 516: 
            case 8196: {
                WildcardBinding wildcardBinding = (WildcardBinding)this.binding;
                if (wildcardBinding.bound == null) break;
                return this.resolver.getTypeBinding(wildcardBinding.bound);
            }
        }
        return null;
    }

    @Override
    public synchronized IMethodBinding[] getDeclaredMethods() {
        if (this.prototype != null) {
            return this.prototype.getDeclaredMethods();
        }
        if (this.methods != null) {
            return this.methods;
        }
        try {
            ReferenceBinding referenceBinding;
            MethodBinding[] internalMethods;
            int length;
            if ((this.isClass() || this.isInterface() || this.isEnum()) && (length = (internalMethods = (referenceBinding = (ReferenceBinding)this.binding).availableMethods()).length) != 0) {
                int convertedMethodCount = 0;
                IMethodBinding[] newMethods = new IMethodBinding[length];
                int i = 0;
                while (i < length) {
                    IMethodBinding methodBinding2;
                    MethodBinding methodBinding = internalMethods[i];
                    if (!(methodBinding.isDefaultAbstract() || methodBinding.isSynthetic() || methodBinding.isConstructor() && this.isInterface() || (methodBinding2 = this.resolver.getMethodBinding(methodBinding)) == null)) {
                        newMethods[convertedMethodCount++] = methodBinding2;
                    }
                    ++i;
                }
                if (convertedMethodCount != length) {
                    if (convertedMethodCount == 0) {
                        this.methods = NO_METHOD_BINDINGS;
                        return NO_METHOD_BINDINGS;
                    }
                    IMethodBinding[] iMethodBindingArray = newMethods;
                    newMethods = new IMethodBinding[convertedMethodCount];
                    System.arraycopy(iMethodBindingArray, 0, newMethods, 0, convertedMethodCount);
                }
                this.methods = newMethods;
                return newMethods;
            }
        }
        catch (RuntimeException e) {
            Util.log(e, "Could not retrieve declared methods");
        }
        this.methods = NO_METHOD_BINDINGS;
        return NO_METHOD_BINDINGS;
    }

    public synchronized ITypeBinding getDeclaringClass() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            if (referenceBinding.isNestedType()) {
                try {
                    return this.resolver.getTypeBinding(referenceBinding.enclosingType());
                }
                catch (RuntimeException e) {
                    Util.log(e, "Could not retrieve declaring class");
                }
            }
        } else if (this.binding.isTypeVariable()) {
            Binding declaringElement;
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
            Binding binding = declaringElement = typeVariableBinding.isCapture() ? ((CaptureBinding)typeVariableBinding).sourceType : typeVariableBinding.declaringElement;
            if (declaringElement instanceof ReferenceBinding) {
                try {
                    return this.resolver.getTypeBinding((ReferenceBinding)declaringElement);
                }
                catch (RuntimeException e) {
                    Util.log(e, "Could not retrieve declaring class");
                }
            }
        }
        return null;
    }

    @Override
    public IBinding getDeclaringMember() {
        return null;
    }

    public int getDimensions() {
        if (!this.isArray()) {
            return 0;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return arrayBinding.dimensions;
    }

    public ITypeBinding getElementType() {
        if (!this.isArray()) {
            return null;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return this.resolver.getTypeBinding(arrayBinding.leafComponentType);
    }

    @Override
    public ITypeBinding getTypeDeclaration() {
        if (this.binding instanceof ParameterizedTypeBinding) {
            return this.resolver.getTypeBinding(((ParameterizedTypeBinding)this.binding).genericType());
        }
        return this.resolver.getTypeBinding(this.binding.unannotated());
    }

    @Override
    public ITypeBinding getErasure() {
        return this.resolver.getTypeBinding(this.binding.erasure());
    }

    @Override
    public synchronized ITypeBinding[] getInterfaces() {
        int length;
        if (this.prototype != null) {
            return this.prototype.getInterfaces();
        }
        if (this.interfaces != null) {
            return this.interfaces;
        }
        if (this.binding == null) {
            this.interfaces = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        switch (this.binding.kind()) {
            case 68: 
            case 132: {
                this.interfaces = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        ReferenceBinding[] internalInterfaces = null;
        try {
            internalInterfaces = referenceBinding.superInterfaces();
        }
        catch (RuntimeException e) {
            Util.log(e, "Could not retrieve interfaces");
        }
        int n = length = internalInterfaces == null ? 0 : internalInterfaces.length;
        if (length != 0) {
            ITypeBinding[] newInterfaces = new ITypeBinding[length];
            int interfacesCounter = 0;
            int i = 0;
            while (i < length) {
                ITypeBinding typeBinding = this.resolver.getTypeBinding(internalInterfaces[i]);
                if (typeBinding != null) {
                    newInterfaces[interfacesCounter++] = typeBinding;
                }
                ++i;
            }
            if (length != interfacesCounter) {
                ITypeBinding[] iTypeBindingArray = newInterfaces;
                newInterfaces = new ITypeBinding[interfacesCounter];
                System.arraycopy(iTypeBindingArray, 0, newInterfaces, 0, interfacesCounter);
            }
            this.interfaces = newInterfaces;
            return newInterfaces;
        }
        this.interfaces = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    @Override
    public String getName() {
        switch (this.binding.kind()) {
            case 516: 
            case 8196: {
                WildcardBinding wildcardBinding = (WildcardBinding)this.binding;
                StringBuffer buffer = new StringBuffer();
                buffer.append(TypeConstants.WILDCARD_NAME);
                if (wildcardBinding.bound != null) {
                    switch (wildcardBinding.boundKind) {
                        case 2: {
                            buffer.append(TypeConstants.WILDCARD_SUPER);
                            break;
                        }
                        case 1: {
                            buffer.append(TypeConstants.WILDCARD_EXTENDS);
                        }
                    }
                    buffer.append(this.getBound().getName());
                }
                return String.valueOf(buffer);
            }
            case 4100: {
                if (this.isCapture()) {
                    return "";
                }
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
                return new String(typeVariableBinding.sourceName);
            }
            case 260: {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.binding;
                StringBuffer buffer = new StringBuffer();
                buffer.append(parameterizedTypeBinding.sourceName());
                ITypeBinding[] tArguments = this.getTypeArguments();
                int typeArgumentsLength = tArguments.length;
                if (typeArgumentsLength != 0) {
                    buffer.append('<');
                    int i = 0;
                    while (i < typeArgumentsLength) {
                        if (i > 0) {
                            buffer.append(',');
                        }
                        buffer.append(tArguments[i].getName());
                        ++i;
                    }
                    buffer.append('>');
                }
                return String.valueOf(buffer);
            }
            case 1028: {
                return this.getTypeDeclaration().getName();
            }
            case 68: {
                ITypeBinding elementType = this.getElementType();
                if (elementType.isLocal() || elementType.isAnonymous() || elementType.isCapture()) {
                    return "";
                }
                int dimensions = this.getDimensions();
                char[] brackets = new char[dimensions * 2];
                int i = dimensions * 2 - 1;
                while (i >= 0) {
                    brackets[i] = 93;
                    brackets[i - 1] = 91;
                    i -= 2;
                }
                StringBuffer buffer = new StringBuffer(elementType.getName());
                buffer.append(brackets);
                return String.valueOf(buffer);
            }
            case 32772: {
                return new String(((IntersectionTypeBinding18)this.binding).getIntersectingTypes()[0].sourceName());
            }
        }
        if (this.isPrimitive() || this.isNullType()) {
            BaseTypeBinding baseTypeBinding = (BaseTypeBinding)this.binding;
            return new String(baseTypeBinding.simpleName);
        }
        if (this.isAnonymous()) {
            return "";
        }
        return new String(this.binding.sourceName());
    }

    @Override
    public IPackageBinding getPackage() {
        switch (this.binding.kind()) {
            case 68: 
            case 132: 
            case 516: 
            case 4100: 
            case 8196: 
            case 32772: {
                return null;
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        return this.resolver.getPackageBinding(referenceBinding.getPackage());
    }

    @Override
    public String getQualifiedName() {
        switch (this.binding.kind()) {
            case 516: 
            case 8196: {
                WildcardBinding wildcardBinding = (WildcardBinding)this.binding;
                StringBuffer buffer = new StringBuffer();
                buffer.append(TypeConstants.WILDCARD_NAME);
                ITypeBinding bound = this.getBound();
                if (bound != null) {
                    switch (wildcardBinding.boundKind) {
                        case 2: {
                            buffer.append(TypeConstants.WILDCARD_SUPER);
                            break;
                        }
                        case 1: {
                            buffer.append(TypeConstants.WILDCARD_EXTENDS);
                        }
                    }
                    buffer.append(bound.getQualifiedName());
                }
                return String.valueOf(buffer);
            }
            case 1028: {
                return this.getTypeDeclaration().getQualifiedName();
            }
            case 68: {
                ITypeBinding elementType = this.getElementType();
                if (elementType.isLocal() || elementType.isAnonymous() || elementType.isCapture()) {
                    return elementType.getQualifiedName();
                }
                int dimensions = this.getDimensions();
                char[] brackets = new char[dimensions * 2];
                int i = dimensions * 2 - 1;
                while (i >= 0) {
                    brackets[i] = 93;
                    brackets[i - 1] = 91;
                    i -= 2;
                }
                StringBuffer buffer = new StringBuffer(elementType.getQualifiedName());
                buffer.append(brackets);
                return String.valueOf(buffer);
            }
            case 4100: {
                if (this.isCapture()) {
                    return "";
                }
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
                return new String(typeVariableBinding.sourceName);
            }
            case 260: {
                if (this.binding.isLocalType()) {
                    return "";
                }
                StringBuffer buffer = new StringBuffer();
                if (this.isMember()) {
                    buffer.append(this.getDeclaringClass().getQualifiedName()).append('.');
                    ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.binding;
                    buffer.append(parameterizedTypeBinding.sourceName());
                    ITypeBinding[] tArguments = this.getTypeArguments();
                    int typeArgumentsLength = tArguments.length;
                    if (typeArgumentsLength != 0) {
                        buffer.append('<');
                        int i = 0;
                        while (i < typeArgumentsLength) {
                            if (i > 0) {
                                buffer.append(',');
                            }
                            buffer.append(tArguments[i].getQualifiedName());
                            ++i;
                        }
                        buffer.append('>');
                    }
                    return String.valueOf(buffer);
                }
                buffer.append(this.getTypeDeclaration().getQualifiedName());
                ITypeBinding[] tArguments = this.getTypeArguments();
                int typeArgumentsLength = tArguments.length;
                if (typeArgumentsLength != 0) {
                    buffer.append('<');
                    int i = 0;
                    while (i < typeArgumentsLength) {
                        if (i > 0) {
                            buffer.append(',');
                        }
                        buffer.append(tArguments[i].getQualifiedName());
                        ++i;
                    }
                    buffer.append('>');
                }
                return String.valueOf(buffer);
            }
        }
        if (this.isAnonymous() || this.binding.isLocalType() || this.binding.isIntersectionType18()) {
            return "";
        }
        if (this.isPrimitive() || this.isNullType()) {
            BaseTypeBinding baseTypeBinding = (BaseTypeBinding)this.binding;
            return new String(baseTypeBinding.simpleName);
        }
        if (this.isMember()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getDeclaringClass().getQualifiedName()).append('.');
            buffer.append(this.getName());
            return String.valueOf(buffer);
        }
        PackageBinding packageBinding = this.binding.getPackage();
        StringBuffer buffer = new StringBuffer();
        if (packageBinding != null && packageBinding.compoundName != CharOperation.NO_CHAR_CHAR) {
            buffer.append(CharOperation.concatWith(packageBinding.compoundName, '.')).append('.');
        }
        buffer.append(this.getName());
        return String.valueOf(buffer);
    }

    @Override
    public synchronized ITypeBinding getSuperclass() {
        if (this.binding == null) {
            return null;
        }
        switch (this.binding.kind()) {
            case 68: 
            case 132: {
                return null;
            }
        }
        if (this.binding.isInterface()) {
            return null;
        }
        ReferenceBinding superclass = null;
        try {
            superclass = ((ReferenceBinding)this.binding).superclass();
        }
        catch (RuntimeException e) {
            Util.log(e, "Could not retrieve superclass");
            return this.resolver.resolveWellKnownType("java.lang.Object");
        }
        if (superclass == null) {
            return null;
        }
        return this.resolver.getTypeBinding(superclass);
    }

    public ITypeBinding[] getTypeArguments() {
        if (this.prototype != null) {
            return this.prototype.getTypeArguments();
        }
        if (this.typeArguments != null) {
            return this.typeArguments;
        }
        if (this.binding.isParameterizedTypeWithActualArguments()) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.binding;
            org.eclipse.jdt.internal.compiler.lookup.TypeBinding[] arguments = parameterizedTypeBinding.arguments;
            int argumentsLength = arguments.length;
            ITypeBinding[] newTypeArguments = new ITypeBinding[argumentsLength];
            int i = 0;
            while (i < argumentsLength) {
                ITypeBinding typeBinding = this.resolver.getTypeBinding(arguments[i]);
                if (typeBinding == null) {
                    this.typeArguments = NO_TYPE_BINDINGS;
                    return NO_TYPE_BINDINGS;
                }
                newTypeArguments[i] = typeBinding;
                ++i;
            }
            this.typeArguments = newTypeArguments;
            return newTypeArguments;
        }
        this.typeArguments = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    @Override
    public boolean isAnonymous() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isAnonymousType();
        }
        return false;
    }

    @Override
    public boolean isArray() {
        return this.binding.isArrayType();
    }

    @Override
    public boolean isCapture() {
        return this.binding.isCapture();
    }

    public boolean isClass() {
        switch (this.binding.kind()) {
            case 516: 
            case 4100: 
            case 8196: {
                return false;
            }
        }
        return this.binding.isClass();
    }

    public boolean isEnum() {
        return this.binding.isEnum();
    }

    public boolean isInterface() {
        switch (this.binding.kind()) {
            case 516: 
            case 4100: 
            case 8196: {
                return false;
            }
        }
        return this.binding.isInterface();
    }

    @Override
    public boolean isLocal() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isLocalType() && !referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isMember() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isNullType() {
        return this.binding == org.eclipse.jdt.internal.compiler.lookup.TypeBinding.NULL;
    }

    public boolean isPrimitive() {
        return !this.isNullType() && this.binding.isBaseType();
    }

    @Override
    public boolean isRecovered() {
        return (this.binding.tagBits & 0x80L) != 0L;
    }

    @Override
    public boolean isTypeVariable() {
        return this.binding.isTypeVariable() && !this.binding.isCapture();
    }

    public String toString() {
        return this.binding.toString();
    }

    static class LocalTypeBinding
    extends TypeBinding {
        private IBinding declaringMember;

        public LocalTypeBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding, IBinding declaringMember) {
            super(resolver, binding);
            this.declaringMember = declaringMember;
        }

        @Override
        public IBinding getDeclaringMember() {
            return this.declaringMember;
        }
    }
}

