/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.DefaultBindingResolver;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.util.Util;

class MethodBinding
implements IMethodBinding {
    private static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    protected org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding;
    protected BindingResolver resolver;
    private volatile ITypeBinding[] parameterTypes;
    private volatile String name;
    private volatile ITypeBinding declaringClass;
    private volatile ITypeBinding returnType;
    private volatile String key;

    MethodBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    @Override
    public boolean isConstructor() {
        return this.binding.isConstructor();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.binding.isConstructor() ? this.getDeclaringClass().getName() : new String(this.binding.selector);
        }
        return this.name;
    }

    @Override
    public ITypeBinding getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = this.resolver.getTypeBinding(this.binding.declaringClass);
        }
        return this.declaringClass;
    }

    @Override
    public ITypeBinding[] getParameterTypes() {
        int length;
        if (this.parameterTypes != null) {
            return this.parameterTypes;
        }
        TypeBinding[] parameters = this.binding.parameters;
        int n = length = parameters == null ? 0 : parameters.length;
        if (length == 0) {
            this.parameterTypes = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] paramTypes = new ITypeBinding[length];
        int i = 0;
        while (i < length) {
            ITypeBinding typeBinding;
            TypeBinding parameterBinding = parameters[i];
            if (parameterBinding != null) {
                typeBinding = this.resolver.getTypeBinding(parameterBinding);
                if (typeBinding == null) {
                    this.parameterTypes = NO_TYPE_BINDINGS;
                    return NO_TYPE_BINDINGS;
                }
            } else {
                StringBuffer message = new StringBuffer("Report method binding where a parameter is null:\n");
                message.append(this.toString());
                Util.log(new IllegalArgumentException(), message.toString());
                this.parameterTypes = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
            paramTypes[i] = typeBinding;
            ++i;
        }
        this.parameterTypes = paramTypes;
        return paramTypes;
    }

    @Override
    public ITypeBinding getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.resolver.getTypeBinding(this.binding.returnType);
        }
        return this.returnType;
    }

    @Override
    public boolean isRecovered() {
        return false;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    @Override
    public IMethodBinding getMethodDeclaration() {
        return this.resolver.getMethodBinding(this.binding.original());
    }

    @Override
    public boolean overrides(IMethodBinding otherMethod) {
        LookupEnvironment lookupEnvironment = this.resolver.lookupEnvironment();
        return lookupEnvironment != null && lookupEnvironment.methodVerifier().doesMethodOverride(this.binding, ((MethodBinding)otherMethod).binding);
    }

    public String toString() {
        return this.binding.toString();
    }

    static class LambdaMethod
    extends MethodBinding {
        private MethodBinding implementation;
        private IBinding declaringMember;

        public LambdaMethod(DefaultBindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.MethodBinding lambdaDescriptor, org.eclipse.jdt.internal.compiler.lookup.MethodBinding implementation, IBinding declaringMember) {
            super(resolver, lambdaDescriptor);
            this.implementation = new MethodBinding(resolver, implementation);
            this.declaringMember = declaringMember;
        }

        @Override
        public String getKey() {
            return this.implementation.getKey();
        }

        @Override
        public ITypeBinding[] getParameterTypes() {
            return this.implementation.getParameterTypes();
        }

        @Override
        public IMethodBinding getMethodDeclaration() {
            return this.resolver.getMethodBinding(this.binding);
        }

        @Override
        public String toString() {
            return super.toString().replace("public abstract ", "public ");
        }
    }
}

