/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.DefaultCommentMapper;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.util.Util;

public class CompilationUnit
extends ASTNode {
    private static final Message[] EMPTY_MESSAGES = new Message[0];
    private static final IProblem[] EMPTY_PROBLEMS = new IProblem[0];
    public static final ChildListPropertyDescriptor IMPORTS_PROPERTY = new ChildListPropertyDescriptor(CompilationUnit.class, "imports", ImportDeclaration.class, false);
    public static final ChildPropertyDescriptor PACKAGE_PROPERTY = new ChildPropertyDescriptor(CompilationUnit.class, "package", PackageDeclaration.class, false, false);
    public static final ChildPropertyDescriptor MODULE_PROPERTY = new ChildPropertyDescriptor(CompilationUnit.class, "module", ModuleDeclaration.class, false, false);
    private static final List PROPERTY_DESCRIPTORS;
    private static final List PROPERTY_DESCRIPTORS_9_0;
    public static final ChildListPropertyDescriptor TYPES_PROPERTY;
    private DefaultCommentMapper commentMapper = null;
    private ITypeRoot typeRoot = null;
    private ASTNode.NodeList imports = new ASTNode.NodeList(IMPORTS_PROPERTY);
    private int[] lineEndTable = Util.EMPTY_INT_ARRAY;
    private List optionalCommentList = null;
    Comment[] optionalCommentTable = null;
    private PackageDeclaration optionalPackageDeclaration = null;
    private ModuleDeclaration module = null;
    private IProblem[] problems = EMPTY_PROBLEMS;
    private Object statementsRecoveryData;
    private ASTNode.NodeList types = new ASTNode.NodeList(TYPES_PROPERTY);

    static {
        TYPES_PROPERTY = new ChildListPropertyDescriptor(CompilationUnit.class, "types", AbstractTypeDeclaration.class, true);
        ArrayList properyList = new ArrayList(4);
        CompilationUnit.createPropertyList(CompilationUnit.class, properyList);
        CompilationUnit.addProperty(PACKAGE_PROPERTY, properyList);
        CompilationUnit.addProperty(IMPORTS_PROPERTY, properyList);
        CompilationUnit.addProperty(TYPES_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = CompilationUnit.reapPropertyList(properyList);
        properyList = new ArrayList(5);
        CompilationUnit.createPropertyList(CompilationUnit.class, properyList);
        CompilationUnit.addProperty(PACKAGE_PROPERTY, properyList);
        CompilationUnit.addProperty(IMPORTS_PROPERTY, properyList);
        CompilationUnit.addProperty(TYPES_PROPERTY, properyList);
        CompilationUnit.addProperty(MODULE_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS_9_0 = CompilationUnit.reapPropertyList(properyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel < 9) {
            return PROPERTY_DESCRIPTORS;
        }
        return PROPERTY_DESCRIPTORS_9_0;
    }

    CompilationUnit(AST ast) {
        super(ast);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel >= 9) {
                this.acceptChild(visitor, this.getModule());
            }
            this.acceptChild(visitor, this.getPackage());
            this.acceptChildren(visitor, this.imports);
            this.acceptChildren(visitor, this.types);
        }
        visitor.endVisit(this);
    }

    public List getCommentList() {
        return this.optionalCommentList;
    }

    @Override
    final int getNodeType0() {
        return 15;
    }

    public ModuleDeclaration getModule() {
        this.unsupportedBelow9();
        return this.module;
    }

    public PackageDeclaration getPackage() {
        return this.optionalPackageDeclaration;
    }

    public IProblem[] getProblems() {
        return this.problems;
    }

    public List imports() {
        return this.imports;
    }

    void initCommentMapper(Scanner scanner) {
        this.commentMapper = new DefaultCommentMapper(this.optionalCommentTable);
        this.commentMapper.initialize(this, scanner);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == IMPORTS_PROPERTY) {
            return this.imports();
        }
        if (property == TYPES_PROPERTY) {
            return this.types();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == MODULE_PROPERTY) {
            if (get) {
                return this.getModule();
            }
            this.setModule((ModuleDeclaration)child);
            return null;
        }
        if (property == PACKAGE_PROPERTY) {
            if (get) {
                return this.getPackage();
            }
            this.setPackage((PackageDeclaration)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return CompilationUnit.propertyDescriptors(apiLevel);
    }

    void setCommentTable(Comment[] commentTable) {
        if (commentTable == null) {
            this.optionalCommentList = null;
            this.optionalCommentTable = null;
        } else {
            int nextAvailablePosition = 0;
            int i = 0;
            while (i < commentTable.length) {
                Comment comment = commentTable[i];
                if (comment == null) {
                    throw new IllegalArgumentException();
                }
                int start = comment.getStartPosition();
                int length = comment.getLength();
                if (start < 0 || length < 0 || start < nextAvailablePosition) {
                    throw new IllegalArgumentException();
                }
                nextAvailablePosition = comment.getStartPosition() + comment.getLength();
                ++i;
            }
            this.optionalCommentTable = commentTable;
            List<Comment> commentList = Arrays.asList(commentTable);
            this.optionalCommentList = Collections.unmodifiableList(commentList);
        }
    }

    void setTypeRoot(ITypeRoot typeRoot) {
        this.typeRoot = typeRoot;
    }

    void setLineEndTable(int[] lineEndTable) {
        if (lineEndTable == null) {
            throw new NullPointerException();
        }
        this.checkModifiable();
        this.lineEndTable = lineEndTable;
    }

    public void setModule(ModuleDeclaration module) {
        this.unsupportedBelow9();
        ModuleDeclaration oldChild = this.module;
        this.preReplaceChild(oldChild, module, MODULE_PROPERTY);
        this.module = module;
        this.postReplaceChild(oldChild, module, MODULE_PROPERTY);
    }

    public void setPackage(PackageDeclaration pkgDecl) {
        PackageDeclaration oldChild = this.optionalPackageDeclaration;
        this.preReplaceChild(oldChild, pkgDecl, PACKAGE_PROPERTY);
        this.optionalPackageDeclaration = pkgDecl;
        this.postReplaceChild(oldChild, pkgDecl, PACKAGE_PROPERTY);
    }

    void setProblems(IProblem[] problems) {
        if (problems == null) {
            throw new IllegalArgumentException();
        }
        this.problems = problems;
    }

    void setStatementsRecoveryData(Object data) {
        this.statementsRecoveryData = data;
    }

    public List types() {
        return this.types;
    }
}

