/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.util.Messages;

public final class JavaConventions {
    private static final Pattern DOT_DOT = Pattern.compile("(\\.)(\\1)+");
    private static final Pattern PREFIX_JAVA = Pattern.compile("java$");
    private static final Scanner SCANNER = new Scanner(false, true, false, 0x2F0000L, null, null, true);

    private static synchronized char[] scannedIdentifier(String id, String sourceLevel, String complianceLevel) {
        block7: {
            if (id == null) {
                return null;
            }
            JavaConventions.SCANNER.sourceLevel = sourceLevel == null ? 0x2F0000L : CompilerOptions.versionToJdkLevel(sourceLevel);
            JavaConventions.SCANNER.complianceLevel = complianceLevel == null ? 0x2F0000L : CompilerOptions.versionToJdkLevel(complianceLevel);
            try {
                SCANNER.setSource(id.toCharArray());
                int token = SCANNER.scanIdentifier();
                if (token == 22) break block7;
                return null;
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
        }
        if (JavaConventions.SCANNER.currentPosition == JavaConventions.SCANNER.eofPosition) {
            try {
                return SCANNER.getCurrentIdentifierSource();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    public static IStatus validateCompilationUnitName(String name, String sourceLevel, String complianceLevel) {
        IStatus status;
        if (name == null) {
            return new Status(4, "org.eclipse.jdt.core", -1, Messages.convention_unit_nullName, null);
        }
        if (!org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(name)) {
            return new Status(4, "org.eclipse.jdt.core", -1, Messages.convention_unit_notJavaName, null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "org.eclipse.jdt.core", -1, Messages.convention_unit_notJavaName, null);
        }
        String identifier = name.substring(0, index);
        if (!(CharOperation.equals(identifier.toCharArray(), TypeConstants.PACKAGE_INFO_NAME) || CharOperation.equals(identifier.toCharArray(), TypeConstants.MODULE_INFO_NAME) || (status = JavaConventions.validateIdentifier(identifier, sourceLevel, complianceLevel)).isOK())) {
            return status;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateClassFileName(String name, String sourceLevel, String complianceLevel) {
        IStatus status;
        if (name == null) {
            return new Status(4, "org.eclipse.jdt.core", -1, Messages.convention_classFile_nullName, null);
        }
        if (!Util.isClassFileName(name)) {
            return new Status(4, "org.eclipse.jdt.core", -1, Messages.convention_classFile_notClassFileName, null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "org.eclipse.jdt.core", -1, Messages.convention_classFile_notClassFileName, null);
        }
        String identifier = name.substring(0, index);
        if (!(CharOperation.equals(identifier.toCharArray(), TypeConstants.PACKAGE_INFO_NAME) || CharOperation.equals(identifier.toCharArray(), TypeConstants.MODULE_INFO_NAME) || (status = JavaConventions.validateIdentifier(identifier, sourceLevel, complianceLevel)).isOK())) {
            return status;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateIdentifier(String id, String sourceLevel, String complianceLevel) {
        if (JavaConventions.scannedIdentifier(id, sourceLevel, complianceLevel) != null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.jdt.core", -1, Messages.bind(Messages.convention_illegalIdentifier, id), null);
    }

    public static IStatus validatePackageName(String name, String sourceLevel, String complianceLevel) {
        if (name == null) {
            return new Status(4, "org.eclipse.jdt.core", -1, Messages.convention_package_nullName, null);
        }
        int length = name.length();
        if (length == 0) {
            return new Status(4, "org.eclipse.jdt.core", -1, Messages.convention_package_emptyName, null);
        }
        if (name.charAt(0) == '.' || name.charAt(length - 1) == '.') {
            return new Status(4, "org.eclipse.jdt.core", -1, Messages.convention_package_dotName, null);
        }
        if (CharOperation.isWhitespace(name.charAt(0)) || CharOperation.isWhitespace(name.charAt(name.length() - 1))) {
            return new Status(4, "org.eclipse.jdt.core", -1, Messages.convention_package_nameWithBlanks, null);
        }
        if (DOT_DOT.matcher(name).find()) {
            return new Status(4, "org.eclipse.jdt.core", -1, Messages.convention_package_consecutiveDotsName, null);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        StringTokenizer st = new StringTokenizer(name, ".");
        boolean firstToken = true;
        Status warningStatus = null;
        while (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            char[] scannedID = JavaConventions.scannedIdentifier(typeName = typeName.trim(), sourceLevel, complianceLevel);
            if (scannedID == null) {
                return new Status(4, "org.eclipse.jdt.core", -1, Messages.bind(Messages.convention_illegalIdentifier, typeName), null);
            }
            IStatus status = workspace.validateName(new String(scannedID), 2);
            if (!status.isOK()) {
                return status;
            }
            if (firstToken && scannedID.length > 0 && ScannerHelper.isUpperCase(scannedID[0]) && warningStatus == null) {
                warningStatus = new Status(2, "org.eclipse.jdt.core", -1, Messages.convention_package_uppercaseName, null);
            }
            firstToken = false;
        }
        if (warningStatus != null) {
            return warningStatus;
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

