/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.internal.runtime.TracingOptions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public final class SubMonitor
implements IProgressMonitorWithBlocking {
    private int totalParent;
    private int usedForParent = 0;
    private double usedForChildren = 0.0;
    private int totalForChildren;
    private SubMonitor lastSubMonitor;
    private final RootInfo root;
    private final int flags;
    private boolean beginTaskCalled;
    private boolean ticksAllocated;
    private static final Set<String> knownBuggyMethods = new HashSet<String>();

    private SubMonitor(RootInfo rootInfo, int totalWork, int availableToChildren, int flags) {
        this.root = rootInfo;
        this.totalParent = totalWork > 0 ? totalWork : 0;
        this.totalForChildren = availableToChildren;
        this.flags = flags;
        this.ticksAllocated = availableToChildren > 0;
    }

    public static SubMonitor convert(IProgressMonitor monitor) {
        return SubMonitor.convert(monitor, "", 0);
    }

    public static SubMonitor convert(IProgressMonitor monitor, int work) {
        return SubMonitor.convert(monitor, "", work);
    }

    public static SubMonitor convert(IProgressMonitor monitor, String taskName, int work) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
            return new SubMonitor(new RootInfo(monitor), 0, work, 7);
        }
        if (monitor instanceof SubMonitor) {
            SubMonitor subMonitor = (SubMonitor)monitor;
            subMonitor.beginTaskImpl(taskName, work);
            return subMonitor;
        }
        monitor.beginTask(taskName, 1000);
        return new SubMonitor(new RootInfo(monitor), 1000, work, 0);
    }

    public static void done(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.done();
        }
    }

    public SubMonitor setWorkRemaining(int workRemaining) {
        if (TracingOptions.debugProgressMonitors && this.ticksAllocated && this.usedForChildren >= (double)this.totalForChildren && workRemaining > 0) {
            SubMonitor.logProblem("Attempted to allocate ticks on a SubMonitor which had no space available. This may indicate that a SubMonitor was reused inappropriately (which is a bug) or may indicate that the caller was implementing infinite progress and overflowed (which may not be a bug but may require selecting a higher ratio)");
        }
        if (workRemaining > 0) {
            this.ticksAllocated = true;
        } else {
            workRemaining = 0;
        }
        if (this.totalForChildren > 0 && this.totalParent > this.usedForParent) {
            double remainForParent = (double)this.totalParent * (1.0 - this.usedForChildren / (double)this.totalForChildren);
            this.usedForChildren = (double)workRemaining * (1.0 - remainForParent / (double)(this.totalParent - this.usedForParent));
        } else {
            this.usedForChildren = 0.0;
        }
        this.totalParent -= this.usedForParent;
        this.usedForParent = 0;
        this.totalForChildren = workRemaining;
        return this;
    }

    private int consume(double ticks) {
        if (TracingOptions.debugProgressMonitors && !this.ticksAllocated && ticks > 0.0) {
            SubMonitor.logProblem("You must allocate ticks using beginTask or setWorkRemaining before trying to consume them");
        }
        if (this.totalParent == 0 || this.totalForChildren == 0) {
            return 0;
        }
        this.usedForChildren += ticks;
        if (this.usedForChildren > (double)this.totalForChildren) {
            this.usedForChildren = this.totalForChildren;
            if (TracingOptions.debugProgressMonitors) {
                SubMonitor.logProblem("This progress monitor consumed more ticks than were allocated for it.");
            }
        } else if (this.usedForChildren < 0.0) {
            this.usedForChildren = 0.0;
        }
        int parentPosition = (int)((double)this.totalParent * this.usedForChildren / (double)this.totalForChildren);
        int delta = parentPosition - this.usedForParent;
        this.usedForParent = parentPosition;
        return delta;
    }

    @Override
    public boolean isCanceled() {
        if ((this.flags & 8) == 0) {
            return this.root.isCanceled();
        }
        return false;
    }

    public SubMonitor checkCanceled() throws OperationCanceledException {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        return this;
    }

    @Override
    public void setTaskName(String name) {
        if ((this.flags & 4) == 0) {
            this.root.setTaskName(name);
        }
    }

    @Override
    public void beginTask(String name, int totalWork) {
        if (TracingOptions.debugProgressMonitors && this.beginTaskCalled) {
            SubMonitor.logProblem("beginTask was called on this instance more than once");
        }
        this.beginTaskImpl(name, totalWork);
    }

    private void beginTaskImpl(String name, int totalWork) {
        if ((this.flags & 2) == 0 && name != null) {
            this.root.setTaskName(name);
        }
        this.setWorkRemaining(totalWork);
        this.beginTaskCalled = true;
    }

    @Override
    public void done() {
        this.cleanupActiveChild();
        int delta = this.totalParent - this.usedForParent;
        if (delta > 0) {
            this.root.worked(delta);
        }
        this.totalParent = 0;
        this.usedForParent = 0;
        this.totalForChildren = 0;
        this.usedForChildren = 0.0;
    }

    @Override
    public void internalWorked(double work) {
        this.cleanupActiveChild();
        int delta = this.consume(work > 0.0 ? work : 0.0);
        if (delta != 0) {
            this.root.worked(delta);
        }
    }

    @Override
    public void subTask(String name) {
        if ((this.flags & 1) == 0) {
            this.root.subTask(name);
        }
    }

    @Override
    public void worked(int work) {
        if (TracingOptions.debugProgressMonitors && work == 0) {
            SubMonitor.logProblem("Attempted to report 0 ticks of work");
        }
        this.internalWorked(work);
    }

    @Override
    public void setCanceled(boolean b) {
        this.root.setCanceled(b);
    }

    public SubMonitor newChild(int totalWork) {
        return this.newChild(totalWork, 2);
    }

    public SubMonitor newChild(int totalWork, int suppressFlags) {
        SubMonitor result;
        double totalWorkDouble = totalWork > 0 ? (double)totalWork : 0.0;
        totalWorkDouble = Math.min(totalWorkDouble, (double)this.totalForChildren - this.usedForChildren);
        SubMonitor oldActiveChild = this.lastSubMonitor;
        this.cleanupActiveChild();
        int childFlags = this.flags & 9;
        if ((this.flags & 4) != 0) {
            childFlags |= 6;
        }
        childFlags |= suppressFlags & 0xF;
        int consumed = this.consume(totalWorkDouble);
        if (TracingOptions.debugProgressMonitors) {
            if (totalWork == 0) {
                SubMonitor.logProblem("Attempted to create a child without providing it with any ticks");
            }
        } else {
            if (consumed == 0 && oldActiveChild != null && childFlags == oldActiveChild.flags) {
                this.lastSubMonitor = oldActiveChild;
                return oldActiveChild;
            }
            if (this.usedForParent >= this.totalParent && childFlags == this.flags) {
                this.totalParent = consumed;
                this.usedForParent = 0;
                this.totalForChildren = 0;
                this.usedForChildren = 0.0;
                return this;
            }
        }
        this.lastSubMonitor = result = new SubMonitor(this.root, consumed, 0, childFlags);
        return result;
    }

    public SubMonitor split(int totalWork) throws OperationCanceledException {
        return this.split(totalWork, 2);
    }

    public SubMonitor split(int totalWork, int suppressFlags) throws OperationCanceledException {
        int oldUsedForParent = this.usedForParent;
        SubMonitor result = this.newChild(totalWork, suppressFlags);
        if ((result.flags & 8) == 0) {
            int ticksTheChildWillReportToParent = result.totalParent;
            if (ticksTheChildWillReportToParent > 0) {
                if (oldUsedForParent > 0 || this.usedForParent < this.totalParent) {
                    this.root.checkForCancellation();
                }
            } else {
                this.root.reportTrivialOperation(1);
            }
        }
        return result;
    }

    private void cleanupActiveChild() {
        SubMonitor child = this.lastSubMonitor;
        if (child == null) {
            return;
        }
        this.lastSubMonitor = null;
        child.done();
    }

    @Override
    public void clearBlocked() {
        this.root.clearBlocked();
    }

    @Override
    public void setBlocked(IStatus reason) {
        this.root.setBlocked(reason);
    }

    protected static boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private static String getCallerName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String ourClassName = SubMonitor.class.getCanonicalName();
        int idx = 1;
        while (idx < stackTrace.length) {
            String className = stackTrace[idx].getClassName();
            if (!className.equals(ourClassName)) {
                return stackTrace[idx].toString();
            }
            ++idx;
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logProblem(String message) {
        String caller = SubMonitor.getCallerName();
        Set<String> set = knownBuggyMethods;
        synchronized (set) {
            if (!knownBuggyMethods.add(caller)) {
                return;
            }
        }
        RuntimeLog.log(new Status(2, "org.eclipse.core.runtime", message, new Throwable()));
    }

    private static final class RootInfo {
        final IProgressMonitor root;
        String taskName;
        String subTask;
        int cancellationCheckCounter;

        public RootInfo(IProgressMonitor root) {
            this.root = root;
        }

        public boolean isCanceled() {
            return this.root.isCanceled();
        }

        public void setCanceled(boolean value) {
            this.root.setCanceled(value);
        }

        public void setTaskName(String taskName) {
            if (SubMonitor.eq(taskName, this.taskName)) {
                return;
            }
            this.taskName = taskName;
            this.root.setTaskName(taskName);
        }

        public void subTask(String name) {
            if (SubMonitor.eq(this.subTask, name)) {
                return;
            }
            this.subTask = name;
            this.root.subTask(name);
        }

        public void worked(int i) {
            this.root.worked(i);
        }

        public void clearBlocked() {
            if (this.root instanceof IProgressMonitorWithBlocking) {
                ((IProgressMonitorWithBlocking)this.root).clearBlocked();
            }
        }

        public void setBlocked(IStatus reason) {
            if (this.root instanceof IProgressMonitorWithBlocking) {
                ((IProgressMonitorWithBlocking)this.root).setBlocked(reason);
            }
        }

        public void checkForCancellation() {
            if (this.root.isCanceled()) {
                throw new OperationCanceledException();
            }
        }

        public void reportTrivialOperation(int cancellationDelta) {
            this.cancellationCheckCounter += cancellationDelta;
            if (this.cancellationCheckCounter >= 20) {
                this.cancellationCheckCounter = 0;
                this.checkForCancellation();
            }
        }
    }
}

