/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.team;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ResourceRuleFactory
implements IResourceRuleFactory {
    private final IWorkspace workspace = ResourcesPlugin.getWorkspace();

    protected ResourceRuleFactory() {
    }

    @Override
    public final ISchedulingRule buildRule() {
        return this.workspace.getRoot();
    }

    @Override
    public final ISchedulingRule derivedRule(IResource resource) {
        return null;
    }

    @Override
    public ISchedulingRule copyRule(IResource source, IResource destination) {
        return this.parent(destination);
    }

    @Override
    public ISchedulingRule createRule(IResource resource) {
        return this.parent(resource);
    }

    @Override
    public ISchedulingRule deleteRule(IResource resource) {
        return this.parent(resource);
    }

    @Override
    public final ISchedulingRule markerRule(IResource resource) {
        return null;
    }

    @Override
    public ISchedulingRule modifyRule(IResource resource) {
        IPath path = resource.getFullPath();
        if (path.segmentCount() == 2 && path.segment(1).equals(".project")) {
            return this.parent(resource);
        }
        return resource;
    }

    protected final ISchedulingRule parent(IResource resource) {
        switch (resource.getType()) {
            case 4: 
            case 8: {
                return resource;
            }
        }
        return resource.getParent();
    }

    @Override
    public ISchedulingRule refreshRule(IResource resource) {
        return this.parent(resource);
    }
}

