/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class PlatformURLPluginConnection
extends PlatformURLConnection {
    private static boolean isRegistered = false;

    @Override
    protected boolean allowCaching() {
        return true;
    }

    public static Object[] parse(String spec, URL originalURL) throws IOException {
        Object[] result = new Object[2];
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith("plugin")) {
            throw new IOException(NLS.bind(CommonMessages.url_badVariant, originalURL));
        }
        int ix = spec.indexOf("/", "plugin".length() + 1);
        String ref = ix == -1 ? spec.substring("plugin".length() + 1) : spec.substring("plugin".length() + 1, ix);
        String id = PlatformURLPluginConnection.getId(ref);
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw new IOException(CommonMessages.activator_not_available);
        }
        Bundle bundle = activator.getBundle(id);
        if (bundle == null) {
            throw new IOException(NLS.bind(CommonMessages.url_resolvePlugin, id));
        }
        result[0] = bundle;
        result[1] = ix == -1 || ix + 1 >= spec.length() ? "/" : spec.substring(ix + 1);
        return result;
    }

    @Override
    protected URL resolve() throws IOException {
        String path;
        String spec = this.url.getFile().trim();
        Object[] obj = PlatformURLPluginConnection.parse(spec, this.url);
        Bundle b = (Bundle)obj[0];
        URL result = b.getEntry(path = (String)obj[1]);
        if (result != null || "/".equals(path)) {
            return result;
        }
        result = b.getResource(path);
        if (result != null) {
            return result;
        }
        return new URL(b.getEntry("/"), path);
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        PlatformURLHandler.register("plugin", PlatformURLPluginConnection.class);
        isRegistered = true;
    }
}

