/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class PlatformURLFragmentConnection
extends PlatformURLConnection {
    private Bundle target;
    private static boolean isRegistered = false;

    @Override
    protected boolean allowCaching() {
        return true;
    }

    @Override
    protected URL resolve() throws IOException {
        String spec = this.url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith("fragment")) {
            throw new IOException(NLS.bind(CommonMessages.url_badVariant, this.url));
        }
        int ix = spec.indexOf("/", "fragment".length() + 1);
        String ref = ix == -1 ? spec.substring("fragment".length() + 1) : spec.substring("fragment".length() + 1, ix);
        String id = PlatformURLFragmentConnection.getId(ref);
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw new IOException(CommonMessages.activator_not_available);
        }
        this.target = activator.getBundle(id);
        if (this.target == null) {
            throw new IOException(NLS.bind(CommonMessages.url_resolveFragment, this.url));
        }
        URL result = this.target.getEntry("/");
        if (ix == -1 || ix + 1 >= spec.length()) {
            return result;
        }
        return new URL(result, spec.substring(ix + 1));
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        PlatformURLHandler.register("fragment", PlatformURLFragmentConnection.class);
        isRegistered = true;
    }
}

