/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.internal.boot.PlatformURLBaseConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.internal.runtime.PlatformURLConfigConnection;
import org.eclipse.core.internal.runtime.PlatformURLConverter;
import org.eclipse.core.internal.runtime.PlatformURLFragmentConnection;
import org.eclipse.core.internal.runtime.PlatformURLMetaConnection;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.internal.runtime.TracingOptions;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Map<String, ServiceTracker<Object, URLConverter>> urlTrackers = new HashMap<String, ServiceTracker<Object, URLConverter>>();
    private static BundleContext bundleContext;
    private static Activator singleton;
    private ServiceRegistration<URLConverter> platformURLConverterService;
    private ServiceRegistration<IAdapterManager> adapterManagerService;
    private ServiceTracker<Object, Location> installLocationTracker;
    private ServiceTracker<Object, Location> instanceLocationTracker;
    private ServiceTracker<Object, Location> configLocationTracker;
    private ServiceTracker<Object, PackageAdmin> bundleTracker;
    private ServiceTracker<Object, DebugOptions> debugTracker;
    private ServiceTracker<Object, FrameworkLog> logTracker;
    private ServiceTracker<Object, BundleLocalization> localizationTracker;
    private ServiceRegistration<DebugOptionsListener> debugRegistration;

    public static Activator getDefault() {
        return singleton;
    }

    @Override
    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        singleton = this;
        this.installLocationTracker = this.openServiceTracker(Location.INSTALL_FILTER);
        this.instanceLocationTracker = this.openServiceTracker(Location.INSTANCE_FILTER);
        this.configLocationTracker = this.openServiceTracker(Location.CONFIGURATION_FILTER);
        this.bundleTracker = this.openServiceTracker(PackageAdmin.class);
        this.debugTracker = this.openServiceTracker(DebugOptions.class);
        this.logTracker = this.openServiceTracker(FrameworkLog.class);
        this.localizationTracker = this.openServiceTracker(BundleLocalization.class);
        RuntimeLog.setLogWriter(this.getPlatformWriter(context));
        Hashtable<String, String> urlProperties = new Hashtable<String, String>();
        ((Dictionary)urlProperties).put("protocol", "platform");
        this.platformURLConverterService = context.registerService(URLConverter.class, new PlatformURLConverter(), urlProperties);
        this.adapterManagerService = context.registerService(IAdapterManager.class, AdapterManager.getDefault(), null);
        this.installPlatformURLSupport();
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", "org.eclipse.equinox.common");
        this.debugRegistration = context.registerService(DebugOptionsListener.class, TracingOptions.DEBUG_OPTIONS_LISTENER, properties);
    }

    private PlatformLogWriter getPlatformWriter(BundleContext context) {
        ServiceReference<ExtendedLogService> logRef = context.getServiceReference(ExtendedLogService.class);
        ServiceReference<ExtendedLogReaderService> readerRef = context.getServiceReference(ExtendedLogReaderService.class);
        ServiceReference<PackageAdmin> packageAdminRef = context.getServiceReference(PackageAdmin.class);
        if (logRef == null || readerRef == null || packageAdminRef == null) {
            return null;
        }
        ExtendedLogService logService = context.getService(logRef);
        ExtendedLogReaderService readerService = context.getService(readerRef);
        PackageAdmin packageAdmin = context.getService(packageAdminRef);
        if (logService == null || readerService == null || packageAdmin == null) {
            return null;
        }
        PlatformLogWriter writer = new PlatformLogWriter(logService, packageAdmin, context.getBundle());
        readerService.addLogListener(writer, writer);
        return writer;
    }

    public Location getConfigurationLocation() {
        return this.configLocationTracker.getService();
    }

    public DebugOptions getDebugOptions() {
        return this.debugTracker.getService();
    }

    public FrameworkLog getFrameworkLog() {
        return this.logTracker.getService();
    }

    public Location getInstanceLocation() {
        return this.instanceLocationTracker.getService();
    }

    public Bundle getBundle(String symbolicName) {
        PackageAdmin admin = this.getBundleAdmin();
        if (admin == null) {
            return null;
        }
        Bundle[] bundles = admin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    private PackageAdmin getBundleAdmin() {
        return this.bundleTracker.getService();
    }

    public Bundle[] getFragments(Bundle host) {
        PackageAdmin admin = this.getBundleAdmin();
        if (admin == null) {
            return new Bundle[0];
        }
        return admin.getFragments(host);
    }

    public Location getInstallLocation() {
        return this.installLocationTracker.getService();
    }

    private <T> ServiceTracker<Object, T> openServiceTracker(String filterString) throws InvalidSyntaxException {
        Filter filter = bundleContext.createFilter(filterString);
        ServiceTracker tracker = new ServiceTracker(bundleContext, filter, null);
        tracker.open();
        return tracker;
    }

    private <T> ServiceTracker<Object, T> openServiceTracker(Class<?> clazz) {
        ServiceTracker tracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        tracker.open();
        return tracker;
    }

    public String getBundleId(Object object) {
        if (object == null) {
            return null;
        }
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle source = packageAdmin.getBundle(object.getClass());
        if (source != null && source.getSymbolicName() != null) {
            return source.getSymbolicName();
        }
        return null;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        Activator.closeURLTrackerServices();
        if (this.platformURLConverterService != null) {
            this.platformURLConverterService.unregister();
            this.platformURLConverterService = null;
        }
        if (this.adapterManagerService != null) {
            this.adapterManagerService.unregister();
            this.adapterManagerService = null;
        }
        if (this.installLocationTracker != null) {
            this.installLocationTracker.close();
        }
        if (this.configLocationTracker != null) {
            this.configLocationTracker.close();
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
        }
        if (this.logTracker != null) {
            this.logTracker.close();
        }
        if (this.instanceLocationTracker != null) {
            this.instanceLocationTracker.close();
        }
        if (this.localizationTracker != null) {
            this.localizationTracker.close();
        }
        if (this.debugRegistration != null) {
            this.debugRegistration.unregister();
            this.debugRegistration = null;
        }
        RuntimeLog.setLogWriter(null);
        bundleContext = null;
        singleton = null;
    }

    static BundleContext getContext() {
        return bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeURLTrackerServices() {
        Map<String, ServiceTracker<Object, URLConverter>> map = urlTrackers;
        synchronized (map) {
            if (!urlTrackers.isEmpty()) {
                for (ServiceTracker<Object, URLConverter> tracker : urlTrackers.values()) {
                    tracker.close();
                }
                urlTrackers = new HashMap<String, ServiceTracker<Object, URLConverter>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URLConverter getURLConverter(URL url) {
        BundleContext ctx = Activator.getContext();
        if (url == null || ctx == null) {
            return null;
        }
        String protocol = url.getProtocol();
        Map<String, ServiceTracker<Object, URLConverter>> map = urlTrackers;
        synchronized (map) {
            ServiceTracker<Object, URLConverter> tracker = urlTrackers.get(protocol);
            if (tracker == null) {
                String FILTER_PREFIX = "(&(objectClass=" + URLConverter.class.getName() + ")(protocol=";
                String FILTER_POSTFIX = "))";
                Filter filter = null;
                try {
                    filter = ctx.createFilter(String.valueOf(FILTER_PREFIX) + protocol + FILTER_POSTFIX);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    return null;
                }
                tracker = new ServiceTracker(Activator.getContext(), filter, null);
                tracker.open();
                urlTrackers.put(protocol, tracker);
            }
            return tracker.getService();
        }
    }

    private void installPlatformURLSupport() {
        PlatformURLPluginConnection.startup();
        PlatformURLFragmentConnection.startup();
        PlatformURLMetaConnection.startup();
        PlatformURLConfigConnection.startup();
        Location service = this.getInstallLocation();
        if (service != null) {
            PlatformURLBaseConnection.startup(service.getURL());
        }
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>(1);
        properties.put("url.handler.protocol", new String[]{"platform"});
        Activator.getContext().registerService(URLStreamHandlerService.class.getName(), (Object)new PlatformURLHandler(), properties);
    }
}

