/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class WorkspaceRoot
extends Container
implements IWorkspaceRoot {
    private final Map<String, Project> projectTable = Collections.synchronizedMap(new HashMap(16));
    private final IPath workspaceLocation;

    protected WorkspaceRoot(IPath path, Workspace container) {
        super(path, container);
        Assert.isTrue(path.equals(Path.ROOT));
        this.workspaceLocation = FileUtil.canonicalPath(Platform.getLocation());
        Assert.isNotNull(this.workspaceLocation);
    }

    @Override
    public void delete(boolean deleteContent, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags |= deleteContent ? 4 : 8, monitor);
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags, monitor);
    }

    @Override
    public boolean exists(int flags, boolean checkType) {
        return true;
    }

    @Override
    public String getDefaultCharset(boolean checkImplicit) {
        if (checkImplicit) {
            return ResourcesPlugin.getEncoding();
        }
        String enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
        return enc == null || enc.length() == 0 ? null : enc;
    }

    @Override
    public IPath getLocation() {
        return this.workspaceLocation;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public IContainer getParent() {
        return null;
    }

    @Override
    public IProject getProject() {
        return null;
    }

    @Override
    public IProject getProject(String name) {
        Project result = this.projectTable.get(name);
        if (result == null) {
            IPath projectPath = new Path(null, name).makeAbsolute();
            String message = "Path for project must have only one segment.";
            Assert.isLegal(projectPath.segmentCount() == 1, message);
            String canonicalName = projectPath.lastSegment();
            result = this.projectTable.get(canonicalName);
            if (result != null) {
                return result;
            }
            result = new Project(projectPath, this.workspace);
            this.projectTable.put(canonicalName, result);
        }
        return result;
    }

    @Override
    public IPath getProjectRelativePath() {
        return Path.EMPTY;
    }

    @Override
    public IProject[] getProjects() {
        return this.getProjects(0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IProject[] getProjects(int memberFlags) {
        block4: {
            roots = this.getChildren(memberFlags);
            result = new IProject[roots.length];
            try {
                System.arraycopy(roots, 0, result, 0, roots.length);
                break block4;
            }
            catch (ArrayStoreException ex) {
                var8_5 = roots;
                var7_6 = roots.length;
                var6_7 = 0;
                ** while (var6_7 < var7_6)
            }
lbl-1000:
            // 1 sources

            {
                root2 = var8_5[var6_7];
                if (root2.getType() != 4) {
                    Policy.log(4, NLS.bind("{0} is an invalid child of the workspace root.", root2), null);
                }
                ++var6_7;
                continue;
            }
lbl16:
            // 1 sources

            throw ex;
        }
        return result;
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public void internalSetLocal(boolean flag, int depth) throws CoreException {
        IResource[] children;
        if (depth == 0) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] iResourceArray = children = this.getChildren(0);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            ((Resource)element).internalSetLocal(flag, depth);
            ++n2;
        }
    }

    @Override
    public boolean isDerived(int options) {
        return false;
    }

    @Override
    public boolean isLinked(int options) {
        return false;
    }

    @Override
    @Deprecated
    public boolean isLocal(int depth) {
        return this.isLocal(-1, depth);
    }

    @Override
    @Deprecated
    public boolean isLocal(int flags, int depth) {
        if (depth == 0) {
            return true;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = this.getChildren(0);
        int i = 0;
        while (i < children.length) {
            if (!children[i].isLocal(depth)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isPhantom() {
        return false;
    }

    @Override
    public void touch(IProgressMonitor monitor) {
    }
}

