/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.NotificationManager;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.properties.PropertyManager2;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.AliasManager;
import org.eclipse.core.internal.resources.CharsetManager;
import org.eclipse.core.internal.resources.ComputeProjectOrder;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.ContentDescriptionManager;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.FilterTypeManager;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.LocalMetaArea;
import org.eclipse.core.internal.resources.LocationValidator;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.MoveDeleteHook;
import org.eclipse.core.internal.resources.NatureManager;
import org.eclipse.core.internal.resources.PathVariableManager;
import org.eclipse.core.internal.resources.PathVariableUtil;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.RootInfo;
import org.eclipse.core.internal.resources.Rules;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.WorkspacePreferences;
import org.eclipse.core.internal.resources.WorkspaceRoot;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.StringPoolJob;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.TeamHook;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class Workspace
extends PlatformObject
implements ICoreConstants,
IWorkspace {
    public static final boolean caseSensitive = "macosx".equals(Platform.getOS()) ? false : new java.io.File("a").compareTo(new java.io.File("A")) != 0;
    protected WorkManager _workManager;
    protected AliasManager aliasManager;
    protected BuildManager buildManager;
    protected volatile IBuildConfiguration[] buildOrder = null;
    protected volatile ComputeProjectOrder.Digraph<IBuildConfiguration> buildOrderGraph;
    protected CharsetManager charsetManager;
    protected ContentDescriptionManager contentDescriptionManager;
    protected boolean crashed = false;
    protected final IWorkspaceRoot defaultRoot = new WorkspaceRoot(Path.ROOT, this);
    protected WorkspacePreferences description;
    protected FileSystemResourceManager fileSystemManager;
    protected final CopyOnWriteArrayList<ILifecycleListener> lifecycleListeners = new CopyOnWriteArrayList();
    protected LocalMetaArea localMetaArea;
    protected final LocationValidator locationValidator = new LocationValidator(this);
    protected MarkerManager markerManager;
    protected IMoveDeleteHook moveDeleteHook = null;
    protected NatureManager natureManager;
    protected FilterTypeManager filterManager;
    protected long nextMarkerId = 0L;
    protected long nextNodeId = 1L;
    protected NotificationManager notificationManager;
    protected boolean openFlag = false;
    protected ElementTree operationTree;
    protected PathVariableManager pathVariableManager;
    protected IPropertyManager propertyManager;
    protected RefreshManager refreshManager;
    private IResourceRuleFactory ruleFactory;
    protected SaveManager saveManager;
    protected boolean shouldValidate = true;
    private StringPoolJob stringPoolJob;
    protected Synchronizer synchronizer;
    protected TeamHook teamHook = null;
    protected volatile ElementTree tree;
    protected volatile Thread treeLocked = null;
    protected IFileModificationValidator validator = null;

    public static boolean clear(java.io.File root) {
        IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(root);
        try {
            fileStore.delete(0, new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    public static WorkspaceDescription defaultWorkspaceDescription() {
        return new WorkspaceDescription("Workspace");
    }

    public Workspace() {
        this.localMetaArea = new LocalMetaArea();
        this.tree = new ElementTree();
        this.tree.immutable();
        this.treeLocked = Thread.currentThread();
        this.tree.setTreeData(this.newElement(8));
    }

    public void addLifecycleListener(ILifecycleListener listener) {
        this.lifecycleListeners.addIfAbsent(listener);
    }

    @Override
    public void addResourceChangeListener(IResourceChangeListener listener) {
        this.notificationManager.addListener(listener, 7);
    }

    @Override
    public void addResourceChangeListener(IResourceChangeListener listener, int eventMask) {
        this.notificationManager.addListener(listener, eventMask);
    }

    @Override
    public ISavedState addSaveParticipant(String pluginId, ISaveParticipant participant) throws CoreException {
        Assert.isNotNull(pluginId, "Plugin id must not be null");
        Assert.isNotNull(participant, "Participant must not be null");
        return this.saveManager.addParticipant(pluginId, participant);
    }

    public void beginOperation(boolean createNewTree) throws CoreException {
        WorkManager workManager = this.getWorkManager();
        workManager.incrementNestedOperations();
        if (!workManager.isBalanced()) {
            Assert.isTrue(false, "Operation was not prepared.");
        }
        if (workManager.getPreparedOperationDepth() > 1) {
            if (createNewTree && this.tree.isImmutable()) {
                this.newWorkingTree();
            }
            return;
        }
        this.operationTree = this.tree;
        if (createNewTree && this.tree.isImmutable()) {
            this.newWorkingTree();
        }
    }

    public void broadcastBuildEvent(Object source, int type, int buildTrigger) {
        ResourceChangeEvent event = new ResourceChangeEvent(source, type, buildTrigger, null);
        this.notificationManager.broadcastChanges(this.tree, event, false);
    }

    protected void broadcastEvent(LifecycleEvent event) throws CoreException {
        for (ILifecycleListener listener : this.lifecycleListeners) {
            listener.handleEvent(event);
        }
    }

    public void broadcastPostChange() {
        ResourceChangeEvent event = new ResourceChangeEvent(this, 1, 0, null);
        this.notificationManager.broadcastChanges(this.tree, event, true);
    }

    private boolean canCreateExtensions() {
        return Platform.getBundle("org.eclipse.osgi").getState() != 16;
    }

    public void close(IProgressMonitor monitor) throws CoreException {
        if (!this.isOpen()) {
            return;
        }
        try {
            String msg = Messages.resources_closing_0;
            SubMonitor subMonitor = SubMonitor.convert(monitor, msg, 20);
            subMonitor.subTask(msg);
            try {
                this.stringPoolJob.cancel();
                this.saveManager.shutdown(null);
                this.saveManager.reportSnapshotRequestor();
                this.prepareOperation(this.getRoot(), subMonitor.newChild(1));
                this.notificationManager.shutdown(null);
                this.beginOperation(true);
                IProject[] projects = this.getRoot().getProjects(8);
                subMonitor.setWorkRemaining(projects.length + 2);
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    this.broadcastEvent(LifecycleEvent.newEvent(1, project));
                    subMonitor.worked(1);
                    ++n2;
                }
                this.deleteResource(this.getRoot());
                this.openFlag = false;
            }
            finally {
                this.shutdown(subMonitor.newChild(2, 1));
            }
        }
        finally {
            Job.getJobManager().endRule(this.getRoot());
        }
    }

    private ComputeProjectOrder.VertexOrder<IBuildConfiguration> computeActiveBuildConfigOrder() {
        ComputeProjectOrder.Digraph<IBuildConfiguration> activeBuildConfigurationGraph = this.computeActiveBuildConfigGraph();
        return ComputeProjectOrder.computeVertexOrder(activeBuildConfigurationGraph, IBuildConfiguration.class);
    }

    private ComputeProjectOrder.Digraph<IBuildConfiguration> computeActiveBuildConfigGraph() {
        TreeSet<IBuildConfiguration> allAccessibleBuildConfigs = new TreeSet<IBuildConfiguration>(new BuildConfigurationComparator());
        IProject[] allProjects = this.getRoot().getProjects(8);
        ArrayList<T[]> edges = new ArrayList<T[]>(allProjects.length);
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject allProject = iProjectArray[n2];
            Project project = (Project)allProject;
            if (project.isAccessible() && !allAccessibleBuildConfigs.contains(project.internalGetActiveBuildConfig())) {
                allAccessibleBuildConfigs.add(project.internalGetActiveBuildConfig());
                Stack<IBuildConfiguration> stack = new Stack<IBuildConfiguration>();
                stack.push(project.internalGetActiveBuildConfig());
                while (!stack.isEmpty()) {
                    IBuildConfiguration[] refs;
                    IBuildConfiguration buildConfiguration = (IBuildConfiguration)stack.pop();
                    Project subProject = (Project)buildConfiguration.getProject();
                    IBuildConfiguration[] iBuildConfigurationArray = refs = subProject.internalGetReferencedBuildConfigs(buildConfiguration.getName(), false);
                    int n3 = refs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IBuildConfiguration ref = iBuildConfigurationArray[n4];
                        if (!ref.equals(buildConfiguration)) {
                            edges.add(new IBuildConfiguration[]{buildConfiguration, ref});
                            if (!allAccessibleBuildConfigs.contains(ref)) {
                                allAccessibleBuildConfigs.add(ref);
                                stack.push(ref);
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return ComputeProjectOrder.computeGraph(allAccessibleBuildConfigs, edges, IBuildConfiguration.class);
    }

    private static ProjectBuildConfigOrder vertexOrderToProjectBuildConfigOrder(ComputeProjectOrder.VertexOrder<IBuildConfiguration> order) {
        IBuildConfiguration[] buildConfigs = new IBuildConfiguration[((IBuildConfiguration[])order.vertexes).length];
        System.arraycopy(order.vertexes, 0, buildConfigs, 0, ((IBuildConfiguration[])order.vertexes).length);
        IBuildConfiguration[][] knots = new IBuildConfiguration[((IBuildConfiguration[][])order.knots).length][];
        int i = 0;
        while (i < ((IBuildConfiguration[][])order.knots).length) {
            knots[i] = new IBuildConfiguration[((IBuildConfiguration[][])order.knots)[i].length];
            System.arraycopy(((IBuildConfiguration[][])order.knots)[i], 0, knots[i], 0, ((IBuildConfiguration[][])order.knots)[i].length);
            ++i;
        }
        return new ProjectBuildConfigOrder(buildConfigs, order.hasCycles, knots);
    }

    protected void copyTree(IResource source, IPath destination, int depth, int updateFlags, boolean keepSyncInfo) throws CoreException {
        this.copyTree(source, destination, depth, updateFlags, keepSyncInfo, false, source.getType() == 4);
    }

    private void copyTree(IResource source, IPath destination, int depth, int updateFlags, boolean keepSyncInfo, boolean moveResources, boolean movingProject) throws CoreException {
        IResource[] children;
        IResource dotProject;
        boolean projectCopy;
        int destinationType;
        IResource destinationResource = this.getRoot().findMember(destination, true);
        if (destinationResource == null) {
            destinationType = source.getType() == 1 ? 1 : (destination.segmentCount() == 1 ? 4 : 2);
            destinationResource = this.newResource(destination, destinationType);
        } else {
            destinationType = destinationResource.getType();
        }
        ResourceInfo sourceInfo = ((Resource)source).getResourceInfo(true, false);
        if (destinationType != source.getType()) {
            sourceInfo = (ResourceInfo)sourceInfo.clone();
            sourceInfo.setType(destinationType);
        }
        ResourceInfo newInfo = this.createResource(destinationResource, sourceInfo, false, true, keepSyncInfo);
        newInfo.setNodeId(sourceInfo.getNodeId());
        newInfo.setFlags(newInfo.getFlags() | sourceInfo.getFlags() & 2);
        newInfo.setFileStoreRoot(null);
        newInfo.clear(393216);
        if (source.isLinked()) {
            LinkDescription linkDescription;
            URI sourceLocationURI = this.transferVariableDefinition(source, destinationResource, source.getLocationURI());
            if ((updateFlags & 0x20) != 0 || ((Resource)source).isUnderVirtual()) {
                newInfo.set(65536);
                linkDescription = new LinkDescription(destinationResource, sourceLocationURI);
            } else {
                newInfo.clear(65536);
                linkDescription = null;
            }
            if (moveResources && !movingProject && ((Project)source.getProject()).internalGetDescription().setLinkLocation(source.getProjectRelativePath(), null)) {
                ((Project)source.getProject()).writeDescription(updateFlags);
            }
            Project project = (Project)destinationResource.getProject();
            project.internalGetDescription().setLinkLocation(destinationResource.getProjectRelativePath(), linkDescription);
            project.writeDescription(updateFlags);
            newInfo.setFileStoreRoot(null);
        }
        if (source.getProject().exists() && source instanceof Container && ((Container)source).hasFilters()) {
            Project sourceProject = (Project)source.getProject();
            LinkedList<FilterDescription> originalDescriptions = sourceProject.internalGetDescription().getFilter(source.getProjectRelativePath());
            LinkedList<FilterDescription> filterDescriptions = FilterDescription.copy(originalDescriptions, destinationResource);
            if (moveResources && !movingProject && ((Project)source.getProject()).internalGetDescription().setFilters(source.getProjectRelativePath(), null)) {
                ((Project)source.getProject()).writeDescription(updateFlags);
            }
            Project project = (Project)destinationResource.getProject();
            project.internalGetDescription().setFilters(destinationResource.getProjectRelativePath(), filterDescriptions);
            project.writeDescription(updateFlags);
        }
        if (depth == 0 || source.getType() == 1) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        boolean bl = projectCopy = source.getType() == 4 && destinationType == 4;
        if (projectCopy && (dotProject = ((Project)source).findMember(".project")) != null) {
            this.copyTree(dotProject, destination.append(dotProject.getName()), depth, updateFlags, keepSyncInfo, moveResources, movingProject);
        }
        IResource[] iResourceArray = children = ((IContainer)source).members(10);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            String childName = element.getName();
            if (!projectCopy || !childName.equals(".project")) {
                IPath childPath = destination.append(childName);
                this.copyTree(element, childPath, depth, updateFlags, keepSyncInfo, moveResources, movingProject);
            }
            ++n2;
        }
    }

    public URI transferVariableDefinition(IResource source, IResource dest, URI sourceURI) throws CoreException {
        IPath srcLoc = source.getLocation();
        IPath srcRawLoc = source.getRawLocation();
        if (srcLoc != null && srcRawLoc != null && !srcLoc.equals(srcRawLoc)) {
            if (!source.getProject().equals(dest.getProject())) {
                String variable = srcRawLoc.segment(0);
                variable = this.copyVariable(source, dest, variable);
                IPath newLocation = Path.fromPortableString(variable).append(srcRawLoc.removeFirstSegments(1));
                sourceURI = this.toURI(newLocation);
            } else {
                sourceURI = this.toURI(srcRawLoc);
            }
        }
        return sourceURI;
    }

    URI toURI(IPath path) {
        if (path.isAbsolute()) {
            return URIUtil.toURI(path);
        }
        try {
            return new URI(null, null, path.toPortableString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return URIUtil.toURI(path);
        }
    }

    String copyVariable(IResource source, IResource dest, String variable) throws CoreException {
        IPath relativeSrcValue;
        String[] variables;
        IPathVariableManager destPathVariableManager = dest.getPathVariableManager();
        IPathVariableManager srcPathVariableManager = source.getPathVariableManager();
        IPath srcValue = URIUtil.toPath(srcPathVariableManager.getURIValue(variable));
        if (srcValue == null) {
            return PathVariableUtil.getUniqueVariableName(variable, dest);
        }
        IPath resolvedSrcValue = URIUtil.toPath(srcPathVariableManager.resolveURI(URIUtil.toURI(srcValue)));
        boolean variableExisted = false;
        if (destPathVariableManager.isDefined(variable)) {
            variableExisted = true;
            IPath destValue = URIUtil.toPath(destPathVariableManager.getURIValue(variable));
            if (destValue != null && URIUtil.toPath(destPathVariableManager.resolveURI(URIUtil.toURI(destValue))).equals(resolvedSrcValue)) {
                return variable;
            }
        }
        String[] stringArray = variables = destPathVariableManager.getPathVariableNames();
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IPath resolveDestVariable;
            String other = stringArray[n2];
            if (PathVariableUtil.isPreferred(other) && (resolveDestVariable = URIUtil.toPath(destPathVariableManager.resolveURI(destPathVariableManager.getURIValue(other)))) != null && resolveDestVariable.equals(resolvedSrcValue)) {
                return other;
            }
            ++n2;
        }
        String destVariable = PathVariableUtil.getUniqueVariableName(variable, dest);
        boolean shouldConvertToRelative = true;
        if (!srcValue.equals(resolvedSrcValue) && !variableExisted) {
            String[] referencedVariables = PathVariableUtil.splitVariableNames(srcValue.toPortableString());
            shouldConvertToRelative = false;
            if (referencedVariables.length == 1 && PathVariableUtil.isParentVariable(referencedVariables[0])) {
                shouldConvertToRelative = true;
            }
            if (!shouldConvertToRelative) {
                String[] segments = PathVariableUtil.splitVariablesAndContent(srcValue.toPortableString());
                StringBuilder result = new StringBuilder();
                String[] stringArray2 = segments;
                int n3 = segments.length;
                int n4 = 0;
                while (n4 < n3) {
                    String segment = stringArray2[n4];
                    String var = PathVariableUtil.extractVariable(segment);
                    if (var.length() > 0) {
                        String copiedVariable = this.copyVariable(source, dest, var);
                        int index = segment.indexOf(var);
                        if (index != -1) {
                            result.append(segment.substring(0, index));
                            result.append(copiedVariable);
                            int start = index + var.length();
                            int end = segment.length();
                            result.append(segment.substring(start, end));
                        }
                    } else {
                        result.append(segment);
                    }
                    ++n4;
                }
                srcValue = Path.fromPortableString(result.toString());
            }
        }
        if (shouldConvertToRelative && (relativeSrcValue = PathVariableUtil.convertToPathRelativeMacro(destPathVariableManager, resolvedSrcValue, dest, true, null)) != null) {
            srcValue = relativeSrcValue;
        }
        destPathVariableManager.setURIValue(destVariable, URIUtil.toURI(srcValue));
        return destVariable;
    }

    public int countResources(IPath root, int depth, boolean phantom) {
        if (!this.tree.includes(root)) {
            return 0;
        }
        switch (depth) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1 + this.tree.getChildCount(root);
            }
            case 2: {
                int[] count = new int[1];
                IElementContentVisitor visitor = (aTree, requestor, elementContents) -> {
                    if (phantom || !((ResourceInfo)elementContents).isSet(8)) {
                        nArray[0] = count[0] + 1;
                    }
                    return true;
                };
                new ElementTreeIterator(this.tree, root).iterate(visitor);
                return count[0];
            }
        }
        return 0;
    }

    public ResourceInfo createResource(IResource resource, boolean phantom) throws CoreException {
        return this.createResource(resource, null, phantom, false, false);
    }

    public ResourceInfo createResource(IResource resource, int updateFlags) throws CoreException {
        ResourceInfo info = this.createResource(resource, null, false, false, false);
        if ((updateFlags & 0x400) != 0) {
            info.set(16384);
        }
        if ((updateFlags & 0x800) != 0) {
            info.set(32768);
        }
        if ((updateFlags & 0x1000) != 0) {
            info.set(0x200000);
        }
        return info;
    }

    public ResourceInfo createResource(IResource resource, ResourceInfo info, boolean phantom, boolean overwrite, boolean keepSyncInfo) throws CoreException {
        info = info == null ? this.newElement(resource.getType()) : (ResourceInfo)info.clone();
        ResourceInfo original = this.getResourceInfo(resource.getFullPath(), true, false);
        if (phantom) {
            info.set(8);
            info.clearModificationStamp();
        }
        if (original == null) {
            if (!keepSyncInfo) {
                info.setSyncInfo(null);
            }
            this.tree.createElement(resource.getFullPath(), info);
        } else if (overwrite || !phantom && original.isSet(8)) {
            if (!keepSyncInfo) {
                info.setSyncInfo(original.getSyncInfo(true));
            }
            info.set(4096);
            this.tree.setElementData(resource.getFullPath(), info);
        } else {
            String message = NLS.bind(Messages.resources_mustNotExist, resource.getFullPath());
            throw new ResourceException(367, resource.getFullPath(), message, null);
        }
        return info;
    }

    void deleteResource(IResource resource) {
        IPath path = resource.getFullPath();
        if (path.equals(Path.ROOT)) {
            IProject[] children;
            IProject[] iProjectArray = children = this.getRoot().getProjects(8);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IProject element = iProjectArray[n2];
                this.tree.deleteElement(element.getFullPath());
                ++n2;
            }
        } else {
            this.tree.deleteElement(path);
        }
    }

    public void endOperation(ISchedulingRule rule, boolean build) throws CoreException {
        WorkManager workManager = this.getWorkManager();
        if (workManager.checkInFailed(rule)) {
            return;
        }
        boolean hasTreeChanges = false;
        boolean depthOne = false;
        try {
            workManager.setBuild(build);
            boolean bl = depthOne = workManager.getPreparedOperationDepth() == 1;
            if (!this.notificationManager.shouldNotify() && !depthOne) {
                this.notificationManager.requestNotify();
                return;
            }
            try {
                this.notificationManager.beginNotify();
                Assert.isTrue(workManager.getPreparedOperationDepth() > 0, "Mismatched begin/endOperation");
                workManager.rebalanceNestedOperations();
                hasTreeChanges = workManager.shouldBuild();
                if (hasTreeChanges) {
                    hasTreeChanges = this.operationTree != null && ElementTree.hasChanges(this.tree, this.operationTree, ResourceComparator.getBuildComparator(), true);
                }
                this.broadcastPostChange();
                this.saveManager.snapshotIfNeeded(hasTreeChanges);
            }
            finally {
                if (depthOne) {
                    this.tree.immutable();
                    this.operationTree = null;
                } else {
                    this.newWorkingTree();
                }
            }
        }
        finally {
            workManager.checkOut(rule);
        }
        if (depthOne) {
            this.buildManager.endTopLevel(hasTreeChanges);
        }
    }

    protected void flushBuildOrder() {
        this.buildOrder = null;
        this.buildOrderGraph = null;
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    public BuildManager getBuildManager() {
        return this.buildManager;
    }

    public IBuildConfiguration[] getBuildOrder() {
        if (this.buildOrder != null) {
            return this.buildOrder;
        }
        String[] order = this.description.getBuildOrder(false);
        if (order != null) {
            LinkedHashSet<IBuildConfiguration> configs = new LinkedHashSet<IBuildConfiguration>();
            String[] stringArray = order;
            int n = order.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                IProject project = this.getRoot().getProject(element);
                if (project.isAccessible()) {
                    configs.add(((Project)project).internalGetActiveBuildConfig());
                }
                ++n2;
            }
            configs.addAll(Arrays.asList(Workspace.vertexOrderToProjectBuildConfigOrder(this.computeActiveBuildConfigOrder()).buildConfigurations));
            IBuildConfiguration[] bo = new IBuildConfiguration[configs.size()];
            configs.toArray(bo);
            this.buildOrder = bo;
        } else {
            ComputeProjectOrder.Digraph<IBuildConfiguration> buildGraph = this.getBuildGraph();
            this.buildOrder = Workspace.vertexOrderToProjectBuildConfigOrder(ComputeProjectOrder.computeVertexOrder(buildGraph, IBuildConfiguration.class)).buildConfigurations;
        }
        return this.buildOrder;
    }

    private ComputeProjectOrder.Digraph<IBuildConfiguration> getBuildGraph() {
        if (this.buildOrderGraph != null) {
            return this.buildOrderGraph;
        }
        String[] order = this.description.getBuildOrder(false);
        if (order != null) {
            return null;
        }
        this.buildOrderGraph = this.computeActiveBuildConfigGraph();
        return this.buildOrderGraph;
    }

    public CharsetManager getCharsetManager() {
        return this.charsetManager;
    }

    public ContentDescriptionManager getContentDescriptionManager() {
        return this.contentDescriptionManager;
    }

    @Override
    public IWorkspaceDescription getDescription() {
        WorkspaceDescription workingCopy = Workspace.defaultWorkspaceDescription();
        this.description.copyTo(workingCopy);
        return workingCopy;
    }

    public ElementTree getElementTree() {
        return this.tree;
    }

    public FileSystemResourceManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public MarkerManager getMarkerManager() {
        return this.markerManager;
    }

    public LocalMetaArea getMetaArea() {
        return this.localMetaArea;
    }

    protected IMoveDeleteHook getMoveDeleteHook() {
        if (this.moveDeleteHook == null) {
            this.initializeMoveDeleteHook();
        }
        return this.moveDeleteHook;
    }

    @Override
    public IFilterMatcherDescriptor getFilterMatcherDescriptor(String filterMatcherId) {
        return this.filterManager.getFilterDescriptor(filterMatcherId);
    }

    @Override
    public IProjectNatureDescriptor getNatureDescriptor(String natureId) {
        return this.natureManager.getNatureDescriptor(natureId);
    }

    public NatureManager getNatureManager() {
        return this.natureManager;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @Override
    public IPathVariableManager getPathVariableManager() {
        return this.pathVariableManager;
    }

    public IPropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public RefreshManager getRefreshManager() {
        return this.refreshManager;
    }

    public ResourceInfo getResourceInfo(IPath path, boolean phantom, boolean mutable) {
        ResourceInfo result;
        block6: {
            block5: {
                try {
                    if (path.segmentCount() == 0) {
                        ResourceInfo info = (ResourceInfo)this.tree.getTreeData();
                        Assert.isNotNull(info, "Tree root info must never be null");
                        return info;
                    }
                    result = null;
                    if (this.tree.includes(path)) break block5;
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            result = mutable ? (ResourceInfo)this.tree.openElementData(path) : (ResourceInfo)this.tree.getElementData(path);
            if (result == null || phantom || !result.isSet(8)) break block6;
            return null;
        }
        return result;
    }

    @Override
    public IWorkspaceRoot getRoot() {
        return this.defaultRoot;
    }

    @Override
    public IResourceRuleFactory getRuleFactory() {
        if (this.ruleFactory == null) {
            this.ruleFactory = new Rules(this);
        }
        return this.ruleFactory;
    }

    public SaveManager getSaveManager() {
        return this.saveManager;
    }

    public ISynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    protected TeamHook getTeamHook() {
        if (this.teamHook == null) {
            this.initializeTeamHook();
        }
        return this.teamHook;
    }

    public WorkManager getWorkManager() throws CoreException {
        if (this._workManager == null) {
            String message = Messages.resources_shutdown;
            throw new ResourceException(new ResourceStatus(566, null, message));
        }
        return this._workManager;
    }

    protected void initializeMoveDeleteHook() {
        try {
            if (!this.canCreateExtensions()) {
                return;
            }
            IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.resources", "moveDeleteHook");
            if (configs == null || configs.length == 0) {
                return;
            }
            if (configs.length > 1) {
                ResourceStatus status = new ResourceStatus(4, 1, null, Messages.resources_oneHook, null);
                Policy.log(status);
                return;
            }
            try {
                IConfigurationElement config = configs[0];
                this.moveDeleteHook = (IMoveDeleteHook)config.createExecutableExtension("class");
            }
            catch (CoreException e) {
                if (this.canCreateExtensions()) {
                    ResourceStatus status = new ResourceStatus(4, 1, null, Messages.resources_initHook, (Throwable)e);
                    Policy.log(status);
                }
            }
        }
        finally {
            if (this.moveDeleteHook == null) {
                this.moveDeleteHook = new MoveDeleteHook();
            }
        }
    }

    protected void initializeTeamHook() {
        IConfigurationElement[] configs;
        block14: {
            block15: {
                block12: {
                    block13: {
                        block10: {
                            block11: {
                                try {
                                    if (this.canCreateExtensions()) break block10;
                                    if (this.teamHook != null) break block11;
                                }
                                catch (Throwable throwable) {
                                    if (this.teamHook == null) {
                                        this.teamHook = new TeamHook(){};
                                    }
                                    throw throwable;
                                }
                                this.teamHook = new /* invalid duplicate definition of identical inner class */;
                            }
                            return;
                        }
                        configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.resources", "teamHook");
                        if (configs != null && configs.length != 0) break block12;
                        if (this.teamHook != null) break block13;
                        this.teamHook = new /* invalid duplicate definition of identical inner class */;
                    }
                    return;
                }
                if (configs.length <= 1) break block14;
                ResourceStatus status = new ResourceStatus(4, 1, null, Messages.resources_oneTeamHook, null);
                Policy.log(status);
                if (this.teamHook != null) break block15;
                this.teamHook = new /* invalid duplicate definition of identical inner class */;
            }
            return;
        }
        try {
            IConfigurationElement config = configs[0];
            this.teamHook = (TeamHook)config.createExecutableExtension("class");
        }
        catch (CoreException e) {
            if (this.canCreateExtensions()) {
                ResourceStatus status = new ResourceStatus(4, 1, null, Messages.resources_initTeamHook, (Throwable)e);
                Policy.log(status);
            }
        }
        if (this.teamHook == null) {
            this.teamHook = new /* invalid duplicate definition of identical inner class */;
        }
    }

    protected void initializeValidator() {
        block5: {
            this.shouldValidate = false;
            if (!this.canCreateExtensions()) {
                return;
            }
            IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.resources", "fileModificationValidator");
            if (configs == null || configs.length == 0) {
                return;
            }
            if (configs.length > 1) {
                ResourceStatus status = new ResourceStatus(4, 1, null, Messages.resources_oneValidator, null);
                Policy.log(status);
                return;
            }
            try {
                IConfigurationElement config = configs[0];
                this.validator = (IFileModificationValidator)config.createExecutableExtension("class");
                this.shouldValidate = true;
            }
            catch (CoreException e) {
                if (!this.canCreateExtensions()) break block5;
                ResourceStatus status = new ResourceStatus(4, 1, null, Messages.resources_initValidator, (Throwable)e);
                Policy.log(status);
            }
        }
    }

    public WorkspaceDescription internalGetDescription() {
        return this.description;
    }

    public boolean isAutoBuilding() {
        return this.description.isAutoBuilding();
    }

    public boolean isOpen() {
        return this.openFlag;
    }

    @Override
    public boolean isTreeLocked() {
        return this.treeLocked == Thread.currentThread();
    }

    protected void linkTrees(IPath path, ElementTree[] newTrees) {
        this.tree = this.tree.mergeDeltaChain(path, newTrees);
    }

    protected ResourceInfo newElement(int type) {
        ResourceInfo result = null;
        switch (type) {
            case 1: 
            case 2: {
                result = new ResourceInfo();
                break;
            }
            case 4: {
                result = new ProjectInfo();
                break;
            }
            case 8: {
                result = new RootInfo();
            }
        }
        result.setNodeId(this.nextNodeId());
        this.updateModificationStamp(result);
        result.setType(type);
        return result;
    }

    @Override
    public IProjectDescription newProjectDescription(String projectName) {
        ProjectDescription result = new ProjectDescription();
        result.setName(projectName);
        return result;
    }

    public Resource newResource(IPath path, int type) {
        switch (type) {
            case 2: {
                if (path.segmentCount() < 2) {
                    String message = "Path must include project and resource name: " + path.toString();
                    Assert.isLegal(false, message);
                }
                return new Folder(path.makeAbsolute(), this);
            }
            case 1: {
                if (path.segmentCount() < 2) {
                    String message = "Path must include project and resource name: " + path.toString();
                    Assert.isLegal(false, message);
                }
                return new File(path.makeAbsolute(), this);
            }
            case 4: {
                return (Resource)((Object)this.getRoot().getProject(path.lastSegment()));
            }
            case 8: {
                return (Resource)((Object)this.getRoot());
            }
        }
        Assert.isLegal(false);
        return null;
    }

    public ElementTree newWorkingTree() {
        this.tree = this.tree.newEmptyDelta();
        return this.tree;
    }

    protected long nextMarkerId() {
        return this.nextMarkerId++;
    }

    protected long nextNodeId() {
        return this.nextNodeId++;
    }

    public IStatus open(IProgressMonitor monitor) throws CoreException {
        String message = Messages.resources_workspaceOpen;
        Assert.isTrue(!this.isOpen(), message);
        if (!this.getMetaArea().hasSavedWorkspace()) {
            message = Messages.resources_readWorkspaceMeta;
            throw new ResourceException(567, Platform.getLocation(), message, null);
        }
        this.description = new WorkspacePreferences();
        WorkspaceDescription oldDescription = this.getMetaArea().readOldWorkspace();
        if (oldDescription != null) {
            this.description.copyFrom(oldDescription);
            ResourcesPlugin.getPlugin().savePluginPreferences();
        }
        this.localMetaArea.locationFor(this.getRoot()).toFile().mkdirs();
        IProgressMonitor nullMonitor = Policy.monitorFor(null);
        this.startup(nullMonitor);
        this.notificationManager.startup(null);
        this.openFlag = true;
        if (this.crashed || this.refreshRequested()) {
            try {
                this.refreshManager.refresh(this.getRoot());
            }
            catch (RuntimeException e) {
                return new ResourceStatus(566, Path.ROOT, Messages.resources_errorMultiRefresh, (Throwable)e);
            }
        }
        this.stringPoolJob = new StringPoolJob();
        this.stringPoolJob.addStringPoolParticipant(this.saveManager, this.getRoot());
        return Status.OK_STATUS;
    }

    public void prepareOperation(ISchedulingRule rule, IProgressMonitor monitor) throws CoreException {
        try {
            ISchedulingRule buildRule = this.getRuleFactory().buildRule();
            if (rule != null && buildRule != null && (rule.isConflicting(buildRule) || buildRule.isConflicting(rule))) {
                this.buildManager.interrupt();
            }
        }
        finally {
            this.getWorkManager().checkIn(rule, monitor);
        }
        if (!this.isOpen()) {
            String message = Messages.resources_workspaceClosed;
            throw new ResourceException(76, null, message, null);
        }
    }

    protected boolean refreshRequested() {
        String[] args;
        String[] stringArray = args = Platform.getCommandLineArgs();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equalsIgnoreCase("-refresh")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void removeResourceChangeListener(IResourceChangeListener listener) {
        this.notificationManager.removeListener(listener);
    }

    @Override
    public void removeSaveParticipant(String pluginId) {
        Assert.isNotNull(pluginId, "Plugin id must not be null");
        this.saveManager.removeParticipant(pluginId);
    }

    @Override
    public void run(ICoreRunnable action, ISchedulingRule rule, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask("", 100);
            int depth = -1;
            boolean avoidNotification = (options & 1) != 0;
            try {
                try {
                    this.prepareOperation(rule, monitor);
                    this.beginOperation(true);
                    if (avoidNotification) {
                        avoidNotification = this.notificationManager.beginAvoidNotify();
                    }
                    depth = this.getWorkManager().beginUnprotected();
                    action.run(Policy.subMonitorFor(monitor, Policy.opWork));
                }
                catch (OperationCanceledException e) {
                    this.getWorkManager().operationCanceled();
                    throw e;
                }
                catch (CoreException e) {
                    if (e.getStatus().getSeverity() == 8) {
                        this.getWorkManager().operationCanceled();
                    }
                    throw e;
                }
            }
            finally {
                if (avoidNotification) {
                    this.notificationManager.endAvoidNotify();
                }
                if (depth >= 0) {
                    this.getWorkManager().endUnprotected(depth);
                }
                this.endOperation(rule, false);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void run(IWorkspaceRunnable action, IProgressMonitor monitor) throws CoreException {
        this.run((ICoreRunnable)action, (ISchedulingRule)this.defaultRoot, 1, monitor);
    }

    @Override
    public void run(IWorkspaceRunnable action, ISchedulingRule rule, int options, IProgressMonitor monitor) throws CoreException {
        this.run((ICoreRunnable)action, rule, options, monitor);
    }

    public void setCrashed(boolean value) {
        this.crashed = value;
        if (this.crashed) {
            String msg = "The workspace exited with unsaved changes in the previous session; refreshing workspace to recover changes.";
            Policy.log(new ResourceStatus(10035, msg));
            if (Policy.DEBUG) {
                Policy.debug(msg);
            }
        }
    }

    public void setTreeLocked(boolean locked) {
        Assert.isTrue(!locked || this.treeLocked == null, "The workspace tree is already locked");
        this.treeLocked = locked ? Thread.currentThread() : null;
    }

    protected void shutdown(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            IManager[] managers = new IManager[]{this.buildManager, this.propertyManager, this.pathVariableManager, this.charsetManager, this.fileSystemManager, this.markerManager, this._workManager, this.aliasManager, this.refreshManager, this.contentDescriptionManager, this.natureManager, this.filterManager};
            monitor.beginTask("", managers.length);
            String message = Messages.resources_shutdownProblems;
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, message, null);
            IManager[] iManagerArray = managers;
            int n = managers.length;
            int n2 = 0;
            while (n2 < n) {
                IManager manager = iManagerArray[n2];
                if (manager == null) {
                    monitor.worked(1);
                } else {
                    try {
                        manager.shutdown(Policy.subMonitorFor(monitor, 1));
                    }
                    catch (Exception e) {
                        message = Messages.resources_shutdownProblems;
                        status.add(new Status(4, "org.eclipse.core.resources", 566, message, e));
                    }
                }
                ++n2;
            }
            this.buildManager = null;
            this.notificationManager = null;
            this.propertyManager = null;
            this.pathVariableManager = null;
            this.fileSystemManager = null;
            this.markerManager = null;
            this.synchronizer = null;
            this.saveManager = null;
            this._workManager = null;
            this.aliasManager = null;
            this.refreshManager = null;
            this.charsetManager = null;
            this.contentDescriptionManager = null;
            if (!status.isOK()) {
                throw new CoreException(status);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void startup(IProgressMonitor monitor) throws CoreException {
        try {
            this._workManager = new WorkManager(this);
            this._workManager.startup(null);
            this.fileSystemManager = new FileSystemResourceManager(this);
            this.fileSystemManager.startup(monitor);
            this.pathVariableManager = new PathVariableManager();
            this.pathVariableManager.startup(null);
            this.natureManager = new NatureManager();
            this.natureManager.startup(null);
            this.filterManager = new FilterTypeManager();
            this.filterManager.startup(null);
            this.buildManager = new BuildManager(this, this.getWorkManager().getLock());
            this.buildManager.startup(null);
            this.notificationManager = new NotificationManager(this);
            this.notificationManager.startup(null);
            this.markerManager = new MarkerManager(this);
            this.markerManager.startup(null);
            this.synchronizer = new Synchronizer(this);
            this.saveManager = new SaveManager(this);
            this.saveManager.startup(null);
            this.propertyManager = new PropertyManager2((Workspace)ResourcesPlugin.getWorkspace());
            this.propertyManager.startup(monitor);
            this.charsetManager = new CharsetManager(this);
            this.charsetManager.startup(null);
            this.contentDescriptionManager = new ContentDescriptionManager();
            this.contentDescriptionManager.startup(null);
            this.refreshManager = new RefreshManager(this);
            this.refreshManager.startup(null);
            this.aliasManager = new AliasManager(this);
            this.aliasManager.startup(null);
        }
        finally {
            this.treeLocked = null;
            this._workManager.postWorkspaceStartup();
        }
    }

    public void updateModificationStamp(ResourceInfo info) {
        info.incrementModificationStamp();
    }

    @Override
    public IStatus validateEdit(final IFile[] files, final Object context) {
        if (!this.shouldValidate) {
            String message = Messages.resources_readOnly2;
            MultiStatus result = new MultiStatus("org.eclipse.core.resources", 279, message, null);
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.isReadOnly()) {
                    IPath filePath = file.getFullPath();
                    message = NLS.bind(Messages.resources_readOnly, filePath);
                    result.add(new ResourceStatus(279, filePath, message));
                }
                ++n2;
            }
            return result.getChildren().length == 0 ? Status.OK_STATUS : result;
        }
        if (this.validator == null) {
            this.initializeValidator();
        }
        if (this.validator == null) {
            return Status.OK_STATUS;
        }
        final IStatus[] status = new IStatus[1];
        ISafeRunnable body = new ISafeRunnable(){

            @Override
            public void handleException(Throwable exception) {
                status[0] = new ResourceStatus(4, null, Messages.resources_errorValidator, exception);
            }

            @Override
            public void run() throws Exception {
                Object c = context;
                if (!(Workspace.this.validator instanceof FileModificationValidator) && c instanceof FileModificationValidationContext) {
                    c = null;
                }
                status[0] = Workspace.this.validator.validateEdit(files, c);
            }
        };
        SafeRunner.run(body);
        return status[0];
    }

    public IStatus validateLinkLocationURI(IResource resource, URI unresolvedLocation) {
        return this.locationValidator.validateLinkLocationURI(resource, unresolvedLocation);
    }

    @Override
    public IStatus validateName(String segment, int type) {
        return this.locationValidator.validateName(segment, type);
    }

    public IStatus validateProjectLocationURI(IProject project, URI location) {
        return this.locationValidator.validateProjectLocationURI(project, location);
    }

    protected void validateSave(final IFile file) throws CoreException {
        if (!this.shouldValidate) {
            return;
        }
        if (this.validator == null) {
            this.initializeValidator();
        }
        if (this.validator == null) {
            return;
        }
        final IStatus[] status = new IStatus[1];
        ISafeRunnable body = new ISafeRunnable(){

            @Override
            public void handleException(Throwable exception) {
                status[0] = new ResourceStatus(4, null, Messages.resources_errorValidator, exception);
            }

            @Override
            public void run() throws Exception {
                status[0] = Workspace.this.validator.validateSave(file);
            }
        };
        SafeRunner.run(body);
        if (!status[0].isOK()) {
            throw new ResourceException(status[0]);
        }
    }

    private static class BuildConfigurationComparator
    implements Comparator<IBuildConfiguration> {
        @Override
        public int compare(IBuildConfiguration px, IBuildConfiguration py) {
            int cmp = py.getProject().getName().compareTo(px.getProject().getName());
            if (cmp == 0) {
                cmp = py.getName().compareTo(px.getName());
            }
            return cmp;
        }
    }

    public static final class ProjectBuildConfigOrder {
        public IBuildConfiguration[] buildConfigurations;
        public boolean hasCycles;
        public IBuildConfiguration[][] knots;

        public ProjectBuildConfigOrder(IBuildConfiguration[] buildConfigurations, boolean hasCycles, IBuildConfiguration[][] knots) {
            this.buildConfigurations = buildConfigurations;
            this.hasCycles = hasCycles;
            this.knots = knots;
        }
    }
}

