/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.SyncInfoReader;
import org.eclipse.core.internal.resources.SyncInfoSnapReader;
import org.eclipse.core.internal.resources.SyncInfoWriter;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class Synchronizer
implements ISynchronizer {
    protected Workspace workspace;
    protected SyncInfoWriter writer;
    protected Set<QualifiedName> registry = new HashSet<QualifiedName>(5);

    public Synchronizer(Workspace workspace) {
        this.workspace = workspace;
        this.writer = new SyncInfoWriter(workspace, this);
    }

    protected Set<QualifiedName> getRegistry() {
        return this.registry;
    }

    public void readPartners(DataInputStream input) throws CoreException {
        SyncInfoReader reader = new SyncInfoReader(this.workspace, this);
        reader.readPartners(input);
    }

    public void restore(IResource resource, IProgressMonitor monitor) throws CoreException {
        this.restoreFromSave(resource);
        this.restoreFromSnap(resource);
    }

    protected void restoreFromSave(IResource resource) throws CoreException {
        IPath sourceLocation = this.workspace.getMetaArea().getSyncInfoLocationFor(resource);
        IPath tempLocation = this.workspace.getMetaArea().getBackupLocationFor(sourceLocation);
        if (!sourceLocation.toFile().exists() && !tempLocation.toFile().exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (DataInputStream input = new DataInputStream(new SafeFileInputStream(sourceLocation.toOSString(), tempLocation.toOSString()));){
                SyncInfoReader reader = new SyncInfoReader(this.workspace, this);
                reader.readSyncInfo(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            String msg = NLS.bind(Messages.resources_readMeta, sourceLocation);
            throw new ResourceException(567, sourceLocation, msg, e);
        }
    }

    protected void restoreFromSnap(IResource resource) {
        IPath sourceLocation = this.workspace.getMetaArea().getSyncInfoSnapshotLocationFor(resource);
        if (!sourceLocation.toFile().exists()) {
            return;
        }
        try {
            DataInputStream input = new DataInputStream(new SafeChunkyInputStream(sourceLocation.toFile()));
            try {
                try {
                    SyncInfoSnapReader reader = new SyncInfoSnapReader(this.workspace, this);
                    while (true) {
                        reader.readSyncInfo(input);
                    }
                }
                catch (EOFException eOFException) {
                    input.close();
                }
            }
            catch (Throwable throwable) {
                input.close();
                throw throwable;
            }
        }
        catch (Exception e) {
            String msg = NLS.bind(Messages.resources_readMeta, sourceLocation);
            Policy.log(new ResourceStatus(567, sourceLocation, msg, (Throwable)e));
        }
    }

    public void savePartners(DataOutputStream output) throws IOException {
        this.writer.savePartners(output);
    }

    public void saveSyncInfo(ResourceInfo info, IPathRequestor requestor, DataOutputStream output, List<QualifiedName> writtenPartners) throws IOException {
        this.writer.saveSyncInfo(info, requestor, output, writtenPartners);
    }

    protected void setRegistry(Set<QualifiedName> registry) {
        this.registry = registry;
    }

    public void snapSyncInfo(ResourceInfo info, IPathRequestor requestor, DataOutputStream output) throws IOException {
        this.writer.snapSyncInfo(info, requestor, output);
    }
}

