/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Filter;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.Marker;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectPathVariableManager;
import org.eclipse.core.internal.resources.ProjectPreferences;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceProxy;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.ResourceTree;
import org.eclipse.core.internal.resources.Rules;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.WrappedRuntimeException;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;

public abstract class Resource
extends PlatformObject
implements Cloneable,
ICoreConstants,
IPathRequestor,
IResource {
    IPath path;
    Workspace workspace;

    protected Resource(IPath path, Workspace workspace) {
        this.path = path.removeTrailingSeparator();
        this.workspace = workspace;
    }

    @Override
    public void accept(IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
        this.accept(visitor, 2, memberFlags);
    }

    public void accept(IResourceProxyVisitor visitor, int depth, int memberFlags) throws CoreException {
        boolean includePhantoms;
        boolean bl = includePhantoms = (memberFlags & 1) != 0;
        if ((memberFlags & 0x10) == 0) {
            this.checkAccessible(this.getFlags(this.getResourceInfo(includePhantoms, false)));
        }
        ResourceProxy proxy = new ResourceProxy();
        IElementContentVisitor elementVisitor = (tree, requestor, contents) -> {
            ResourceInfo info = (ResourceInfo)contents;
            if (!this.isMember(this.getFlags(info), memberFlags)) {
                return false;
            }
            resourceProxy.requestor = requestor;
            resourceProxy.info = info;
            try {
                boolean shouldContinue = true;
                switch (depth) {
                    case 0: {
                        shouldContinue = false;
                        break;
                    }
                    case 1: {
                        shouldContinue = !this.path.equals(requestor.requestPath().removeLastSegments(1));
                        break;
                    }
                    case 2: {
                        shouldContinue = true;
                    }
                }
                boolean bl = visitor.visit(proxy) && shouldContinue;
                return bl;
            }
            catch (CoreException e) {
                throw new WrappedRuntimeException(e);
            }
            finally {
                proxy.reset();
            }
        };
        try {
            try {
                new ElementTreeIterator(this.workspace.getElementTree(), this.getFullPath()).iterate(elementVisitor);
            }
            catch (WrappedRuntimeException e) {
                throw (CoreException)e.getTargetException();
            }
        }
        finally {
            proxy.requestor = null;
            proxy.info = null;
        }
    }

    @Override
    public void accept(IResourceVisitor visitor) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    @Override
    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        IResource[] members;
        if (depth == 2) {
            this.accept(proxy -> visitor.visit(proxy.requestResource()), memberFlags);
            return;
        }
        boolean includePhantoms = (memberFlags & 1) != 0;
        ResourceInfo info = this.getResourceInfo(includePhantoms, false);
        int flags = this.getFlags(info);
        if ((memberFlags & 0x10) == 0) {
            this.checkAccessible(flags);
        }
        if (!this.isMember(flags, memberFlags)) {
            return;
        }
        if (!visitor.visit(this) || depth == 0) {
            return;
        }
        info = this.getResourceInfo(includePhantoms, false);
        if (info == null) {
            return;
        }
        int type = info.getType();
        if (type == 1) {
            return;
        }
        IContainer resource = this.getType() != type ? (IContainer)((Object)this.workspace.newResource(this.getFullPath(), type)) : (IContainer)((Object)this);
        IResource[] iResourceArray = members = resource.members(memberFlags);
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            member.accept(visitor, 0, memberFlags | 0x10);
            ++n2;
        }
    }

    protected void assertCopyRequirements(IPath destination, int destinationType, int updateFlags) throws CoreException {
        IStatus status = this.checkCopyRequirements(destination, destinationType, updateFlags);
        if (!status.isOK()) {
            Assert.isTrue(false, status.getChildren()[0].getMessage());
        }
    }

    protected IFileInfo assertLinkRequirements(URI localLocation, int updateFlags) throws CoreException {
        IStatus locationStatus;
        boolean variableUndefined;
        boolean allowMissingLocal;
        boolean bl = allowMissingLocal = (updateFlags & 0x10) != 0;
        if ((updateFlags & 0x100) == 0) {
            this.checkDoesNotExist(this.getFlags(this.getResourceInfo(false, false)), true);
        }
        boolean bl2 = variableUndefined = (locationStatus = this.workspace.validateLinkLocationURI(this, localLocation)).getCode() == 333;
        if (locationStatus.getSeverity() == 4 || variableUndefined && !allowMissingLocal) {
            throw new ResourceException(locationStatus);
        }
        Container parent = (Container)this.getParent();
        parent.checkAccessible(this.getFlags(parent.getResourceInfo(false, false)));
        if (variableUndefined) {
            return null;
        }
        URI resolved = this.getPathVariableManager().resolveURI(localLocation);
        IFileStore store = EFS.getStore(resolved);
        IFileInfo fileInfo = store.fetchInfo();
        boolean localExists = fileInfo.exists();
        if (!allowMissingLocal && !localExists) {
            String msg = NLS.bind(Messages.links_localDoesNotExist, store.toString());
            throw new ResourceException(269, this.getFullPath(), msg, null);
        }
        if (localExists && this.getType() == 2 != fileInfo.isDirectory()) {
            String msg = NLS.bind(Messages.links_wrongLocalType, this.getFullPath());
            throw new ResourceException(276, this.getFullPath(), msg, null);
        }
        return fileInfo;
    }

    public void checkAccessible(int flags) throws CoreException {
        this.checkExists(flags, true);
    }

    private ResourceInfo checkAccessibleAndLocal(int depth) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, depth);
        return info;
    }

    public IStatus checkCopyRequirements(IPath destination, int destinationType, int updateFlags) throws CoreException {
        String message = Messages.resources_copyNotMet;
        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 77, message, null);
        if (destination == null) {
            message = Messages.resources_destNotNull;
            return new ResourceStatus(77, this.getFullPath(), message);
        }
        destination = this.makePathAbsolute(destination);
        if (this.getFullPath().isPrefixOf(destination)) {
            message = NLS.bind(Messages.resources_copyDestNotSub, this.getFullPath());
            status.add(new ResourceStatus(77, this.getFullPath(), message));
        }
        this.checkValidPath(destination, destinationType, false);
        this.checkAccessibleAndLocal(2);
        IPath destinationParent = destination.removeLastSegments(1);
        this.checkValidGroupContainer(destinationParent, this.isLinked(), this.isVirtual());
        Resource dest = this.workspace.newResource(destination, destinationType);
        dest.checkDoesNotExist();
        if (this.getType() == 1 && destinationType == 4) {
            message = Messages.resources_fileToProj;
            throw new ResourceException(77, this.getFullPath(), message, null);
        }
        if (destinationType != 4) {
            Project project = (Project)dest.getProject();
            ResourceInfo info = project.getResourceInfo(false, false);
            project.checkAccessible(this.getFlags(info));
            Container parent = (Container)dest.getParent();
            if (!parent.equals(project)) {
                info = parent.getResourceInfo(false, false);
                parent.checkExists(this.getFlags(info), true);
            }
        }
        if (this.isUnderLink() || dest.isUnderLink()) {
            URI sourceLocation = this.getLocationURI();
            if (sourceLocation == null) {
                message = NLS.bind(Messages.localstore_locationUndefined, this.getFullPath());
                throw new ResourceException(271, this.getFullPath(), message, null);
            }
            URI destLocation = dest.getLocationURI();
            if (destLocation == null && !dest.isUnderVirtual()) {
                message = NLS.bind(Messages.localstore_locationUndefined, dest.getFullPath());
                throw new ResourceException(271, dest.getFullPath(), message, null);
            }
            if (this.getStore().isParentOf(dest.getStore())) {
                message = NLS.bind(Messages.resources_copyDestNotSub, this.getFullPath());
                throw new ResourceException(77, this.getFullPath(), message, null);
            }
        }
        return status.isOK() ? Status.OK_STATUS : status;
    }

    protected void checkDoesNotExist() throws CoreException {
        this.checkDoesNotExist(this.getFlags(this.getResourceInfo(false, false)), false);
    }

    public void checkDoesNotExist(int flags, boolean checkType) throws CoreException {
        if (this.exists(flags, checkType)) {
            String message = NLS.bind(Messages.resources_mustNotExist, this.getFullPath());
            throw new ResourceException(checkType ? 367 : 374, this.getFullPath(), message, null);
        }
        if (Workspace.caseSensitive) {
            return;
        }
        IResource variant = this.findExistingResourceVariant(this.getFullPath());
        if (variant == null) {
            return;
        }
        String msg = NLS.bind(Messages.resources_existsDifferentCase, variant.getFullPath());
        throw new ResourceException(275, variant.getFullPath(), msg, null);
    }

    public void checkExists(int flags, boolean checkType) throws CoreException {
        if (!this.exists(flags, checkType)) {
            String message = NLS.bind(Messages.resources_mustExist, this.getFullPath());
            throw new ResourceException(368, this.getFullPath(), message, null);
        }
    }

    public void checkLocal(int flags, int depth) throws CoreException {
        if (!this.isLocal(flags, depth)) {
            String message = NLS.bind(Messages.resources_mustBeLocal, this.getFullPath());
            throw new ResourceException(369, this.getFullPath(), message, null);
        }
    }

    public void checkValidPath(IPath toValidate, int type, boolean lastSegmentOnly) throws CoreException {
        IStatus result = this.workspace.locationValidator.validatePath(toValidate, type, lastSegmentOnly);
        if (!result.isOK()) {
            throw new ResourceException(result);
        }
    }

    public void checkValidGroupContainer(IPath destination, boolean isLink, boolean isGroup) throws CoreException {
        IStatus status = this.getValidGroupContainer(destination, isLink, isGroup);
        if (!status.isOK()) {
            throw new ResourceException(status);
        }
    }

    public void checkValidGroupContainer(Container destination, boolean isLink, boolean isGroup) throws CoreException {
        if (!isLink && !isGroup) {
            String message = Messages.group_invalidParent;
            if (destination.isVirtual()) {
                throw new ResourceException(new ResourceStatus(77, null, message));
            }
        }
    }

    public IStatus getValidGroupContainer(IPath destination, boolean isLink, boolean isGroup) {
        if (!isLink && !isGroup) {
            String message = Messages.group_invalidParent;
            ResourceInfo info = this.workspace.getResourceInfo(destination, false, false);
            if (info != null && info.isSet(524288)) {
                return new ResourceStatus(77, null, message);
            }
        }
        return Status.OK_STATUS;
    }

    public void clearHistory(IProgressMonitor monitor) {
        this.getLocalManager().getHistoryStore().remove(this.getFullPath(), monitor);
    }

    @Override
    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule.getClass().equals(WorkManager.NotifyRule.class)) {
            return true;
        }
        if (rule instanceof MultiRule) {
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!(rule instanceof IResource)) {
            return false;
        }
        IResource resource = (IResource)rule;
        if (!this.workspace.equals(resource.getWorkspace())) {
            return false;
        }
        return this.path.isPrefixOf(resource.getFullPath());
    }

    public void convertToPhantom() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, true);
        if (info == null || this.isPhantom(this.getFlags(info))) {
            return;
        }
        info.clearSessionProperties();
        info.set(8);
        this.getLocalManager().updateLocalSync(info, -1L);
        info.clearModificationStamp();
        info.setMarkers(null);
    }

    @Override
    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind(Messages.resources_copying, this.getFullPath());
        SubMonitor progress = SubMonitor.convert(monitor, message, 100).checkCanceled();
        destination = this.makePathAbsolute(destination);
        this.checkValidPath(destination, this.getType(), false);
        Resource destResource = this.workspace.newResource(destination, this.getType());
        ISchedulingRule rule = this.workspace.getRuleFactory().copyRule(this, destResource);
        try {
            try {
                this.workspace.prepareOperation(rule, progress.split(1));
                this.assertCopyRequirements(destination, this.getType(), updateFlags);
                this.workspace.beginOperation(true);
                this.getLocalManager().copy(this, destResource, updateFlags, progress.split(98));
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        finally {
            this.workspace.endOperation(rule, true);
        }
    }

    public int countResources(int depth, boolean phantom) {
        return this.workspace.countResources(this.path, depth, phantom);
    }

    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(localLocation);
        this.createLink(URIUtil.toURI(localLocation), updateFlags, monitor);
    }

    public void createLink(URI localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(localLocation);
        IResource existing = null;
        if ((updateFlags & 0x100) != 0 && (existing = this.workspace.getRoot().findMember(this.getFullPath())) != null && existing.isLinked()) {
            this.setLinkLocation(localLocation, updateFlags, monitor);
            return;
        }
        String message = NLS.bind(Messages.links_creating, this.getFullPath());
        SubMonitor progress = SubMonitor.convert(monitor, message, 100).checkCanceled();
        this.checkValidPath(this.path, 2, true);
        ISchedulingRule rule = this.workspace.getRuleFactory().createRule(this);
        try {
            try {
                this.workspace.prepareOperation(rule, progress.split(1));
                IFileInfo fileInfo = this.assertLinkRequirements(localLocation, updateFlags);
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(512, this));
                this.workspace.beginOperation(true);
                if ((updateFlags & 0x100) != 0 && existing != null) {
                    this.workspace.deleteResource(existing);
                }
                ResourceInfo info = this.workspace.createResource((IResource)this, false);
                if ((updateFlags & 0x1000) != 0) {
                    info.set(0x200000);
                }
                info.set(65536);
                LinkDescription linkDescription = new LinkDescription(this, localLocation);
                if (linkDescription.isGroup()) {
                    info.set(524288);
                }
                this.getLocalManager().link(this, localLocation, fileInfo);
                progress.split(5);
                Project project = (Project)this.getProject();
                boolean changed = project.internalGetDescription().setLinkLocation(this.getProjectRelativePath(), linkDescription);
                if (changed) {
                    try {
                        project.writeDescription(0);
                    }
                    catch (CoreException e) {
                        this.workspace.deleteResource(this);
                        throw e;
                    }
                }
                progress.split(4);
                if (this.getType() != 1) {
                    if ((updateFlags & 0x80) != 0) {
                        this.workspace.refreshManager.refresh(this);
                        progress.split(90);
                    } else {
                        this.refreshLocal(2, progress.split(90));
                    }
                } else {
                    progress.split(90);
                }
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        finally {
            this.workspace.endOperation(rule, true);
        }
    }

    @Override
    public IMarker createMarker(String type) throws CoreException {
        Assert.isNotNull(type);
        ISchedulingRule rule = this.workspace.getRuleFactory().markerRule(this);
        try {
            this.workspace.prepareOperation(rule, null);
            this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
            this.workspace.beginOperation(true);
            MarkerInfo info = new MarkerInfo();
            info.setType(type);
            info.setCreationTime(System.currentTimeMillis());
            this.workspace.getMarkerManager().add(this, info);
            Marker marker = new Marker(this, info.getId());
            return marker;
        }
        finally {
            this.workspace.endOperation(rule, false);
        }
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        this.delete(force ? 1 : 0, monitor);
    }

    @Override
    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind(Messages.resources_deleting, this.getFullPath());
        SubMonitor progress = SubMonitor.convert(monitor, 100).checkCanceled();
        progress.subTask(message);
        ISchedulingRule rule = this.workspace.getRuleFactory().deleteRule(this);
        try {
            this.workspace.prepareOperation(rule, progress.split(1));
            if (!this.exists()) {
                return;
            }
            try {
                this.workspace.beginOperation(true);
                this.broadcastPreDeleteEvent();
                if (this.getType() == 4) {
                    this.workspace.flushBuildOrder();
                }
                IFileStore originalStore = this.getStore();
                boolean wasLinked = this.isLinked();
                message = Messages.resources_deleteProblem;
                MultiStatus status = new MultiStatus("org.eclipse.core.resources", 273, message, null);
                WorkManager workManager = this.workspace.getWorkManager();
                ResourceTree tree = new ResourceTree(this.workspace.getFileSystemManager(), workManager.getLock(), status, updateFlags);
                int depth = 0;
                try {
                    depth = workManager.beginUnprotected();
                    this.unprotectedDelete(tree, updateFlags, progress.split(50));
                }
                finally {
                    workManager.endUnprotected(depth);
                }
                if (this.getType() == 8) {
                    this.workspace.getMarkerManager().removeMarkers(this, 0);
                    this.getPropertyManager().deleteProperties(this, 0);
                    this.getResourceInfo(false, false).clearSessionProperties();
                }
                tree.makeInvalid();
                if (!tree.getStatus().isOK()) {
                    throw new ResourceException(tree.getStatus());
                }
                if (!wasLinked) {
                    this.workspace.getAliasManager().updateAliases(this, originalStore, 2, progress.split(48));
                }
                if (this.getType() == 4) {
                    ((Rules)this.workspace.getRuleFactory()).setRuleFactory((IProject)((Object)this), null);
                    this.workspace.getSaveManager().requestSnapshot();
                }
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        finally {
            this.workspace.endOperation(rule, true);
        }
    }

    @Override
    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        ISchedulingRule rule = this.workspace.getRuleFactory().markerRule(this);
        try {
            this.workspace.prepareOperation(rule, null);
            ResourceInfo info = this.getResourceInfo(false, false);
            this.checkAccessible(this.getFlags(info));
            this.workspace.beginOperation(true);
            this.workspace.getMarkerManager().removeMarkers(this, type, includeSubtypes, depth);
        }
        finally {
            this.workspace.endOperation(rule, false);
        }
    }

    public void deleteResource(boolean convertToPhantom, MultiStatus status) throws CoreException {
        Project project;
        ProjectDescription description;
        Project project2;
        ProjectDescription description2;
        List<Resource> links;
        if (this.exists()) {
            this.getMarkerManager().removeMarkers(this, 2);
        }
        if ((links = this.findLinks()) != null) {
            for (Resource resource : links) {
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(1024, resource));
            }
        }
        ProjectPreferences.deleted(this);
        if (this.getType() != 4 && links != null && (description2 = (project2 = (Project)this.getProject()).internalGetDescription()) != null) {
            boolean wasChanged = false;
            for (Resource resource : links) {
                wasChanged |= description2.setLinkLocation(resource.getProjectRelativePath(), null);
            }
            if (wasChanged) {
                project2.internalSetDescription(description2, true);
                try {
                    project2.writeDescription(1);
                }
                catch (CoreException e) {
                    project2.updateDescription();
                    throw e;
                }
            }
        }
        if (convertToPhantom && this.getType() != 4 && this.synchronizing(this.getResourceInfo(true, false))) {
            this.convertToPhantom();
        } else {
            this.workspace.deleteResource(this);
        }
        List<Resource> filters = this.findFilters();
        if (filters != null && filters.size() > 0 && (description = (project = (Project)this.getProject()).internalGetDescription()) != null) {
            for (Resource resource : filters) {
                description.setFilters(resource.getProjectRelativePath(), null);
            }
            project.internalSetDescription(description, true);
            project.writeDescription(1);
        }
        CoreException err = null;
        try {
            this.getPropertyManager().deleteResource(this);
        }
        catch (CoreException e) {
            if (status != null) {
                status.add(e.getStatus());
            }
            err = e;
        }
        if (err != null) {
            throw err;
        }
    }

    private List<Resource> findLinks() {
        Project project = (Project)this.getProject();
        ProjectDescription description = project.internalGetDescription();
        HashMap<IPath, LinkDescription> linkMap = description.getLinks();
        if (linkMap == null) {
            return null;
        }
        ArrayList<Resource> links = null;
        IPath myPath = this.getProjectRelativePath();
        for (LinkDescription link : linkMap.values()) {
            IPath linkPath = link.getProjectRelativePath();
            if (!myPath.isPrefixOf(linkPath)) continue;
            if (links == null) {
                links = new ArrayList<Resource>();
            }
            links.add(this.workspace.newResource(project.getFullPath().append(linkPath), link.getType()));
        }
        return links;
    }

    private List<Resource> findFilters() {
        HashMap<IPath, LinkedList<FilterDescription>> filterMap;
        Project project = (Project)this.getProject();
        ProjectDescription description = project.internalGetDescription();
        ArrayList<Resource> filters = null;
        if (description != null && (filterMap = description.getFilters()) != null) {
            IPath myPath = this.getProjectRelativePath();
            for (IPath filterPath : filterMap.keySet()) {
                if (!myPath.isPrefixOf(filterPath)) continue;
                if (filters == null) {
                    filters = new ArrayList<Resource>();
                }
                filters.add(this.workspace.newResource(project.getFullPath().append(filterPath), 2));
            }
        }
        return filters;
    }

    @Override
    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)target;
        return this.getType() == resource.getType() && this.path.equals(resource.path) && this.workspace.equals(resource.workspace);
    }

    @Override
    public boolean exists() {
        ResourceInfo info = this.getResourceInfo(false, false);
        return this.exists(this.getFlags(info), true);
    }

    public boolean exists(int flags, boolean checkType) {
        return flags != -1 && (!checkType || ResourceInfo.getType(flags) == this.getType());
    }

    public IResource findExistingResourceVariant(IPath target) {
        if (!this.workspace.tree.includesIgnoreCase(target)) {
            return null;
        }
        ResourceInfo info = (ResourceInfo)this.workspace.tree.getElementDataIgnoreCase(target);
        if (info != null && info.isSet(8)) {
            return null;
        }
        IPath result = Path.ROOT;
        int segmentCount = target.segmentCount();
        int i = 0;
        while (i < segmentCount) {
            String[] childNames = this.workspace.tree.getNamesOfChildren(result);
            String name = this.findVariant(target.segment(i), childNames);
            if (name == null) {
                return null;
            }
            result = result.append(name);
            ++i;
        }
        return this.workspace.getRoot().findMember(result);
    }

    @Override
    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        return this.workspace.getMarkerManager().findMarkers(this, type, includeSubtypes, depth);
    }

    private String findVariant(String target, String[] list) {
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (target.toUpperCase().equals(element.toUpperCase())) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getFileExtension() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        if (index == name.length() - 1) {
            return "";
        }
        return name.substring(index + 1);
    }

    public int getFlags(ResourceInfo info) {
        return info == null ? -1 : info.getFlags();
    }

    @Override
    public IPath getFullPath() {
        return this.path;
    }

    public FileSystemResourceManager getLocalManager() {
        return this.workspace.getFileSystemManager();
    }

    @Override
    public IPath getLocation() {
        IProject project = this.getProject();
        if (project != null && !project.exists()) {
            return null;
        }
        return this.getLocalManager().locationFor(this, false);
    }

    @Override
    public URI getLocationURI() {
        IProject project = this.getProject();
        if (project != null && !project.exists()) {
            return null;
        }
        return this.getLocalManager().locationURIFor(this, false);
    }

    protected MarkerManager getMarkerManager() {
        return this.workspace.getMarkerManager();
    }

    @Override
    public long getModificationStamp() {
        ResourceInfo info = this.getResourceInfo(false, false);
        return info == null ? -1L : info.getModificationStamp();
    }

    @Override
    public String getName() {
        return this.path.lastSegment();
    }

    @Override
    public IContainer getParent() {
        int segments = this.path.segmentCount();
        if (segments < 2) {
            Assert.isLegal(false, this.path.toString());
        }
        if (segments == 2) {
            return this.workspace.getRoot().getProject(this.path.segment(0));
        }
        return (IFolder)((Object)this.workspace.newResource(this.path.removeLastSegments(1), 2));
    }

    @Override
    public String getPersistentProperty(QualifiedName key) throws CoreException {
        this.checkAccessibleAndLocal(0);
        return this.getPropertyManager().getProperty(this, key);
    }

    @Override
    public IProject getProject() {
        return this.workspace.getRoot().getProject(this.path.segment(0));
    }

    @Override
    public IPath getProjectRelativePath() {
        return this.getFullPath().removeFirstSegments(1);
    }

    public IPropertyManager getPropertyManager() {
        return this.workspace.getPropertyManager();
    }

    @Override
    public IPath getRawLocation() {
        if (this.isLinked()) {
            return FileUtil.toPath(((Project)this.getProject()).internalGetDescription().getLinkLocationURI(this.getProjectRelativePath()));
        }
        return this.getLocation();
    }

    public URI getRawLocationURI() {
        if (this.isLinked()) {
            return ((Project)this.getProject()).internalGetDescription().getLinkLocationURI(this.getProjectRelativePath());
        }
        return this.getLocationURI();
    }

    @Override
    public ResourceAttributes getResourceAttributes() {
        if (!this.isAccessible() || this.isVirtual()) {
            return null;
        }
        return this.getLocalManager().attributes(this);
    }

    public ResourceInfo getResourceInfo(boolean phantom, boolean mutable) {
        return this.workspace.getResourceInfo(this.getFullPath(), phantom, mutable);
    }

    @Override
    public Object getSessionProperty(QualifiedName key) throws CoreException {
        ResourceInfo info = this.checkAccessibleAndLocal(0);
        return info.getSessionProperty(key);
    }

    public IFileStore getStore() {
        return this.getLocalManager().getStore(this);
    }

    @Override
    public abstract int getType();

    public String getTypeString() {
        switch (this.getType()) {
            case 1: {
                return "L";
            }
            case 2: {
                return "F";
            }
            case 4: {
                return "P";
            }
            case 8: {
                return "R";
            }
        }
        return "";
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public int hashCode() {
        return this.getFullPath().hashCode();
    }

    protected void internalSetLocal(boolean flag, int depth) throws CoreException {
        IResource[] children;
        ResourceInfo info = this.getResourceInfo(true, true);
        if (info.isSet(2) != flag) {
            if (flag && !this.isPhantom(this.getFlags(info))) {
                info.set(2);
                this.workspace.updateModificationStamp(info);
            } else {
                info.clear(2);
                info.clearModificationStamp();
            }
        }
        if (this.getType() == 1 || depth == 0) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] iResourceArray = children = ((IContainer)((Object)this)).members();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            ((Resource)element).internalSetLocal(flag, depth);
            ++n2;
        }
    }

    @Override
    public boolean isAccessible() {
        return this.exists();
    }

    @Override
    public boolean isConflicting(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule.getClass().equals(WorkManager.NotifyRule.class)) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] children;
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] iSchedulingRuleArray = children = multi.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ISchedulingRule element = iSchedulingRuleArray[n2];
                if (this.isConflicting(element)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (!(rule instanceof IResource)) {
            return false;
        }
        IResource resource = (IResource)rule;
        if (!this.workspace.equals(resource.getWorkspace())) {
            return false;
        }
        IPath otherPath = resource.getFullPath();
        return this.path.isPrefixOf(otherPath) || otherPath.isPrefixOf(this.path);
    }

    @Override
    public boolean isDerived() {
        return this.isDerived(0);
    }

    @Override
    public boolean isDerived(int options) {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        if (flags != -1 && ResourceInfo.isSet(flags, 16384)) {
            return true;
        }
        if ((options & 0x200) != 0) {
            return this.getParent().isDerived(options);
        }
        return false;
    }

    @Override
    public boolean isLinked() {
        return this.isLinked(0);
    }

    public boolean isLinked(int options) {
        if ((options & 0x200) != 0) {
            IProject project = this.getProject();
            if (project == null) {
                return false;
            }
            ProjectDescription desc = ((Project)project).internalGetDescription();
            if (desc == null) {
                return false;
            }
            HashMap<IPath, LinkDescription> links = desc.getLinks();
            if (links == null) {
                return false;
            }
            IPath myPath = this.getProjectRelativePath();
            for (LinkDescription linkDescription : links.values()) {
                if (!linkDescription.getProjectRelativePath().isPrefixOf(myPath)) continue;
                return true;
            }
            return false;
        }
        ResourceInfo info = this.getResourceInfo(false, false);
        return info != null && info.isSet(65536);
    }

    @Override
    public boolean isVirtual() {
        ResourceInfo info = this.getResourceInfo(false, false);
        return info != null && info.isSet(524288);
    }

    public boolean isUnderVirtual() {
        IContainer parent = this.getParent();
        while (parent != null) {
            if (parent.isVirtual()) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean isLocal(int depth) {
        ResourceInfo info = this.getResourceInfo(false, false);
        return this.isLocal(this.getFlags(info), depth);
    }

    @Deprecated
    public boolean isLocal(int flags, int depth) {
        return flags != -1 && ResourceInfo.isSet(flags, 2);
    }

    protected boolean isMember(int flags, int memberFlags) {
        int excludeMask = 0;
        if ((memberFlags & 1) == 0) {
            excludeMask |= 8;
        }
        if ((memberFlags & 8) == 0) {
            excludeMask |= 0x200000;
        }
        if ((memberFlags & 2) == 0) {
            excludeMask |= 0x8000;
        }
        if ((memberFlags & 4) != 0) {
            excludeMask |= 0x4000;
        }
        return flags != -1 && (flags & excludeMask) == 0;
    }

    public boolean isPhantom() {
        ResourceInfo info = this.getResourceInfo(true, false);
        return this.isPhantom(this.getFlags(info));
    }

    public boolean isPhantom(int flags) {
        return flags != -1 && ResourceInfo.isSet(flags, 8);
    }

    @Deprecated
    public boolean isReadOnly() {
        ResourceAttributes attributes = this.getResourceAttributes();
        return attributes != null && attributes.isReadOnly();
    }

    @Override
    public boolean isSynchronized(int depth) {
        return this.getLocalManager().isSynchronized(this, depth);
    }

    public boolean isUnderLink() {
        int depth = this.path.segmentCount();
        if (depth < 2) {
            return false;
        }
        if (depth == 2) {
            return this.isLinked();
        }
        IPath linkParent = this.path.removeLastSegments(depth - 2);
        return this.workspace.getResourceInfo(linkParent, false, false).isSet(65536);
    }

    protected IPath makePathAbsolute(IPath target) {
        if (target.isAbsolute()) {
            return target;
        }
        return this.getParent().getFullPath().append(target);
    }

    @Override
    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        boolean isRoot = this.getType() == 8;
        String message = isRoot ? Messages.resources_refreshingRoot : NLS.bind(Messages.resources_refreshing, this.getFullPath());
        SubMonitor progress = SubMonitor.convert(monitor, 100).checkCanceled();
        progress.subTask(message);
        boolean build = false;
        ISchedulingRule rule = this.workspace.getRuleFactory().refreshRule(this);
        try {
            this.workspace.prepareOperation(rule, progress.split(1));
            if (!isRoot && !this.getProject().isAccessible()) {
                return;
            }
            if (!this.exists() && this.isFiltered()) {
                return;
            }
            try {
                this.workspace.beginOperation(true);
                if (this.getType() == 4 || this.getType() == 8) {
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(4096, this));
                }
                build = this.getLocalManager().refresh(this, depth, true, progress.split(98));
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        finally {
            this.workspace.endOperation(rule, build);
        }
    }

    @Override
    public String requestName() {
        return this.getName();
    }

    @Override
    public IPath requestPath() {
        return this.getFullPath();
    }

    @Override
    public void setDerived(boolean isDerived, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind(Messages.resources_settingDerivedFlag, this.getFullPath());
        SubMonitor progress = SubMonitor.convert(monitor, message, 100).checkCanceled();
        ISchedulingRule rule = this.workspace.getRuleFactory().derivedRule(this);
        try {
            this.workspace.prepareOperation(rule, progress.split(1));
            ResourceInfo info = this.getResourceInfo(false, false);
            this.checkAccessible(this.getFlags(info));
            if (info.getType() != 1 && info.getType() != 2) {
                return;
            }
            try {
                this.workspace.beginOperation(true);
                info = this.getResourceInfo(false, true);
                if (isDerived) {
                    info.set(16384);
                } else {
                    info.clear(16384);
                }
                progress.split(98);
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        finally {
            this.workspace.endOperation(rule, true);
        }
    }

    @Override
    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        this.checkAccessibleAndLocal(0);
        this.getPropertyManager().setProperty(this, key, value);
    }

    @Override
    public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
        this.checkAccessibleAndLocal(0);
        this.getLocalManager().setResourceAttributes(this, attributes);
    }

    @Override
    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        ResourceInfo info = this.checkAccessibleAndLocal(0);
        info.setSessionProperty(key, value);
    }

    public boolean synchronizing(ResourceInfo info) {
        return info != null && info.getSyncInfo(false) != null;
    }

    public String toString() {
        return String.valueOf(this.getTypeString()) + this.getFullPath().toString();
    }

    @Override
    public void touch(IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind(Messages.resources_touch, this.getFullPath());
        SubMonitor progress = SubMonitor.convert(monitor, message, 100).checkCanceled();
        ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
        try {
            try {
                this.workspace.prepareOperation(rule, progress.split(1));
                ResourceInfo info = this.checkAccessibleAndLocal(0);
                this.workspace.beginOperation(true);
                info = this.getResourceInfo(false, true);
                info.incrementContentId();
                info.clear(393216);
                this.workspace.updateModificationStamp(info);
                progress.split(98);
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        finally {
            this.workspace.endOperation(rule, true);
        }
    }

    private void unprotectedDelete(ResourceTree tree, int updateFlags, IProgressMonitor monitor) {
        IMoveDeleteHook hook = this.workspace.getMoveDeleteHook();
        SubMonitor progress = SubMonitor.convert(monitor, 2).checkCanceled();
        switch (this.getType()) {
            case 1: {
                if (hook.deleteFile(tree, (IFile)((Object)this), updateFlags, progress.split(1))) break;
                tree.standardDeleteFile((IFile)((Object)this), updateFlags, progress.split(1));
                break;
            }
            case 2: {
                if (hook.deleteFolder(tree, (IFolder)((Object)this), updateFlags, progress.split(1))) break;
                tree.standardDeleteFolder((IFolder)((Object)this), updateFlags, progress.split(1));
                break;
            }
            case 4: {
                if (hook.deleteProject(tree, (IProject)((Object)this), updateFlags, progress.split(1))) break;
                tree.standardDeleteProject((IProject)((Object)this), updateFlags, progress.split(1));
                break;
            }
            case 8: {
                IProject[] projects = ((IWorkspaceRoot)((Object)this)).getProjects(8);
                progress.setWorkRemaining(projects.length * 2);
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (!hook.deleteProject(tree, project, updateFlags, progress.split(1))) {
                        tree.standardDeleteProject(project, updateFlags, progress.split(1));
                    }
                    ++n2;
                }
                break;
            }
        }
    }

    private void broadcastPreDeleteEvent() throws CoreException {
        switch (this.getType()) {
            case 4: {
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(16, this));
                break;
            }
            case 8: {
                IResource[] projects;
                IResource[] iResourceArray = projects = ((Container)this).getChildren(8);
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource project2 = iResourceArray[n2];
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(16, project2));
                    ++n2;
                }
                break;
            }
        }
    }

    @Override
    public IPathVariableManager getPathVariableManager() {
        if (this.getProject() == null) {
            return this.workspace.getPathVariableManager();
        }
        return new ProjectPathVariableManager(this);
    }

    public boolean isFiltered() {
        try {
            return this.isFilteredWithException(false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean isFilteredWithException(boolean throwExeception) throws CoreException {
        if (this.isLinked() || this.isVirtual()) {
            return false;
        }
        Project project = (Project)this.getProject();
        if (project == null) {
            return false;
        }
        ProjectDescription description = project.internalGetDescription();
        if (description == null) {
            return false;
        }
        if (description.getFilters() == null) {
            return false;
        }
        Resource currentResource = this;
        while (currentResource != null && currentResource.getParent() != null) {
            Resource parent = (Resource)((Object)currentResource.getParent());
            IFileStore store = currentResource.getStore();
            if (store != null) {
                IFileInfo[] filtered;
                FileInfo fileInfo = new FileInfo(store.getName());
                fileInfo.setDirectory(currentResource.getType() == 2);
                if (fileInfo != null && (filtered = parent.filterChildren(project, description, new IFileInfo[]{fileInfo}, throwExeception)).length == 0) {
                    return true;
                }
            }
            currentResource = parent;
        }
        return false;
    }

    public IFileInfo[] filterChildren(IFileInfo[] list, boolean throwException) throws CoreException {
        Project project = (Project)this.getProject();
        if (project == null) {
            return list;
        }
        ProjectDescription description = project.internalGetDescription();
        if (description == null) {
            return list;
        }
        return this.filterChildren(project, description, list, throwException);
    }

    private IFileInfo[] filterChildren(Project project, ProjectDescription description, IFileInfo[] list, boolean throwException) throws CoreException {
        block10: {
            IPath relativePath = this.getProjectRelativePath();
            LinkedList<Filter> currentIncludeFilters = new LinkedList<Filter>();
            LinkedList<Filter> currentExcludeFilters = new LinkedList<Filter>();
            LinkedList<FilterDescription> filters = null;
            boolean firstSegment = true;
            do {
                if (!firstSegment) {
                    relativePath = relativePath.removeLastSegments(1);
                }
                if ((filters = description.getFilter(relativePath)) != null) {
                    for (FilterDescription desc : filters) {
                        if (!firstSegment && !desc.isInheritable()) continue;
                        Filter filter = new Filter(project, desc);
                        if (filter.isIncludeOnly()) {
                            if (filter.isFirst()) {
                                currentIncludeFilters.addFirst(filter);
                                continue;
                            }
                            currentIncludeFilters.addLast(filter);
                            continue;
                        }
                        if (filter.isFirst()) {
                            currentExcludeFilters.addFirst(filter);
                            continue;
                        }
                        currentExcludeFilters.addLast(filter);
                    }
                }
                firstSegment = false;
            } while (relativePath.segmentCount() > 0);
            if (currentIncludeFilters.size() > 0 || currentExcludeFilters.size() > 0) {
                try {
                    list = Filter.filter(project, currentIncludeFilters, currentExcludeFilters, (IContainer)((Object)this), list);
                }
                catch (CoreException e) {
                    if (!throwException) break block10;
                    throw e;
                }
            }
        }
        return list;
    }

    public void setLinkLocation(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
        if (!this.isLinked()) {
            String message = NLS.bind(Messages.links_resourceIsNotALink, this.getFullPath());
            throw new ResourceException(77, this.getFullPath(), message, null);
        }
        String message = NLS.bind(Messages.links_setLocation, this.getFullPath());
        SubMonitor progress = SubMonitor.convert(monitor, message, 100).checkCanceled();
        ISchedulingRule rule = this.workspace.getRuleFactory().createRule(this);
        try {
            this.workspace.prepareOperation(rule, progress.split(1));
            this.workspace.broadcastEvent(LifecycleEvent.newEvent(524288, this));
            this.workspace.beginOperation(true);
            ResourceInfo info = this.workspace.getResourceInfo(this.getFullPath(), true, false);
            this.getLocalManager().setLocation(this, info, location);
            LinkDescription linkDescription = new LinkDescription(this, location);
            Project project = (Project)this.getProject();
            project.internalGetDescription().setLinkLocation(this.getProjectRelativePath(), linkDescription);
            project.writeDescription(updateFlags);
            if ((updateFlags & 0x80) != 0) {
                this.workspace.refreshManager.refresh(this);
                progress.split(99);
            } else {
                this.refreshLocal(2, progress.split(98));
            }
        }
        finally {
            this.workspace.endOperation(rule, true);
        }
    }
}

