/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.resources.BuildConfiguration;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ModelObject;
import org.eclipse.core.internal.resources.VariableDescription;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IDynamicReferenceProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ProjectDescription
extends ModelObject
implements IProjectDescription {
    private static final IBuildConfiguration[] EMPTY_BUILD_CONFIG_REFERENCE_ARRAY = new IBuildConfiguration[0];
    private static final ICommand[] EMPTY_COMMAND_ARRAY = new ICommand[0];
    private static final IProject[] EMPTY_PROJECT_ARRAY = new IProject[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static boolean isReading = false;
    protected static boolean isWriting = false;
    protected ICommand[] buildSpec = EMPTY_COMMAND_ARRAY;
    protected String comment = "";
    protected String activeConfiguration = "";
    protected String[] configNames = EMPTY_STRING_ARRAY;
    protected IProject[] staticRefs = EMPTY_PROJECT_ARRAY;
    protected IProject[] dynamicRefs = EMPTY_PROJECT_ARRAY;
    protected HashMap<String, IBuildConfiguration[]> dynamicConfigRefs = new HashMap(1);
    protected volatile IBuildConfiguration[] cachedBuildConfigs;
    protected Map<String, IBuildConfiguration[]> cachedConfigRefs = Collections.synchronizedMap(new HashMap(1));
    protected IProject[] cachedRefs;
    protected int cachedRefsDirtyCount;
    protected final Object cachedRefsMutex = new Object();
    protected HashMap<IPath, LinkDescription> linkDescriptions = null;
    protected HashMap<IPath, LinkedList<FilterDescription>> filterDescriptions = null;
    protected HashMap<String, VariableDescription> variableDescriptions = null;
    protected URI location = null;
    protected String[] natures = EMPTY_STRING_ARRAY;
    protected URI snapshotLocation = null;

    @Override
    public Object clone() {
        ProjectDescription clone = (ProjectDescription)super.clone();
        clone.linkDescriptions = null;
        clone.filterDescriptions = null;
        if (this.variableDescriptions != null) {
            clone.variableDescriptions = (HashMap)this.variableDescriptions.clone();
        }
        clone.buildSpec = this.getBuildSpec(true);
        clone.dynamicConfigRefs = (HashMap)this.dynamicConfigRefs.clone();
        clone.cachedConfigRefs = Collections.synchronizedMap(new HashMap(1));
        clone.clearCachedDynamicReferences(null);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedDynamicReferences(String configName) {
        Object object = this.cachedRefsMutex;
        synchronized (object) {
            if (configName == null) {
                this.cachedConfigRefs.clear();
            } else {
                this.cachedConfigRefs.remove(configName);
            }
            this.cachedRefs = null;
            ++this.cachedRefsDirtyCount;
        }
    }

    private IProject[] copyAndRemoveDuplicates(IProject[] projects) {
        IProject[] result = new IProject[projects.length];
        int count = 0;
        int i = 0;
        while (i < projects.length) {
            block4: {
                IProject project = projects[i];
                int j = 0;
                while (j < count) {
                    if (!project.equals(result[j])) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                result[count++] = project;
            }
            ++i;
        }
        if (count < projects.length) {
            IProject[] reduced = new IProject[count];
            System.arraycopy(result, 0, reduced, 0, count);
            return reduced;
        }
        return result;
    }

    private Collection<BuildConfiguration> getBuildConfigReferencesFromProjects(IProject[] projects) {
        ArrayList<BuildConfiguration> refs = new ArrayList<BuildConfiguration>(projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            refs.add(new BuildConfiguration(project, null));
            ++n2;
        }
        return refs;
    }

    public String getActiveBuildConfig() {
        return this.activeConfiguration;
    }

    public IBuildConfiguration[] getAllBuildConfigReferences(IProject project, String configName, boolean makeCopy) {
        if (!this.hasBuildConfig(configName)) {
            return EMPTY_BUILD_CONFIG_REFERENCE_ARRAY;
        }
        IBuildConfiguration[] refs = this.cachedConfigRefs.get(configName);
        if (refs == null) {
            Collection<Object> dynamic;
            LinkedHashSet<IBuildConfiguration> references = new LinkedHashSet<IBuildConfiguration>();
            IBuildConfiguration[] dynamicBuildConfigs = this.dynamicConfigRefs.containsKey(configName) ? this.dynamicConfigRefs.get(configName) : EMPTY_BUILD_CONFIG_REFERENCE_ARRAY;
            try {
                IBuildConfiguration buildConfig = project.getBuildConfig(configName);
                dynamic = this.getBuildConfigReferencesFromProjects(ProjectDescription.computeDynamicReferencesForProject(buildConfig, this.getBuildSpec()));
            }
            catch (CoreException coreException) {
                dynamic = Collections.emptyList();
            }
            Collection<BuildConfiguration> legacyDynamic = this.getBuildConfigReferencesFromProjects(this.dynamicRefs);
            Collection<BuildConfiguration> statik = this.getBuildConfigReferencesFromProjects(this.staticRefs);
            references.addAll(Arrays.asList(dynamicBuildConfigs));
            references.addAll(statik);
            references.addAll(legacyDynamic);
            references.addAll(dynamic);
            refs = references.toArray(new IBuildConfiguration[references.size()]);
            this.cachedConfigRefs.put(configName, refs);
        }
        return makeCopy ? (IBuildConfiguration[])refs.clone() : refs;
    }

    public IBuildConfiguration[] getBuildConfigs(IProject project, boolean makeCopy) {
        IBuildConfiguration[] configs = this.cachedBuildConfigs;
        if (configs != null && !project.equals(configs[0].getProject())) {
            configs = null;
        }
        if (configs == null) {
            if (this.configNames.length == 0) {
                configs = new IBuildConfiguration[]{new BuildConfiguration(project)};
            } else {
                configs = new IBuildConfiguration[this.configNames.length];
                int i = 0;
                while (i < configs.length) {
                    configs[i] = new BuildConfiguration(project, this.configNames[i]);
                    ++i;
                }
            }
            this.cachedBuildConfigs = configs;
        }
        return makeCopy ? (IBuildConfiguration[])configs.clone() : configs;
    }

    public Map<String, IBuildConfiguration[]> getBuildConfigReferences(boolean makeCopy) {
        return makeCopy ? (Map)this.dynamicConfigRefs.clone() : this.dynamicConfigRefs;
    }

    @Override
    public ICommand[] getBuildSpec() {
        return this.getBuildSpec(true);
    }

    public ICommand[] getBuildSpec(boolean makeCopy) {
        ICommand[] oldCommands = this.buildSpec;
        if (oldCommands == null) {
            return EMPTY_COMMAND_ARRAY;
        }
        if (!makeCopy) {
            return oldCommands;
        }
        ICommand[] result = new ICommand[oldCommands.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (ICommand)((BuildCommand)oldCommands[i]).clone();
            ++i;
        }
        return result;
    }

    public String getComment() {
        return this.comment;
    }

    public IProject[] getDynamicReferences(boolean makeCopy) {
        return makeCopy ? (IProject[])this.dynamicRefs.clone() : this.dynamicRefs;
    }

    public URI getLinkLocationURI(IPath aPath) {
        if (this.linkDescriptions == null) {
            return null;
        }
        LinkDescription desc = this.linkDescriptions.get(aPath);
        return desc == null ? null : desc.getLocationURI();
    }

    public synchronized LinkedList<FilterDescription> getFilter(IPath aPath) {
        if (this.filterDescriptions == null) {
            return null;
        }
        return this.filterDescriptions.get(aPath);
    }

    public HashMap<IPath, LinkDescription> getLinks() {
        return this.linkDescriptions;
    }

    public HashMap<IPath, LinkedList<FilterDescription>> getFilters() {
        return this.filterDescriptions;
    }

    public HashMap<String, VariableDescription> getVariables() {
        return this.variableDescriptions;
    }

    @Deprecated
    public IPath getLocation() {
        if (this.location == null) {
            return null;
        }
        return FileUtil.toPath(this.location);
    }

    @Override
    public URI getLocationURI() {
        return this.location;
    }

    @Override
    public String[] getNatureIds() {
        return this.getNatureIds(true);
    }

    public String[] getNatureIds(boolean makeCopy) {
        if (this.natures == null) {
            return EMPTY_STRING_ARRAY;
        }
        return makeCopy ? (String[])this.natures.clone() : this.natures;
    }

    public IProject[] getReferencedProjects() {
        return this.getReferencedProjects(true);
    }

    public IProject[] getReferencedProjects(boolean makeCopy) {
        if (this.staticRefs == null) {
            return EMPTY_PROJECT_ARRAY;
        }
        return makeCopy ? (IProject[])this.staticRefs.clone() : this.staticRefs;
    }

    public URI getSnapshotLocationURI() {
        return this.snapshotLocation;
    }

    @Override
    public boolean hasNature(String natureID) {
        String[] natureIDs;
        String[] stringArray = natureIDs = this.getNatureIds(false);
        int n = natureIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String natureID2 = stringArray[n2];
            if (natureID2.equals(natureID)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean configRefsHaveChanges(Map<String, IBuildConfiguration[]> m1, Map<String, IBuildConfiguration[]> m2) {
        if (m1.size() != m2.size()) {
            return true;
        }
        for (Map.Entry<String, IBuildConfiguration[]> e : m1.entrySet()) {
            if (!m2.containsKey(e.getKey())) {
                return true;
            }
            if (Arrays.equals(e.getValue(), m2.get(e.getKey()))) continue;
            return true;
        }
        return false;
    }

    boolean hasBuildConfig(String buildConfigName) {
        Assert.isNotNull(buildConfigName);
        if (this.configNames.length == 0) {
            return "".equals(buildConfigName);
        }
        String[] stringArray = this.configNames;
        int n = this.configNames.length;
        int n2 = 0;
        while (n2 < n) {
            String configName = stringArray[n2];
            if (configName.equals(buildConfigName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasPrivateChanges(ProjectDescription description) {
        if (this.location == null ? description.location != null : !this.location.equals(description.location)) {
            return true;
        }
        if (!Arrays.equals(this.dynamicRefs, description.dynamicRefs)) {
            return true;
        }
        if (!this.activeConfiguration.equals(description.activeConfiguration)) {
            return true;
        }
        if (!Arrays.equals(this.configNames, description.configNames)) {
            return true;
        }
        return ProjectDescription.configRefsHaveChanges(this.dynamicConfigRefs, description.dynamicConfigRefs);
    }

    public boolean hasPublicChanges(ProjectDescription description) {
        if (!this.getName().equals(description.getName())) {
            return true;
        }
        if (!this.comment.equals(description.getComment())) {
            return true;
        }
        if (!Arrays.equals(this.buildSpec, description.getBuildSpec(false))) {
            return true;
        }
        if (!Arrays.equals(this.staticRefs, description.getReferencedProjects(false))) {
            return true;
        }
        if (!Arrays.equals(this.natures, description.getNatureIds(false))) {
            return true;
        }
        HashMap<IPath, LinkedList<FilterDescription>> otherFilters = description.getFilters();
        if (this.filterDescriptions == null && otherFilters != null) {
            return otherFilters != null;
        }
        if (this.filterDescriptions != null && !this.filterDescriptions.equals(otherFilters)) {
            return true;
        }
        HashMap<String, VariableDescription> otherVariables = description.getVariables();
        if (this.variableDescriptions == null && otherVariables != null) {
            return true;
        }
        if (this.variableDescriptions != null && !this.variableDescriptions.equals(otherVariables)) {
            return true;
        }
        HashMap<IPath, LinkDescription> otherLinks = description.getLinks();
        if (!(this.linkDescriptions == otherLinks || this.linkDescriptions != null && this.linkDescriptions.equals(otherLinks))) {
            return true;
        }
        URI otherSnapshotLoc = description.getSnapshotLocationURI();
        return this.snapshotLocation != otherSnapshotLoc && (this.snapshotLocation == null || !this.snapshotLocation.equals(otherSnapshotLoc));
    }

    @Override
    public ICommand newCommand() {
        return new BuildCommand();
    }

    public void setActiveBuildConfig(String configName) {
        Assert.isNotNull(configName);
        if (!configName.equals(this.activeConfiguration)) {
            this.clearCachedDynamicReferences(null);
        }
        this.activeConfiguration = configName;
    }

    @Override
    public void setBuildSpec(ICommand[] value) {
        Assert.isLegal(value != null);
        ICommand[] result = new ICommand[value.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (ICommand)((BuildCommand)value[i]).clone();
            ICommand[] iCommandArray = this.buildSpec;
            int n = this.buildSpec.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand element = iCommandArray[n2];
                if (result[i].equals(element)) {
                    ((BuildCommand)result[i]).setBuilders(((BuildCommand)element).getBuilders());
                    break;
                }
                ++n2;
            }
            ++i;
        }
        this.buildSpec = result;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    @Deprecated
    public void setDynamicReferences(IProject[] value) {
        Assert.isLegal(value != null);
        this.dynamicRefs = this.copyAndRemoveDuplicates(value);
        this.clearCachedDynamicReferences(null);
    }

    public void setBuildConfigReferences(HashMap<String, IBuildConfiguration[]> refs) {
        this.dynamicConfigRefs = new HashMap<String, IBuildConfiguration[]>(refs);
        this.clearCachedDynamicReferences(null);
    }

    public void setBuildConfigs(String[] names) {
        LinkedHashSet<String> buildConfigNames = new LinkedHashSet<String>();
        if (names == null || names.length == 0) {
            this.configNames = EMPTY_STRING_ARRAY;
            buildConfigNames.add("");
        } else {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                Assert.isLegal(n3 != null);
                buildConfigNames.add(n3);
                ++n2;
            }
            this.configNames = buildConfigNames.size() == 1 && ((String)buildConfigNames.iterator().next()).equals("") ? EMPTY_STRING_ARRAY : buildConfigNames.toArray(new String[buildConfigNames.size()]);
        }
        boolean modified = this.dynamicConfigRefs.keySet().retainAll(buildConfigNames);
        if (modified) {
            this.clearCachedDynamicReferences(null);
        }
        this.cachedBuildConfigs = null;
    }

    public void setLinkDescriptions(HashMap<IPath, LinkDescription> linkDescriptions) {
        this.linkDescriptions = linkDescriptions;
    }

    public void setFilterDescriptions(HashMap<IPath, LinkedList<FilterDescription>> filterDescriptions) {
        this.filterDescriptions = filterDescriptions;
    }

    public void setVariableDescriptions(HashMap<String, VariableDescription> variableDescriptions) {
        this.variableDescriptions = variableDescriptions;
    }

    public boolean setLinkLocation(IPath path, LinkDescription description) {
        HashMap<IPath, LinkDescription> tempMap = this.linkDescriptions;
        if (description != null) {
            LinkDescription oldValue = (tempMap = tempMap == null ? new HashMap<IPath, LinkDescription>(10) : (HashMap<IPath, LinkDescription>)tempMap.clone()).put(path, description);
            if (oldValue != null && description.equals(oldValue)) {
                return false;
            }
            this.linkDescriptions = tempMap;
        } else {
            if (tempMap == null) {
                return false;
            }
            HashMap newMap = (HashMap)tempMap.clone();
            Object oldValue = newMap.remove(path);
            if (oldValue == null) {
                return false;
            }
            this.linkDescriptions = newMap.size() == 0 ? null : newMap;
        }
        return true;
    }

    public boolean setVariableDescription(String name, VariableDescription description) {
        HashMap<String, VariableDescription> tempMap = this.variableDescriptions;
        if (description != null) {
            VariableDescription oldValue = (tempMap = tempMap == null ? new HashMap<String, VariableDescription>(10) : (HashMap<String, VariableDescription>)tempMap.clone()).put(name, description);
            if (oldValue != null && description.equals(oldValue)) {
                return false;
            }
            this.variableDescriptions = tempMap;
        } else {
            if (tempMap == null) {
                return false;
            }
            HashMap newMap = (HashMap)tempMap.clone();
            Object oldValue = newMap.remove(name);
            if (oldValue == null) {
                return false;
            }
            this.variableDescriptions = newMap.size() == 0 ? null : newMap;
        }
        return true;
    }

    public synchronized boolean setFilters(IPath path, LinkedList<FilterDescription> descriptions) {
        if (descriptions != null) {
            LinkedList<FilterDescription> oldValue;
            if (this.filterDescriptions == null) {
                this.filterDescriptions = new HashMap(10);
            }
            if ((oldValue = this.filterDescriptions.put(path, descriptions)) != null && descriptions.equals(oldValue)) {
                return false;
            }
        } else {
            if (this.filterDescriptions == null) {
                return false;
            }
            LinkedList<FilterDescription> oldValue = this.filterDescriptions.remove(path);
            if (oldValue == null) {
                return false;
            }
            if (this.filterDescriptions.size() == 0) {
                this.filterDescriptions = null;
            }
        }
        return true;
    }

    @Override
    public void setLocation(IPath path) {
        this.location = path == null ? null : URIUtil.toURI(path);
    }

    public void setLocationURI(URI location) {
        this.location = location;
    }

    @Override
    public void setName(String value) {
        super.setName(value);
    }

    public void setNatureIds(String[] value) {
        this.natures = (String[])value.clone();
    }

    public void setReferencedProjects(IProject[] value) {
        Assert.isLegal(value != null);
        this.staticRefs = this.copyAndRemoveDuplicates(value);
        this.clearCachedDynamicReferences(null);
    }

    public void setSnapshotLocationURI(URI snapshotLocation) {
        this.snapshotLocation = snapshotLocation;
    }

    public URI getGroupLocationURI(IPath projectRelativePath) {
        return LinkDescription.VIRTUAL_LOCATION;
    }

    public boolean updateDynamicState(ProjectDescription description) {
        boolean changed = false;
        if (!this.activeConfiguration.equals(description.activeConfiguration)) {
            changed = true;
            this.activeConfiguration = description.activeConfiguration;
        }
        if (!Arrays.equals(this.dynamicRefs, description.dynamicRefs)) {
            changed = true;
            this.setDynamicReferences(description.dynamicRefs);
        }
        if (!Arrays.equals(this.configNames, description.configNames)) {
            changed = true;
            this.setBuildConfigs(description.configNames);
        }
        if (ProjectDescription.configRefsHaveChanges(this.dynamicConfigRefs, description.dynamicConfigRefs)) {
            changed = true;
            this.dynamicConfigRefs = new HashMap<String, IBuildConfiguration[]>(description.dynamicConfigRefs);
        }
        if (changed) {
            this.clearCachedDynamicReferences(null);
        }
        return changed;
    }

    private static IProject[] computeDynamicReferencesForProject(IBuildConfiguration buildConfig, ICommand[] buildSpec) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        ICommand[] iCommandArray = buildSpec;
        int n = buildSpec.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurationElements;
            ICommand command = iCommandArray[n2];
            IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "builders", command.getBuilderName());
            if (extension != null && (configurationElements = extension.getConfigurationElements()).length != 0) {
                IConfigurationElement element = configurationElements[0];
                try {
                    Object executableExtension;
                    IConfigurationElement[] children = element.getChildren("dynamicReference");
                    if (children.length != 0 && (executableExtension = children[0].createExecutableExtension("class")) instanceof IDynamicReferenceProvider) {
                        IDynamicReferenceProvider provider = (IDynamicReferenceProvider)executableExtension;
                        result.addAll(provider.getDependentProjects(buildConfig));
                    }
                }
                catch (CoreException e) {
                    String problemElement = element.toString();
                    ResourcesPlugin.getPlugin().getLog().log(new Status(4, "org.eclipse.core.resources", "Unable to load dynamic reference provider: " + problemElement, e));
                }
            }
            ++n2;
        }
        return result.toArray(new IProject[0]);
    }
}

