/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ProjectPreferences;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.BitMask;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class File
extends Resource
implements IFile {
    protected File(IPath path, Workspace container) {
        super(path, container);
    }

    public IFolder changeToFolder() throws CoreException {
        this.getPropertyManager().deleteProperties(this, 0);
        IFolder result = this.workspace.getRoot().getFolder(this.path);
        if (this.isLinked()) {
            IPath location = this.getRawLocation();
            this.delete(0, null);
            result.createLink(location, 16, null);
        } else {
            this.workspace.deleteResource(this);
            this.workspace.createResource((IResource)result, false);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void create(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        boolean monitorNull = monitor == null;
        monitor = Policy.monitorFor(monitor);
        try {
            String message = monitorNull ? "" : NLS.bind(Messages.resources_creating, this.getFullPath());
            monitor.beginTask(message, 100);
            this.checkValidPath(this.path, 1, true);
            ISchedulingRule rule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    boolean local;
                    this.workspace.prepareOperation(rule, monitor);
                    this.checkDoesNotExist();
                    Container parent = (Container)this.getParent();
                    ResourceInfo info = parent.getResourceInfo(false, false);
                    parent.checkAccessible(this.getFlags(info));
                    this.checkValidGroupContainer(parent, false, false);
                    this.workspace.beginOperation(true);
                    IFileStore store = this.getStore();
                    IFileInfo localInfo = store.fetchInfo();
                    if (BitMask.isSet(updateFlags, 1)) {
                        if (!Workspace.caseSensitive && localInfo.exists()) {
                            String name = this.getLocalManager().getLocalName(store);
                            if (name != null && !localInfo.getName().equals(name)) {
                                message = NLS.bind(Messages.resources_existsLocalDifferentCase, new Path(store.toString()).removeLastSegments(1).append(name).toOSString());
                                throw new ResourceException(275, this.getFullPath(), message, null);
                            }
                            this.delete(true, null);
                        }
                    } else if (localInfo.exists()) {
                        String name;
                        if (!Workspace.caseSensitive && (name = this.getLocalManager().getLocalName(store)) != null && !localInfo.getName().equals(name)) {
                            message = NLS.bind(Messages.resources_existsLocalDifferentCase, new Path(store.toString()).removeLastSegments(1).append(name).toOSString());
                            throw new ResourceException(275, this.getFullPath(), message, null);
                        }
                        message = NLS.bind(Messages.resources_fileExists, store.toString());
                        throw new ResourceException(272, this.getFullPath(), message, null);
                    }
                    monitor.worked(Policy.opWork * 40 / 100);
                    info = this.workspace.createResource((IResource)this, updateFlags);
                    boolean bl = local = content != null;
                    if (local) {
                        try {
                            this.internalSetContents(content, localInfo, updateFlags, false, Policy.subMonitorFor(monitor, Policy.opWork * 60 / 100));
                        }
                        catch (CoreException e) {
                            this.workspace.deleteResource(this);
                            store.delete(0, null);
                            throw e;
                        }
                        catch (OperationCanceledException e) {
                            this.workspace.deleteResource(this);
                            store.delete(0, null);
                            throw e;
                        }
                    }
                    this.internalSetLocal(local, 0);
                    if (local) return;
                    this.getResourceInfo(true, true).clearModificationStamp();
                    return;
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            finally {
                this.workspace.endOperation(rule, true);
            }
        }
        finally {
            monitor.done();
            FileUtil.safeClose(content);
        }
    }

    @Override
    public String getCharset() throws CoreException {
        return this.getCharset(true);
    }

    @Override
    public String getCharset(boolean checkImplicit) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        if (!this.exists(flags, false)) {
            return checkImplicit ? this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true) : null;
        }
        this.checkLocal(flags, 0);
        try {
            return this.internalGetCharset(checkImplicit, info);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 368) {
                return checkImplicit ? this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true) : null;
            }
            throw e;
        }
    }

    private String internalGetCharset(boolean checkImplicit, ResourceInfo info) throws CoreException {
        String contentCharset;
        String charset = this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), false);
        if (charset != null || !checkImplicit) {
            return charset;
        }
        IContentDescription description = this.workspace.getContentDescriptionManager().getDescriptionFor(this, info, true);
        if (description != null && (contentCharset = description.getCharset()) != null) {
            return contentCharset;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true);
    }

    @Override
    public InputStream getContents() throws CoreException {
        return this.getContents(this.getLocalManager().isLightweightAutoRefreshEnabled());
    }

    @Override
    public InputStream getContents(boolean force) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getLocalManager().read(this, force, null);
    }

    @Override
    public int getType() {
        return 1;
    }

    protected void internalSetContents(InputStream content, IFileInfo fileInfo, int updateFlags, boolean append, IProgressMonitor monitor) throws CoreException {
        if (content == null) {
            content = new ByteArrayInputStream(new byte[0]);
        }
        this.getLocalManager().write(this, content, fileInfo, updateFlags, append, monitor);
        this.updateMetadataFiles();
        this.workspace.getAliasManager().updateAliases(this, this.getStore(), 0, monitor);
    }

    @Override
    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        if (!this.getLocalManager().fastIsSynchronized(this)) {
            super.refreshLocal(0, monitor);
        }
    }

    @Override
    public void setContents(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = NLS.bind(Messages.resources_settingContents, this.getFullPath());
            monitor.beginTask(message, 100);
            if (this.workspace.shouldValidate) {
                this.workspace.validateSave(this);
            }
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    ResourceInfo info = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    IFileInfo fileInfo = this.getStore().fetchInfo();
                    this.internalSetContents(content, fileInfo, updateFlags, false, Policy.subMonitorFor(monitor, Policy.opWork));
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            finally {
                this.workspace.endOperation(rule, true);
            }
        }
        finally {
            monitor.done();
            FileUtil.safeClose(content);
        }
    }

    public void updateMetadataFiles() throws CoreException {
        int count = this.path.segmentCount();
        String name = this.path.segment(1);
        if (count == 2 && name.equals(".project")) {
            Project project = (Project)this.getProject();
            project.updateDescription();
            ProjectInfo projectInfo = (ProjectInfo)project.getResourceInfo(false, true);
            projectInfo.discardNatures();
            return;
        }
        if (count == 3 && ".settings".equals(name)) {
            ProjectPreferences.updatePreferences(this);
            return;
        }
    }

    @Override
    public void setContents(InputStream content, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.setContents(content, updateFlags |= keepHistory ? 2 : 0, monitor);
    }
}

