/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.LinkedList;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public abstract class Container
extends Resource
implements IContainer {
    protected Container(IPath path, Workspace container) {
        super(path, container);
    }

    @Override
    public void convertToPhantom() throws CoreException {
        IResource[] members;
        if (this.isPhantom()) {
            return;
        }
        super.convertToPhantom();
        IResource[] iResourceArray = members = this.members(11);
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            ((Resource)member).convertToPhantom();
            ++n2;
        }
    }

    @Override
    public boolean exists(IPath childPath) {
        return this.workspace.getResourceInfo(this.getFullPath().append(childPath), false, false) != null;
    }

    @Override
    public IResource findMember(String memberPath) {
        return this.findMember(memberPath, false);
    }

    public IResource findMember(String memberPath, boolean phantom) {
        IPath childPath = this.getFullPath().append(memberPath);
        ResourceInfo info = this.workspace.getResourceInfo(childPath, phantom, false);
        return info == null ? null : this.workspace.newResource(childPath, info.getType());
    }

    @Override
    public IResource findMember(IPath childPath) {
        return this.findMember(childPath, false);
    }

    @Override
    public IResource findMember(IPath childPath, boolean phantom) {
        childPath = this.getFullPath().append(childPath);
        ResourceInfo info = this.workspace.getResourceInfo(childPath, phantom, false);
        return info == null ? null : this.workspace.newResource(childPath, info.getType());
    }

    protected IResource[] getChildren(int memberFlags) {
        IPath[] children = null;
        try {
            children = this.workspace.tree.getChildren(this.path);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (children == null || children.length == 0) {
            return ICoreConstants.EMPTY_RESOURCE_ARRAY;
        }
        IResource[] result = new Resource[children.length];
        int found = 0;
        IPath[] iPathArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPath child = iPathArray[n2];
            ResourceInfo info = this.workspace.getResourceInfo(child, true, false);
            if (info != null && this.isMember(info.getFlags(), memberFlags)) {
                result[found++] = this.workspace.newResource(child, info.getType());
            }
            ++n2;
        }
        if (found == result.length) {
            return result;
        }
        IResource[] trimmedResult = new Resource[found];
        System.arraycopy(result, 0, trimmedResult, 0, found);
        return trimmedResult;
    }

    public IFile getFile(String name) {
        return (IFile)((Object)this.workspace.newResource(this.getFullPath().append(name), 1));
    }

    public boolean hasFilters() {
        IProject project = this.getProject();
        if (project == null) {
            return false;
        }
        ProjectDescription desc = ((Project)project).internalGetDescription();
        if (desc == null) {
            return false;
        }
        LinkedList<FilterDescription> filters = desc.getFilter(this.getProjectRelativePath());
        return filters != null && filters.size() > 0;
    }

    @Override
    public IFile getFile(IPath childPath) {
        return (IFile)((Object)this.workspace.newResource(this.getFullPath().append(childPath), 1));
    }

    public IFolder getFolder(String name) {
        return (IFolder)((Object)this.workspace.newResource(this.getFullPath().append(name), 2));
    }

    @Override
    public IFolder getFolder(IPath childPath) {
        return (IFolder)((Object)this.workspace.newResource(this.getFullPath().append(childPath), 2));
    }

    @Override
    @Deprecated
    public boolean isLocal(int flags, int depth) {
        if (!super.isLocal(flags, depth)) {
            return false;
        }
        if (depth == 0) {
            return true;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = this.getChildren(0);
        int i = 0;
        while (i < children.length) {
            if (!children[i].isLocal(depth)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public IResource[] members() throws CoreException {
        return this.members(0);
    }

    @Override
    public IResource[] members(int memberFlags) throws CoreException {
        boolean phantom = (memberFlags & 1) != 0;
        ResourceInfo info = this.getResourceInfo(phantom, false);
        this.checkAccessible(this.getFlags(info));
        if (info.isSet(0x100000)) {
            this.workspace.refreshManager.refresh(this);
        }
        return this.getChildren(memberFlags);
    }

    @Override
    public String getDefaultCharset() throws CoreException {
        return this.getDefaultCharset(true);
    }
}

