/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.refresh.MonitorJob;
import org.eclipse.core.internal.refresh.PollingMonitor;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IPathVariableChangeEvent;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.RefreshProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

class MonitorManager
implements ILifecycleListener,
IPathVariableChangeListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    protected final PollingMonitor pollMonitor;
    private RefreshProvider[] providers;
    protected final RefreshManager refreshManager;
    protected final Map<IRefreshMonitor, List<IResource>> registeredMonitors;
    protected IWorkspace workspace;

    public MonitorManager(IWorkspace workspace, RefreshManager refreshManager) {
        this.workspace = workspace;
        this.refreshManager = refreshManager;
        this.registeredMonitors = Collections.synchronizedMap(new HashMap(10));
        this.pollMonitor = new PollingMonitor(refreshManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefreshProvider[] getRefreshProviders() {
        MonitorManager monitorManager = this;
        synchronized (monitorManager) {
            if (this.providers != null) {
                return this.providers;
            }
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "refreshProviders");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        ArrayList<RefreshProvider> providerList = new ArrayList<RefreshProvider>(infos.length);
        IConfigurationElement[] iConfigurationElementArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            RefreshProvider provider = null;
            try {
                provider = (RefreshProvider)configurationElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Policy.log(2, Messages.refresh_installError, e);
            }
            if (provider != null) {
                providerList.add(provider);
            }
            ++n2;
        }
        MonitorManager monitorManager2 = this;
        synchronized (monitorManager2) {
            this.providers = providerList.toArray(new RefreshProvider[providerList.size()]);
            return this.providers;
        }
    }

    private List<IResource> getResourcesToMonitor() {
        ArrayList<IResource> resourcesToMonitor = new ArrayList<IResource>(10);
        IProject[] projects = this.workspace.getRoot().getProjects(8);
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                resourcesToMonitor.add(projects[i]);
                try {
                    IResource[] members;
                    IResource[] iResourceArray = members = projects[i].members();
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        if (member.isLinked()) {
                            resourcesToMonitor.add(member);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Policy.log(2, Messages.refresh_refreshErr, e);
                }
            }
            ++i;
        }
        return resourcesToMonitor;
    }

    @Override
    public void handleEvent(LifecycleEvent event) {
        switch (event.kind) {
            case 1: 
            case 16: 
            case 1024: {
                this.unmonitor(event.resource, new NullProgressMonitor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMonitoring(IResource resource) {
        Map<IRefreshMonitor, List<IResource>> map = this.registeredMonitors;
        synchronized (map) {
            List<IResource> resources;
            Iterator<List<IResource>> iterator = this.registeredMonitors.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((resources = iterator.next()) == null || !resources.contains(resource));
            return true;
        }
    }

    boolean monitor(IResource resource, IProgressMonitor progressMonitor) {
        if (this.isMonitoring(resource)) {
            return false;
        }
        boolean pollingMonitorNeeded = true;
        RefreshProvider[] refreshProviders = this.getRefreshProviders();
        SubMonitor subMonitor = SubMonitor.convert(progressMonitor, refreshProviders.length);
        RefreshProvider[] refreshProviderArray = refreshProviders;
        int n = refreshProviders.length;
        int n2 = 0;
        while (n2 < n) {
            RefreshProvider refreshProvider = refreshProviderArray[n2];
            IRefreshMonitor monitor = this.safeInstallMonitor(refreshProvider, resource, subMonitor.split(1));
            if (monitor != null) {
                this.registerMonitor(monitor, resource);
                pollingMonitorNeeded = false;
            }
            ++n2;
        }
        if (pollingMonitorNeeded) {
            this.pollMonitor.monitor(resource);
            this.registerMonitor(this.pollMonitor, resource);
        }
        return pollingMonitorNeeded;
    }

    @Override
    public void pathVariableChanged(IPathVariableChangeEvent event) {
        if (this.registeredMonitors.isEmpty()) {
            return;
        }
        String variableName = event.getVariableName();
        HashSet<IResource> invalidResources = new HashSet<IResource>();
        for (List<IResource> resources : this.registeredMonitors.values()) {
            for (IResource resource : resources) {
                IPath rawLocation = resource.getRawLocation();
                if (rawLocation == null || rawLocation.segmentCount() <= 0 || !variableName.equals(rawLocation.segment(0)) || invalidResources.contains(resource)) continue;
                invalidResources.add(resource);
            }
        }
        if (!invalidResources.isEmpty()) {
            MonitorJob.createSystem(Messages.refresh_restoreOnInvalid, invalidResources, monitor -> {
                SubMonitor subMonitor = SubMonitor.convert(monitor, invalidResources.size() * 2);
                for (IResource resource : invalidResources) {
                    this.unmonitor(resource, subMonitor.split(1));
                    this.monitor(resource, subMonitor.split(1));
                    this.refreshManager.refresh(resource);
                }
            }).schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMonitor(IRefreshMonitor monitor, IResource resource) {
        Map<IRefreshMonitor, List<IResource>> map = this.registeredMonitors;
        synchronized (map) {
            List<IResource> resources = this.registeredMonitors.get(monitor);
            if (resources == null) {
                resources = new ArrayList<IResource>(1);
                this.registeredMonitors.put(monitor, resources);
            }
            if (!resources.contains(resource)) {
                resources.add(resource);
            }
        }
        if (Policy.DEBUG_AUTO_REFRESH) {
            Policy.debug("Auto-refresh:  added monitor (" + monitor + ") on resource: " + resource);
        }
    }

    private IRefreshMonitor safeInstallMonitor(RefreshProvider provider, IResource resource, IProgressMonitor progressMonitor) {
        Throwable t = null;
        try {
            return provider.installMonitor(resource, this.refreshManager, progressMonitor);
        }
        catch (Exception | LinkageError e) {
            t = e;
            Status error = new Status(4, "org.eclipse.core.resources", 1, Messages.refresh_installError, t);
            Policy.log(error);
            return null;
        }
    }

    public void start(IProgressMonitor progressMonitor) {
        List<IResource> resourcesToMonitor = this.getResourcesToMonitor();
        SubMonitor subMonitor = SubMonitor.convert(progressMonitor, resourcesToMonitor.size() + 1);
        boolean refreshNeeded = false;
        for (IResource resource : resourcesToMonitor) {
            refreshNeeded |= !this.monitor(resource, subMonitor.split(1));
        }
        this.workspace.getPathVariableManager().addChangeListener(this);
        this.workspace.addResourceChangeListener(this, 1);
        ((Workspace)this.workspace).addLifecycleListener(this);
        if (Policy.DEBUG_AUTO_REFRESH) {
            Policy.debug("Auto-refresh:  starting monitor manager.");
        }
        subMonitor.split(1);
        if (refreshNeeded) {
            new PollingMonitor(this.refreshManager).runOnce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.workspace.removeResourceChangeListener(this);
        this.workspace.getPathVariableManager().removeChangeListener(this);
        Map<IRefreshMonitor, List<IResource>> map = this.registeredMonitors;
        synchronized (map) {
            for (IRefreshMonitor monitor : this.registeredMonitors.keySet()) {
                monitor.unmonitor(null);
            }
        }
        this.registeredMonitors.clear();
        if (Policy.DEBUG_AUTO_REFRESH) {
            Policy.debug("Auto-refresh:  stopping monitor manager.");
        }
        this.pollMonitor.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmonitor(IResource resource, IProgressMonitor progressMonitor) {
        if (resource == null || !this.isMonitoring(resource)) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert(progressMonitor, 100);
        Map<IRefreshMonitor, List<IResource>> map = this.registeredMonitors;
        synchronized (map) {
            SubMonitor loopMonitor = subMonitor.split(90).setWorkRemaining(this.registeredMonitors.entrySet().size());
            for (Map.Entry<IRefreshMonitor, List<IResource>> entry : this.registeredMonitors.entrySet()) {
                loopMonitor.worked(1);
                List<IResource> resources = entry.getValue();
                if (resources == null || !resources.contains(resource)) continue;
                entry.getKey().unmonitor(resource);
                resources.remove(resource);
            }
        }
        if (resource.getType() == 4) {
            this.unmonitorLinkedContents((IProject)resource, subMonitor.split(10));
        }
    }

    private void unmonitorLinkedContents(IProject project, IProgressMonitor progressMonitor) {
        if (!project.isAccessible()) {
            return;
        }
        IResource[] children = null;
        try {
            children = project.members();
        }
        catch (CoreException e) {
            Policy.log(2, Messages.refresh_refreshErr, e);
        }
        if (children != null && children.length > 0) {
            SubMonitor subMonitor = SubMonitor.convert(progressMonitor, children.length);
            IResource[] iResourceArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (child.isLinked()) {
                    this.unmonitor(child, subMonitor.split(1));
                }
                ++n2;
            }
        }
    }

    @Override
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        try {
            delta.accept(this);
        }
        catch (CoreException coreException) {}
    }

    @Override
    public boolean visit(IResourceDelta delta) {
        IProject project;
        IResource resource;
        if (delta.getKind() == 1 && (resource = delta.getResource()).isLinked()) {
            this.monitor(resource, new NullProgressMonitor());
        }
        if ((delta.getFlags() & 0x4000) != 0 && (project = (IProject)delta.getResource()).isAccessible()) {
            this.monitor(project, new NullProgressMonitor());
        }
        return true;
    }
}

