/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.internal.filesystem.Activator;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.osgi.util.NLS;

abstract class LocalFileNatives {
    private static boolean hasNatives;
    private static boolean isUnicode;
    private static int nativeAttributes;

    static {
        block4: {
            hasNatives = false;
            isUnicode = false;
            nativeAttributes = -1;
            try {
                System.loadLibrary("localfile_1_0_0");
                hasNatives = true;
                isUnicode = LocalFileNatives.internalIsUnicode();
                try {
                    nativeAttributes = LocalFileNatives.nativeAttributes();
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            catch (UnsatisfiedLinkError e) {
                if (!LocalFileNatives.isLibraryPresent()) break block4;
                LocalFileNatives.logMissingNativeLibrary(e);
            }
        }
    }

    private static boolean isLibraryPresent() {
        String libName = System.mapLibraryName("localfile_1_0_0");
        Enumeration<URL> entries = Activator.findEntries("/", libName, true);
        return entries != null && entries.hasMoreElements();
    }

    private static void logMissingNativeLibrary(UnsatisfiedLinkError e) {
        String libName = System.mapLibraryName("localfile_1_0_0");
        String message = NLS.bind(Messages.couldNotLoadLibrary, libName);
        Policy.log(1, message, e);
    }

    private static final native int nativeAttributes();

    public static int attributes() {
        return nativeAttributes;
    }

    private static final native boolean internalIsUnicode();

    public static boolean isUsingNatives() {
        return hasNatives;
    }
}

