/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class PlatformURLHandler
extends AbstractURLStreamHandlerService {
    private static Hashtable<String, Constructor<?>> connectionType = new Hashtable();

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        int ix;
        String spec = url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if ((ix = spec.indexOf("/")) == -1) {
            throw new MalformedURLException(NLS.bind(CommonMessages.url_invalidURL, url.toExternalForm()));
        }
        String type = spec.substring(0, ix);
        Constructor<?> construct = connectionType.get(type);
        if (construct == null) {
            throw new MalformedURLException(NLS.bind(CommonMessages.url_badVariant, type));
        }
        PlatformURLConnection connection = null;
        try {
            connection = (PlatformURLConnection)construct.newInstance(url);
        }
        catch (Exception e) {
            throw new IOException(NLS.bind(CommonMessages.url_createConnection, e.getMessage()));
        }
        connection.setResolvedURL(connection.resolve());
        return connection;
    }

    public static void register(String type, Class<?> connectionClass) {
        try {
            Constructor<?> c = connectionClass.getConstructor(URL.class);
            connectionType.put(type, c);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }
}

