/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.rangeapplier;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.srg2source.rangeapplier.ExceptorFile;
import net.minecraftforge.srg2source.rangeapplier.LocalVarFile;
import net.minecraftforge.srg2source.rangeapplier.RangeMap;
import net.minecraftforge.srg2source.rangeapplier.RenameMap;
import net.minecraftforge.srg2source.rangeapplier.SrgContainer;
import net.minecraftforge.srg2source.util.Util;
import net.minecraftforge.srg2source.util.io.ConfLogger;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.OutputSupplier;

public class RangeApplier
extends ConfLogger<RangeApplier> {
    private SrgContainer srg = new SrgContainer();
    private final RenameMap map = new RenameMap();
    private boolean keepImports = false;
    private InputSupplier input = null;
    private OutputSupplier output = null;
    private RangeMap range = null;
    private boolean annotate = false;

    public void readSrg(File srgs) {
        this.srg.readSrg(srgs);
        this.map.readSrg(this.srg);
    }

    public void readExc(File exceptor) {
        this.map.readParamMap(this.srg, new ExceptorFile(exceptor));
    }

    public void readLvRangeMap(File lvRangeMap) {
        try {
            this.map.readLocalVariableMap(new LocalVarFile(lvRangeMap), this.srg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setInput(InputSupplier value) {
        this.input = value;
    }

    public void setOutput(OutputSupplier value) {
        this.output = value;
    }

    public void readRangeMap(File value) {
        this.range = new RangeMap(value);
    }

    public void keepImports(boolean value) {
        this.keepImports = value;
    }

    public void annotate(boolean value) {
        this.annotate = value;
    }

    public void run() throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("Missing Range Apply input");
        }
        if (this.output == null) {
            throw new IllegalStateException("Missing Range Apply output");
        }
        if (this.range == null) {
            throw new IllegalStateException("Missing Range Apply range");
        }
        ArrayList<String> paths = new ArrayList<String>(this.range.keySet());
        Collections.sort(paths);
        this.log("Processing " + paths.size() + " files");
        for (String filePath : paths) {
            this.log("Start Processing: " + filePath);
            InputStream stream = this.input.getInput(filePath);
            if (stream == null) {
                this.log("Data not found: " + filePath);
                continue;
            }
            String data = new String(Util.readStream(stream), StandardCharsets.UTF_8);
            stream.close();
            List<String> out = this.processJavaSourceFile(filePath, data, this.range.get(filePath), this.annotate);
            filePath = out.get(0);
            data = out.get(1);
            OutputStream outStream = this.output.getOutput(filePath);
            outStream.write(data.getBytes(StandardCharsets.UTF_8));
            outStream.close();
            this.log("End  Processing: " + filePath);
            this.log("");
        }
        this.output.close();
    }

    private List<String> processJavaSourceFile(String fileName, String data, Collection<RangeMap.RangeEntry> rangeList, boolean shouldAnnotate) throws IOException {
        String newFileName;
        StringBuilder outData = new StringBuilder();
        outData.append(data);
        TreeSet<String> importsToAdd = new TreeSet<String>();
        int shift = 0;
        String oldTopLevelClassFullName = Util.getTopLevelClassForFilename(fileName);
        String oldTopLevelClassPackage = Util.splitPackageName(oldTopLevelClassFullName);
        String oldTopLevelClassName = Util.splitBaseName(oldTopLevelClassFullName);
        String newTopLevelClassPackage = Util.sourceName2Internal(this.map.maps.get("package " + oldTopLevelClassPackage));
        String newTopLevelClassFullName = Util.sourceName2Internal(this.map.maps.get("class " + oldTopLevelClassFullName), false);
        String newTopLevelClassName = Util.splitBaseName(newTopLevelClassFullName);
        if (newTopLevelClassName != null) {
            newTopLevelClassPackage = Util.splitPackageName(newTopLevelClassFullName);
        } else if (newTopLevelClassPackage != null) {
            newTopLevelClassName = oldTopLevelClassName;
        }
        if (newTopLevelClassPackage == null) {
            newTopLevelClassPackage = oldTopLevelClassPackage;
            newTopLevelClassName = oldTopLevelClassName;
        }
        String newTopLevelQualifiedName = (newTopLevelClassPackage + "/" + newTopLevelClassName).replace('\\', '/');
        for (RangeMap.RangeEntry info : rangeList) {
            String oldName;
            int end = info.end;
            String expectedOldText = info.expectedOldText;
            if (this.map.maps.containsKey(info.key) && this.map.maps.get(info.key).isEmpty()) {
                if (!info.key.startsWith("package ")) {
                    throw new RuntimeException("unable to remove non-package symbol " + info.key);
                }
                ++end;
                expectedOldText = expectedOldText + ".";
            }
            if (!(oldName = outData.substring(info.start + shift, end + shift)).equals(expectedOldText)) {
                throw new RuntimeException("Rename sanity check failed: expected '" + expectedOldText + "' at [" + info.start + "," + end + "] (shifted " + shift + " to [" + (shift + info.start) + "," + (shift + end) + "]) in " + fileName + ", but found '" + oldName + "'\nRegenerate symbol map on latest sources or start with fresh source and try again");
            }
            String newName = this.getNewName(info.key, oldName, this.map.maps, shouldAnnotate);
            if (newName == null) {
                newName = oldName;
            }
            if (info.key.startsWith("class ")) {
                String key = info.key;
                if (key.equals("class " + newName.replace('.', '/'))) {
                    key = null;
                } else if (newName.indexOf(46) > 0) {
                    for (int i = 0; i < Util.countChar(newName, '.'); ++i) {
                        key = Util.splitPackageName(key);
                    }
                    this.log("New Key: " + key);
                }
                if (key != null) {
                    String impt = key.substring(key.indexOf(32) + 1);
                    if (this.map.imports.containsKey(key)) {
                        impt = this.map.imports.get(key).replace('.', '/').replace('$', '/');
                    }
                    if (!info.qualified && this.needsImport(newTopLevelQualifiedName, impt)) {
                        if ((impt = impt.replace('/', '.').replace('$', '.')).indexOf(46) == -1) {
                            this.log("ERROR: Invalid import attempted, \"" + impt + "\"");
                        } else {
                            importsToAdd.add(impt);
                        }
                    }
                }
            }
            if (oldName.equals(newName)) continue;
            this.log("Rename " + info.key + "[" + (info.start + shift) + "," + (end + shift) + "]::" + oldName + "->" + newName);
            outData.replace(info.start + shift, end + shift, newName);
            shift += newName.length() - oldName.length();
        }
        String outString = this.updateImports(outData, importsToAdd, this.map.imports);
        if (!(fileName = fileName.replace('\\', '/')).equals(newFileName = newTopLevelQualifiedName + ".java")) {
            this.log("Rename file " + fileName + " -> " + newFileName);
            fileName = newFileName;
        }
        return Arrays.asList(fileName, outString);
    }

    private boolean needsImport(String topLevel, String reference) {
        if (reference.startsWith(topLevel)) {
            return false;
        }
        return !Util.splitPackageName(topLevel).equals(Util.splitPackageName(reference));
    }

    private String updateImports(StringBuilder data, Set<String> newImports, Map<String, String> importMap) {
        if (data.charAt(data.length() - 1) != '\n') {
            data.append('\n');
        }
        int lastIndex = 0;
        int nextIndex = data.indexOf("\n");
        boolean addedNewImports = false;
        boolean sawImports = false;
        int packageLine = -1;
        while (nextIndex > -1) {
            String line = data.substring(lastIndex, nextIndex);
            while ((line.isEmpty() || line.startsWith("\n")) && (nextIndex = data.indexOf("\n", ++lastIndex + 1)) != -1) {
                line = data.substring(lastIndex, nextIndex);
            }
            if (line.startsWith("package ")) {
                packageLine = nextIndex + 1;
            }
            if (line.startsWith("import ")) {
                sawImports = true;
                if (line.indexOf(42) > 0) {
                    LinkedList<String> remove = new LinkedList<String>();
                    String starter = line.replace("import ", "").replace(".*;", "").trim();
                    for (String imp : newImports) {
                        String impStart = imp.substring(0, imp.lastIndexOf(46));
                        if (!impStart.equals(starter)) continue;
                        remove.add(imp);
                    }
                    newImports.removeAll(remove);
                }
                String oldClass = line.replace("import ", "").replace(";", "").trim();
                Object newClass = importMap.get("class " + Util.sourceName2Internal(oldClass));
                if (newClass == null) {
                    newClass = oldClass;
                }
                newClass = ((String)newClass).replace('$', '.');
                this.log("Import: " + (String)newClass);
                if (!newImports.remove(newClass)) {
                    if (this.keepImports) {
                        lastIndex = nextIndex + 1;
                    } else {
                        data.delete(lastIndex, nextIndex + 1);
                    }
                    nextIndex = data.indexOf("\n", lastIndex);
                    continue;
                }
                if (!oldClass.equals(newClass)) {
                    int change = "import ".length();
                    data.replace(lastIndex, nextIndex, "import ");
                    data.insert(lastIndex + change, (String)newClass);
                    data.insert(lastIndex + (change += ((String)newClass).length()), ";");
                    nextIndex = lastIndex + change + 1;
                }
            } else if (sawImports && !addedNewImports) {
                this.filterImports(newImports);
                if (newImports.size() > 0) {
                    CharSequence sub = data.subSequence(lastIndex, data.length());
                    data.setLength(lastIndex);
                    for (String imp : newImports) {
                        data.append("import ").append(imp).append(";\n");
                    }
                    if (newImports.size() > 0) {
                        data.append('\n');
                    }
                    int change = data.length() - lastIndex;
                    lastIndex = data.length();
                    nextIndex += change;
                    data.append(sub);
                }
                addedNewImports = true;
                break;
            }
            lastIndex = nextIndex + 1;
            nextIndex = data.indexOf("\n", lastIndex + 1);
        }
        if (!addedNewImports) {
            this.filterImports(newImports);
            if (newImports.size() > 0) {
                int index = packageLine == -1 ? 0 : packageLine;
                CharSequence sub = data.subSequence(index, data.length());
                data.setLength(index);
                for (String imp : newImports) {
                    data.append("import ").append(imp).append(";\n");
                }
                if (newImports.size() > 0) {
                    data.append('\n');
                }
                data.append(sub);
            }
        }
        return data.toString();
    }

    private void filterImports(Set<String> newImports) {
        Iterator<String> itr = newImports.iterator();
        while (itr.hasNext()) {
            if (!itr.next().startsWith("java.lang.")) continue;
            itr.remove();
        }
        if (newImports.size() > 0) {
            this.log("Adding " + newImports.size() + " imports");
            for (String imp : newImports) {
                this.log("        " + imp);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getNewName(String key, String oldName, Map<String, String> renameMap, boolean shouldAnnotate) {
        String newName;
        if (!renameMap.containsKey(key)) {
            String constructorClassName = this.getConstructor(key);
            if (constructorClassName == null) return null;
            this.log("FOUND CONSTR " + key + " " + constructorClassName);
            if (!renameMap.containsKey("class " + constructorClassName)) return null;
            newName = Util.splitBaseName(Util.sourceName2Internal(renameMap.get("class " + constructorClassName), false));
        } else {
            newName = renameMap.get(key);
        }
        newName = Util.splitBaseName(newName, Util.countChar(oldName, '.'));
        if (!shouldAnnotate) return newName;
        return newName + "/* was " + oldName + "*/";
    }

    private String getConstructor(String key) {
        String[] tokens = key.split(" ", 3);
        if (!tokens[0].equals("method")) {
            return null;
        }
        if (tokens[2].charAt(tokens[2].length() - 1) != 'V') {
            return null;
        }
        String fullClassName = Util.splitPackageName(tokens[1]);
        String methodName = Util.splitBaseName(tokens[1]);
        String className = Util.splitBaseName(fullClassName);
        if (className.equals(methodName)) {
            return fullClassName;
        }
        return null;
    }
}

