/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.rangeapplier;

import java.io.File;
import java.io.Serializable;
import net.minecraftforge.srg2source.util.ListFile;

public class LocalVarFile
extends ListFile<LocalVar, LocalVarFile> {
    public LocalVarFile() {
    }

    public LocalVarFile(File src) {
        this.read(src);
    }

    @Override
    protected LocalVar parseLine(String line) {
        if (!line.startsWith("@")) {
            return null;
        }
        LocalVar var = new LocalVar(line);
        if (!var.kind.equals("localvar")) {
            return null;
        }
        return var;
    }

    public static final class LocalVar
    implements Serializable,
    Cloneable {
        public final int startRange;
        public final int endRange;
        public final int variableIndex;
        public final String absFileName;
        public final String expectedOldText;
        public final String kind;
        public final String mcpClassName;
        public final String mcpMethodName;
        public final String mcpMethodSig;
        public final String variableName;

        public LocalVar(String line) {
            String[] stuff = line.trim().split("\\|");
            this.absFileName = stuff[1];
            this.startRange = Integer.parseInt(stuff[2]);
            this.endRange = Integer.parseInt(stuff[3]);
            this.expectedOldText = stuff[4];
            this.kind = stuff[5];
            this.mcpClassName = stuff[6];
            this.mcpMethodName = stuff[7];
            this.mcpMethodSig = stuff[8];
            this.variableName = stuff[9];
            this.variableIndex = Integer.parseInt(stuff[10]);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.absFileName == null ? 0 : this.absFileName.hashCode());
            result = 31 * result + this.endRange;
            result = 31 * result + (this.expectedOldText == null ? 0 : this.expectedOldText.hashCode());
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + (this.mcpClassName == null ? 0 : this.mcpClassName.hashCode());
            result = 31 * result + (this.mcpMethodName == null ? 0 : this.mcpMethodName.hashCode());
            result = 31 * result + (this.mcpMethodSig == null ? 0 : this.mcpMethodSig.hashCode());
            result = 31 * result + this.startRange;
            result = 31 * result + this.variableIndex;
            result = 31 * result + (this.variableName == null ? 0 : this.variableName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocalVar other = (LocalVar)obj;
            if (this.absFileName == null ? other.absFileName != null : !this.absFileName.equals(other.absFileName)) {
                return false;
            }
            if (this.endRange != other.endRange) {
                return false;
            }
            if (this.expectedOldText == null ? other.expectedOldText != null : !this.expectedOldText.equals(other.expectedOldText)) {
                return false;
            }
            if (this.kind == null ? other.kind != null : !this.kind.equals(other.kind)) {
                return false;
            }
            if (this.mcpClassName == null ? other.mcpClassName != null : !this.mcpClassName.equals(other.mcpClassName)) {
                return false;
            }
            if (this.mcpMethodName == null ? other.mcpMethodName != null : !this.mcpMethodName.equals(other.mcpMethodName)) {
                return false;
            }
            if (this.mcpMethodSig == null ? other.mcpMethodSig != null : !this.mcpMethodSig.equals(other.mcpMethodSig)) {
                return false;
            }
            if (this.startRange != other.startRange) {
                return false;
            }
            if (this.variableIndex != other.variableIndex) {
                return false;
            }
            return !(this.variableName == null ? other.variableName != null : !this.variableName.equals(other.variableName));
        }
    }
}

