/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.ast;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class SrgFile {
    private File source;
    private HashMap<String, Class> classes = new HashMap();
    private HashMap<String, Class> rclasses = new HashMap();

    public SrgFile(File source) {
        this.source = source;
    }

    public Class getClass2(String name) {
        return this.rclasses.get(name);
    }

    public Class getClass(String name, String rename) {
        if (!this.classes.containsKey(name)) {
            Class cls = new Class(this, name, rename);
            this.classes.put(name, cls);
            this.rclasses.put(rename, cls);
        }
        return this.classes.get(name);
    }

    public SrgFile read() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.source));
        String line = null;
        while ((line = reader.readLine()) != null) {
            Class cls;
            String name2;
            String name1;
            String cls2;
            String cls1;
            String[] pts = line.split(" ");
            if (pts[0].equals("CL:")) {
                this.getClass(pts[1], pts[2]);
                continue;
            }
            if (pts[0].equals("FD:")) {
                cls1 = pts[1].substring(0, pts[1].lastIndexOf(47));
                cls2 = pts[2].substring(0, pts[2].lastIndexOf(47));
                name1 = pts[1].substring(cls1.length() + 1);
                name2 = pts[2].substring(cls2.length() + 1);
                cls = this.getClass(cls1, cls2);
                cls.fields1.put(name1, new Node(cls, name1, null, name2, null));
                cls.fields2.put(name2, new Node(cls, name2, null, name1, null));
                continue;
            }
            if (!pts[0].equals("MD:")) continue;
            cls1 = pts[1].substring(0, pts[1].lastIndexOf(47));
            cls2 = pts[3].substring(0, pts[3].lastIndexOf(47));
            name1 = pts[1].substring(cls1.length() + 1);
            name2 = pts[3].substring(cls2.length() + 1);
            cls = this.getClass(cls1, cls2);
            cls.methods1.put(name1 + pts[2], new Node(cls, name1, pts[2], name2, pts[4]));
            cls.methods2.put(name2 + pts[4], new Node(cls, name2, pts[4], name1, pts[2]));
        }
        reader.close();
        return this;
    }

    public static class Class {
        public SrgFile file;
        public String name;
        public String rename;
        public HashMap<String, Node> fields1 = new HashMap();
        public HashMap<String, Node> fields2 = new HashMap();
        public HashMap<String, Node> methods1 = new HashMap();
        public HashMap<String, Node> methods2 = new HashMap();

        public Class(SrgFile file, String name, String rename) {
            this.file = file;
            this.name = name;
            this.rename = rename;
        }
    }

    public static class Node
    implements Comparable<Node> {
        public Class owner;
        public final String name;
        public final String desc;
        public final String rename;
        public final String renameDesc;

        public Node(Class owner, String name, String desc, String rename, String renameDesc) {
            this.name = name;
            this.desc = desc;
            this.renameDesc = renameDesc;
            this.owner = owner;
            this.rename = rename;
        }

        public String toString() {
            return String.format("%s %s", this.name, this.desc);
        }

        public boolean equals(Object o) {
            if (o instanceof Node) {
                Node t = (Node)o;
                if (this.desc != null) {
                    return t.desc != null && t.name.equals(this.name) && t.desc.equals(this.desc);
                }
                return t.desc == null && t.name.equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ (this.desc != null ? this.desc.hashCode() : 0);
        }

        @Override
        public int compareTo(Node o) {
            return this.name.compareTo(o.name);
        }
    }
}

