/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.ast;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class FixTypes
implements Comparable<FixTypes> {
    protected int start = 0;
    protected int length = 0;
    protected String newText = null;

    private FixTypes(ASTNode ast) {
        this.start = ast.getStartPosition();
        this.length = ast.getLength();
    }

    private FixTypes(int start, int length, String newText) {
        this.start = start;
        this.length = length;
        this.newText = newText;
    }

    public static Modifier findAccessor(BodyDeclaration node) {
        for (IExtendedModifier m : node.modifiers()) {
            Modifier mod;
            if (!(m instanceof Modifier) || !(mod = (Modifier)m).isPrivate() && !mod.isProtected()) continue;
            return mod;
        }
        return null;
    }

    @Override
    public int compareTo(FixTypes o) {
        return this.start - o.start;
    }

    public int getLength() {
        return this.length;
    }

    public int getStart() {
        return this.start;
    }

    public String toString() {
        return this.getClass().getName() + " " + this.getStart() + " " + this.getLength();
    }

    public static class Cast
    extends FixTypes {
        public Cast(int start, int length, String newText) {
            super(start, length, newText);
        }
    }

    public static class BounceMethod
    extends FixTypes {
        public BounceMethod(TypeDeclaration node, String newName, String oldName, String[] args, Class<?> returnType) {
            this(node, newName, oldName, args, returnType.getName());
        }

        public BounceMethod(TypeDeclaration node, String newName, String oldName, String[] args, String returnType) {
            super(node);
            int x;
            this.start = node.getStartPosition() + node.getLength() - 1;
            this.length = 0;
            StringBuffer buf = new StringBuffer();
            buf.append("    public ").append(returnType).append(' ').append(newName).append('(');
            for (x = 0; x < args.length; ++x) {
                buf.append(args[x]).append(' ').append((char)(97 + x));
                if (x == args.length - 1) continue;
                buf.append(", ");
            }
            buf.append("){\n        ");
            if (!returnType.equals("void")) {
                buf.append("return ");
            }
            buf.append(oldName).append('(');
            for (x = 0; x < args.length; ++x) {
                buf.append((char)(97 + x));
                if (x == args.length - 1) continue;
                buf.append(", ");
            }
            buf.append(");\n    }\n");
            this.newText = buf.toString();
        }
    }

    public static class PublicField
    extends FixTypes {
        public PublicField(FieldDeclaration node) {
            super(node);
            Modifier target = FixTypes.findAccessor(node);
            this.newText = "public ";
            if (target == null) {
                this.start = node.getType().getStartPosition();
                this.length = 0;
            } else {
                this.start = target.getStartPosition();
                this.length = target.getLength() + 1;
            }
        }
    }

    public static class PublicMethod
    extends FixTypes {
        public PublicMethod(int start, int length, String newText) {
            super(start, length, newText);
        }
    }

    public static class RemoveMethod
    extends FixTypes {
        public RemoveMethod(MethodDeclaration node) {
            super(node);
            this.newText = "/*\n" + node.toString() + "*/";
        }
    }
}

