/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.api;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.srg2source.api.SourceVersion;
import net.minecraftforge.srg2source.ast.RangeExtractor;
import net.minecraftforge.srg2source.util.io.ChainedInputSupplier;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;

public class RangeExtractorBuilder {
    private SourceVersion sourceVersion = SourceVersion.JAVA_1_8;
    private PrintStream logStd = System.out;
    private PrintStream logErr = System.err;
    private PrintWriter output = null;
    private boolean batch = true;
    private List<File> libraries = new ArrayList<File>();
    private List<InputSupplier> inputs = new ArrayList<InputSupplier>();
    private File cache = null;

    public RangeExtractorBuilder sourceCompatibility(SourceVersion value) {
        this.sourceVersion = value;
        return this;
    }

    public RangeExtractorBuilder output(File value) {
        try {
            if (!value.exists()) {
                File parent = value.getCanonicalFile().getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                value.createNewFile();
            }
            return this.output(new PrintWriter(new BufferedWriter(new FileWriter(value))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RangeExtractorBuilder output(PrintWriter value) {
        if (this.output != null) {
            this.output.close();
        }
        this.output = value;
        return this;
    }

    public RangeExtractorBuilder batch(boolean value) {
        this.batch = true;
        return this;
    }

    public RangeExtractorBuilder library(File value) {
        this.libraries.add(value);
        return this;
    }

    public RangeExtractorBuilder input(File value) {
        if (value == null || !value.exists()) {
            throw new IllegalArgumentException("Invalid input value: " + value);
        }
        String filename = value.getName().toLowerCase(Locale.ENGLISH);
        if (value.isDirectory()) {
            this.inputs.add(new FolderSupplier(value));
        } else if (filename.endsWith(".jar") || filename.endsWith(".zip")) {
            try {
                this.inputs.add(new ZipInputSupplier(value));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Invalid input value: " + value);
        }
        return this;
    }

    public RangeExtractor build() {
        RangeExtractor ret = new RangeExtractor();
        ret.setLogger(this.logStd);
        ret.setErrorLogger(this.logErr);
        if (this.output != null) {
            ret.setOutput(this.output);
        }
        ret.setSourceCompatibility(this.sourceVersion);
        ret.setBatchASTs(this.batch);
        this.libraries.forEach(ret::addLibrary);
        if (this.inputs.size() == 1) {
            ret.setInput(this.inputs.get(0));
        } else {
            ret.setInput(new ChainedInputSupplier(this.inputs));
        }
        if (this.cache != null) {
            try (FileInputStream fin = new FileInputStream(this.cache);){
                ret.loadCache(fin);
            }
            catch (IOException e) {
                System.out.println("Error Loading Caching: " + this.cache);
                e.printStackTrace();
            }
        }
        return ret;
    }
}

