/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.api;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.srg2source.rangeapplier.RangeApplier;
import net.minecraftforge.srg2source.util.io.ChainedInputSupplier;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;
import net.minecraftforge.srg2source.util.io.ZipOutputSupplier;

public class RangeApplierBuilder {
    private PrintStream logStd = System.out;
    private PrintStream logErr = System.err;
    private List<InputSupplier> inputs = new ArrayList<InputSupplier>();
    private File output = null;
    private File range = null;
    private List<File> srgs = new ArrayList<File>();
    private List<File> excs = new ArrayList<File>();
    private boolean keepImports = false;
    private boolean annotate = false;
    private File rangeOld = null;

    public RangeApplierBuilder output(File value) {
        this.output = value;
        return this;
    }

    public RangeApplierBuilder srg(File value) {
        this.srgs.add(value);
        return this;
    }

    public RangeApplierBuilder exc(File value) {
        this.excs.add(value);
        return this;
    }

    public RangeApplierBuilder input(File value) {
        if (value == null || !value.exists()) {
            throw new IllegalArgumentException("Invalid input value: " + value);
        }
        String filename = value.getName().toLowerCase(Locale.ENGLISH);
        if (value.isDirectory()) {
            this.inputs.add(new FolderSupplier(value));
        } else if (filename.endsWith(".jar") || filename.endsWith(".zip")) {
            try {
                this.inputs.add(new ZipInputSupplier(value));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Invalid input value: " + value);
        }
        return this;
    }

    public RangeApplierBuilder range(File value) {
        this.range = value;
        return this;
    }

    public RangeApplierBuilder lvrange(File value) {
        this.rangeOld = value;
        return this;
    }

    public RangeApplier build() {
        if (this.output == null) {
            throw new IllegalStateException("Builder State Exception: Missing Output");
        }
        if (this.range == null) {
            throw new IllegalArgumentException("Builder State Exception: Missing Range Map");
        }
        RangeApplier ret = new RangeApplier();
        ret.setLogger(this.logStd);
        ret.setErrorLogger(this.logErr);
        if (this.inputs.size() == 1) {
            ret.setInput(this.inputs.get(0));
        } else {
            ret.setInput(new ChainedInputSupplier(this.inputs));
        }
        if (this.output.isDirectory()) {
            ret.setOutput(new FolderSupplier(this.output));
        } else {
            try {
                ret.setOutput(new ZipOutputSupplier(this.output));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ret.readRangeMap(this.range);
        this.srgs.forEach(ret::readSrg);
        this.excs.forEach(ret::readExc);
        ret.annotate(this.annotate);
        ret.keepImports(this.keepImports);
        if (this.rangeOld != null) {
            ret.readLvRangeMap(this.rangeOld);
        }
        return ret;
    }
}

