/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConverter;
import net.minecraftforge.srg2source.api.RangeExtractorBuilder;
import net.minecraftforge.srg2source.api.SourceVersion;

public class RangeExtractMain {
    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> libArg = parser.acceptsAll(Arrays.asList("e", "lib")).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> inputArg = parser.acceptsAll(Arrays.asList("in", "input")).withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> outputArg = parser.acceptsAll(Arrays.asList("out", "output")).withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<Boolean> batch = parser.accepts("batch").withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<SourceVersion> jversionArg = parser.acceptsAll(Arrays.asList("sc", "source-compatibility")).withRequiredArg().ofType(SourceVersion.class).defaultsTo(SourceVersion.JAVA_1_8, (SourceVersion[])new SourceVersion[0]).withValuesConvertedBy(new ValueConverter<SourceVersion>(){

            @Override
            public SourceVersion convert(String value) {
                return SourceVersion.parse(value);
            }

            @Override
            public Class<? extends SourceVersion> valueType() {
                return SourceVersion.class;
            }

            @Override
            public String valuePattern() {
                ArrayList<String> ret = new ArrayList<String>();
                for (SourceVersion v : SourceVersion.values()) {
                    ret.add(v.name());
                    ret.add(v.getSpec());
                }
                return ret.stream().collect(Collectors.joining(","));
            }
        });
        try {
            OptionSet options = parser.parse(args);
            System.out.println("Compat: " + (Object)((Object)options.valueOf(jversionArg)));
            System.out.println("Output: " + options.valueOf(outputArg));
            System.out.println("Batch:  " + options.valueOf(batch));
            RangeExtractorBuilder builder = new RangeExtractorBuilder().sourceCompatibility(options.valueOf(jversionArg)).output(options.valueOf(outputArg)).batch(options.valueOf(batch));
            if (options.has(libArg)) {
                options.valuesOf(libArg).forEach(v -> {
                    System.out.println("Lib:    " + v);
                    builder.library((File)v);
                });
            }
            options.valuesOf(inputArg).forEach(v -> {
                System.out.println("Input:  " + v);
                builder.input((File)v);
            });
            builder.build().run();
        }
        catch (OptionException e) {
            parser.printHelpOn(System.out);
            e.printStackTrace();
        }
    }
}

