/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractMapBasedMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;

public final class Multimaps {
    public static <K, V> Multimap<K, V> newMultimap(Map<K, Collection<V>> map, Supplier<? extends Collection<V>> factory) {
        return new CustomMultimap<K, V>(map, factory);
    }

    static boolean equalsImpl(Multimap<?, ?> multimap, Object object) {
        if (object == multimap) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap that = (Multimap)object;
            return multimap.asMap().equals(that.asMap());
        }
        return false;
    }

    private static class CustomMultimap<K, V>
    extends AbstractMapBasedMultimap<K, V> {
        transient Supplier<? extends Collection<V>> factory;

        CustomMultimap(Map<K, Collection<V>> map, Supplier<? extends Collection<V>> factory) {
            super(map);
            this.factory = Preconditions.checkNotNull(factory);
        }

        @Override
        Set<K> createKeySet() {
            return this.createMaybeNavigableKeySet();
        }

        @Override
        Map<K, Collection<V>> createAsMap() {
            return this.createMaybeNavigableAsMap();
        }

        @Override
        protected Collection<V> createCollection() {
            return this.factory.get();
        }

        @Override
        <E> Collection<E> unmodifiableCollectionSubclass(Collection<E> collection) {
            if (collection instanceof NavigableSet) {
                return Sets.unmodifiableNavigableSet((NavigableSet)collection);
            }
            if (collection instanceof SortedSet) {
                return Collections.unmodifiableSortedSet((SortedSet)collection);
            }
            if (collection instanceof Set) {
                return Collections.unmodifiableSet((Set)collection);
            }
            if (collection instanceof List) {
                return Collections.unmodifiableList((List)collection);
            }
            return Collections.unmodifiableCollection(collection);
        }

        @Override
        Collection<V> wrapCollection(K key, Collection<V> collection) {
            if (collection instanceof List) {
                return this.wrapList(key, (List)collection, null);
            }
            if (collection instanceof NavigableSet) {
                return (AbstractMapBasedMultimap)this.new AbstractMapBasedMultimap.WrappedNavigableSet(key, (NavigableSet)collection, null);
            }
            if (collection instanceof SortedSet) {
                return (AbstractMapBasedMultimap)this.new AbstractMapBasedMultimap.WrappedSortedSet(key, (SortedSet)collection, null);
            }
            if (collection instanceof Set) {
                return new AbstractMapBasedMultimap.WrappedSet(key, (Set)collection);
            }
            return new AbstractMapBasedMultimap.WrappedCollection(key, collection, null);
        }
    }
}

