/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class InsnList {
    private int size;
    private AbstractInsnNode firstInsn;
    private AbstractInsnNode lastInsn;
    AbstractInsnNode[] cache;

    public int size() {
        return this.size;
    }

    public AbstractInsnNode getLast() {
        return this.lastInsn;
    }

    public void accept(MethodVisitor methodVisitor) {
        AbstractInsnNode currentInsn = this.firstInsn;
        while (currentInsn != null) {
            currentInsn.accept(methodVisitor);
            currentInsn = currentInsn.nextInsn;
        }
    }

    public void add(AbstractInsnNode insnNode) {
        ++this.size;
        if (this.lastInsn == null) {
            this.firstInsn = insnNode;
            this.lastInsn = insnNode;
        } else {
            this.lastInsn.nextInsn = insnNode;
            insnNode.previousInsn = this.lastInsn;
        }
        insnNode.nextInsn = null;
        this.lastInsn = insnNode;
        this.cache = null;
        insnNode.index = 0;
    }

    public void resetLabels() {
        AbstractInsnNode currentInsn = this.firstInsn;
        while (currentInsn != null) {
            if (currentInsn instanceof LabelNode) {
                ((LabelNode)currentInsn).resetLabel();
            }
            currentInsn = currentInsn.nextInsn;
        }
    }
}

